/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.scalability.benchmarks;

import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.jackrabbit.oak.benchmark.util.Date;
import org.apache.jackrabbit.oak.scalability.benchmarks.SearchScalabilityBenchmark;
import org.apache.jackrabbit.oak.scalability.suites.ScalabilityAbstractSuite;

public class LastModifiedSearcher
extends SearchScalabilityBenchmark {
    private final Date timeframe;

    public LastModifiedSearcher(Date timeframe) {
        this.timeframe = timeframe;
    }

    @Override
    protected Query getQuery(QueryManager qm, ScalabilityAbstractSuite.ExecutionContext context) throws RepositoryException {
        String path = (String)context.getMap().get("rootNodeName");
        String statement = "/jcr:root/" + path + "//element(*, " + context.getMap().get("nodeType") + ")[(jcr:content/@jcr:lastModified >= xs:dateTime('" + this.timeframe.toISO_8601_2000() + "'))]";
        LOG.debug("LastModifiedSearcher: {}", (Object)statement);
        return qm.createQuery(statement, "xpath");
    }

    @Override
    public String toString() {
        String s = "::";
        switch (this.timeframe) {
            case LAST_2_HRS: {
                s = s + "Hour";
                break;
            }
            case LAST_24_HRS: {
                s = s + "Day";
                break;
            }
            case LAST_7_DAYS: {
                s = s + "Week";
                break;
            }
            case LAST_MONTH: {
                s = s + "Month";
                break;
            }
            case LAST_YEAR: {
                s = s + "Year";
                break;
            }
        }
        return super.toString() + s;
    }
}

