/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.scalability.benchmarks;

import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.oak.scalability.benchmarks.MultiFilterOrderBySearcher;
import org.apache.jackrabbit.oak.scalability.suites.ScalabilityAbstractSuite;

public class MultiFilterSplitOrderBySearcher
extends MultiFilterOrderBySearcher {
    @Override
    protected void search(QueryManager qm, ScalabilityAbstractSuite.ExecutionContext context) throws RepositoryException {
        this.searchCommon(qm, context);
        Query q = this.getQuery(qm, context);
        QueryResult r = q.execute();
        RowIterator it = r.getRows();
        for (int rows = 0; it.hasNext() && rows < LIMIT; ++rows) {
            Node node = it.nextRow().getNode();
            LOG.debug(node.getPath());
        }
    }

    protected void searchCommon(QueryManager qm, ScalabilityAbstractSuite.ExecutionContext context) throws RepositoryException {
        Query stdQuery = this.getStandardQuery(qm, context);
        stdQuery.setLimit(LIMIT);
        QueryResult stdResult = stdQuery.execute();
        RowIterator stdIt = stdResult.getRows();
        for (int rows = 0; stdIt.hasNext() && rows < LIMIT; ++rows) {
            Node node = stdIt.nextRow().getNode();
            LOG.debug(node.getPath());
        }
    }

    protected Query getStandardQuery(@Nonnull QueryManager qm, ScalabilityAbstractSuite.ExecutionContext context) throws RepositoryException {
        StringBuilder statement = new StringBuilder("/jcr:root/");
        statement.append((String)context.getMap().get("rootNodeName")).append("//element(*, ").append(context.getMap().get("rootType")).append(")");
        statement.append("[(").append("@").append("viewed").append("= 'true'");
        statement.append(")]");
        LOG.debug("{}", (Object)statement);
        return qm.createQuery(statement.toString(), "xpath");
    }

    @Override
    protected String getOrderByClause() {
        return " order by @added descending";
    }
}

