/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.scalability.benchmarks;

import java.util.Calendar;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.oak.scalability.benchmarks.SearchScalabilityBenchmark;
import org.apache.jackrabbit.oak.scalability.suites.ScalabilityAbstractSuite;

public abstract class PaginationEnabledSearcher
extends SearchScalabilityBenchmark {
    protected static final int LIMIT = Integer.getInteger("limit", 25);
    protected static final int PAGES = Integer.getInteger("pages", 5);
    protected static final String KEYSET_VAL_PROP = "keysetval";

    protected void processResultsOffsetPagination(@Nonnull QueryManager qm, ScalabilityAbstractSuite.ExecutionContext context) throws RepositoryException {
        for (int page = 0; page < PAGES; ++page) {
            Query query = this.getQuery(qm, context);
            query.setLimit(LIMIT);
            query.setOffset(page * LIMIT);
            this.iterate(query);
        }
    }

    private Node iterate(Query query) throws RepositoryException {
        QueryResult r = query.execute();
        RowIterator it = r.getRows();
        Node last = null;
        while (it.hasNext()) {
            last = it.nextRow().getNode();
            LOG.debug(last.getPath());
        }
        return last;
    }

    protected void processResultsKeysetPagination(@Nonnull QueryManager qm, ScalabilityAbstractSuite.ExecutionContext context) throws RepositoryException {
        Calendar now = Calendar.getInstance();
        now.setTimeZone(TimeZone.getTimeZone("GMT"));
        context.getMap().put(KEYSET_VAL_PROP, now);
        for (int page = 0; page < PAGES; ++page) {
            Query query = this.getQuery(qm, context);
            query.setLimit(LIMIT);
            Node lastNode = this.iterate(query);
            if (lastNode == null) continue;
            Property prop = lastNode.getProperty("added");
            context.getMap().put(KEYSET_VAL_PROP, prop.getDate());
        }
        context.getMap().remove(KEYSET_VAL_PROP);
    }

    protected String getOrderByClause() {
        return " order by @viewed descending, @added descending";
    }
}

