/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.scalability.benchmarks;

import javax.annotation.Nonnull;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.oak.scalability.benchmarks.ScalabilityBenchmark;
import org.apache.jackrabbit.oak.scalability.suites.ScalabilityAbstractSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SearchScalabilityBenchmark
extends ScalabilityBenchmark {
    protected static final Logger LOG = LoggerFactory.getLogger(SearchScalabilityBenchmark.class);
    private static final int MAX_RESULTS = Integer.getInteger("maxResults", 100);

    @Override
    public void execute(Repository repository, Credentials credentials, ScalabilityAbstractSuite.ExecutionContext context) throws Exception {
        Session session = repository.login(credentials);
        try {
            QueryManager qm = session.getWorkspace().getQueryManager();
            this.search(qm, context);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    protected void search(QueryManager qm, ScalabilityAbstractSuite.ExecutionContext context) throws RepositoryException {
        Query q = this.getQuery(qm, context);
        QueryResult r = q.execute();
        RowIterator it = r.getRows();
        for (int rows = 0; it.hasNext() && rows < MAX_RESULTS; ++rows) {
            Node node = it.nextRow().getNode();
            LOG.debug(node.getPath());
        }
    }

    protected abstract Query getQuery(@Nonnull QueryManager var1, ScalabilityAbstractSuite.ExecutionContext var2) throws RepositoryException;
}

