/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.scalability.suites;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math.stat.descriptive.SynchronizedDescriptiveStatistics;
import org.apache.jackrabbit.oak.benchmark.CSVResultGenerator;
import org.apache.jackrabbit.oak.benchmark.util.Profiler;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;
import org.apache.jackrabbit.oak.scalability.ScalabilitySuite;
import org.apache.jackrabbit.oak.scalability.benchmarks.ScalabilityBenchmark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScalabilityAbstractSuite
implements ScalabilitySuite,
CSVResultGenerator {
    public static final String CTX_SEARCH_PATHS_PROP = "searchPaths";
    protected static final Logger LOG = LoggerFactory.getLogger(ScalabilityAbstractSuite.class);
    protected static final String TEST_ID = Integer.toHexString(new Random().nextInt());
    protected static final boolean PROFILE = Boolean.getBoolean("profile");
    protected static final boolean WARMUP = !Boolean.getBoolean("noWarmup");
    protected static final List<String> INCREMENTS = Splitter.on(",").trimResults().omitEmptyStrings().splitToList(System.getProperty("increments", "1,2,5"));
    protected static final Credentials CREDENTIALS = new SimpleCredentials("admin", "admin".toCharArray());
    private PrintStream out;
    protected Map<String, ScalabilityBenchmark> benchmarks = Maps.newLinkedHashMap();
    private Repository repository;
    private Credentials credentials;
    private LinkedList<Session> sessions;
    ExecutionContext context;
    private Result result;
    private volatile boolean running;
    private List<Thread> threads;
    private RepositoryFixture fixture;

    protected ScalabilityAbstractSuite() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Iterable<RepositoryFixture> fixtures) {
        for (RepositoryFixture fixture : fixtures) {
            try {
                Repository[] cluster = this.createRepository(fixture);
                try {
                    this.runSuite(fixture, cluster[0]);
                }
                finally {
                    fixture.tearDownCluster();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSuite(RepositoryFixture fixture, Repository repository) throws Exception {
        this.setUp(repository, fixture, CREDENTIALS);
        try {
            for (String increment : INCREMENTS) {
                this.context.setIncrement(Integer.parseInt(increment.trim()));
                this.setupIteration(increment);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Started test");
                }
                this.runIteration(this.context);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Finished test");
                }
                this.tearDownIteration();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.tearDown();
        }
    }

    private void setupIteration(String increment) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Start load : " + increment);
        }
        this.initBackgroundJobs();
        this.beforeIteration(this.context);
        if (WARMUP) {
            for (ScalabilityBenchmark benchmark : this.benchmarks.values()) {
                this.executeBenchmark(benchmark, this.context);
            }
        }
    }

    private void tearDownIteration() throws Exception {
        this.shutdownBackgroundJobs();
        this.afterIteration();
    }

    protected void beforeSuite() throws Exception {
        if (PROFILE) {
            this.context.startProfiler();
        }
    }

    public void setUp(Repository repository, RepositoryFixture fixture, Credentials credentials) throws Exception {
        this.repository = repository;
        this.credentials = credentials;
        this.sessions = new LinkedList();
        this.fixture = fixture;
        this.context = new ExecutionContext();
        this.result = new Result();
        this.beforeSuite();
    }

    protected void afterSuite() throws Exception {
    }

    public void tearDown() throws Exception {
        this.context.stopProfiler();
        this.result.out();
        this.afterSuite();
        for (Session session : this.sessions) {
            if (!session.isLive()) continue;
            session.logout();
        }
        this.threads = null;
        this.sessions = null;
        this.credentials = null;
        this.repository = null;
        this.context = null;
        this.result = null;
        this.benchmarks = null;
    }

    @Override
    public boolean removeBenchmark(String benchmark) {
        return this.benchmarks.remove(benchmark) != null;
    }

    @Override
    public Map<String, ScalabilityBenchmark> getBenchmarks() {
        return this.benchmarks;
    }

    protected abstract void executeBenchmark(ScalabilityBenchmark var1, ExecutionContext var2) throws Exception;

    private void runIteration(ExecutionContext context) throws Exception {
        Preconditions.checkArgument(this.benchmarks != null && !this.benchmarks.isEmpty(), "No Benchmarks configured");
        for (String key : this.benchmarks.keySet()) {
            ScalabilityBenchmark benchmark = this.benchmarks.get(key);
            if (this.result.getBenchmarkStatistics(benchmark) == null) {
                this.result.addBenchmarkStatistics(benchmark, new SynchronizedDescriptiveStatistics());
            }
            Stopwatch watch = Stopwatch.createStarted();
            this.executeBenchmark(benchmark, context);
            watch.stop();
            this.result.getBenchmarkStatistics(benchmark).addValue(watch.elapsed(TimeUnit.MILLISECONDS));
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Execution time for " + benchmark + "-" + watch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    public void beforeIteration(ExecutionContext context) throws Exception {
    }

    protected void afterIteration() throws Exception {
    }

    protected void addBackgroundJob(final Runnable job) {
        Thread thread = new Thread("Background job " + job){

            @Override
            public void run() {
                while (ScalabilityAbstractSuite.this.running) {
                    job.run();
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        this.threads.add(thread);
    }

    protected void initBackgroundJobs() {
        this.running = true;
        this.threads = Lists.newArrayList();
    }

    protected void shutdownBackgroundJobs() throws InterruptedException {
        this.running = false;
        for (Thread thread : this.threads) {
            thread.join();
        }
    }

    protected Repository[] createRepository(RepositoryFixture fixture) throws Exception {
        return fixture.setUpCluster(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session loginWriter() {
        try {
            Session session = this.repository.login(this.credentials);
            LinkedList<Session> linkedList = this.sessions;
            synchronized (linkedList) {
                this.sessions.add(session);
            }
            return session;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    @Override
    public void setPrintStream(PrintStream out) {
        this.out = out;
    }

    protected Repository getRepository() {
        return this.repository;
    }

    public static class ExecutionContext {
        private Profiler profiler;
        private final AtomicLong iteration = new AtomicLong();
        private Map<Object, Object> map = Maps.newConcurrentMap();

        protected void setIncrement(int increment) {
            this.iteration.getAndSet(increment);
        }

        public int getIncrement() {
            return this.iteration.intValue();
        }

        public void startProfiler() {
            this.profiler = new Profiler().startCollecting();
        }

        public void stopProfiler() {
            if (this.profiler != null) {
                LOG.info(this.profiler.stopCollecting().getTop(5));
                this.profiler = null;
            }
        }

        public Map<Object, Object> getMap() {
            return this.map;
        }

        public void setMap(Map<Object, Object> map) {
            this.map = map;
        }
    }

    class Result {
        private final Map<ScalabilityBenchmark, DescriptiveStatistics> stats = Maps.newLinkedHashMap();

        public void addBenchmarkStatistics(ScalabilityBenchmark benchmark, SynchronizedDescriptiveStatistics stat) {
            this.stats.put(benchmark, stat);
        }

        public DescriptiveStatistics getBenchmarkStatistics(ScalabilityBenchmark benchmark) {
            return this.stats.get(benchmark);
        }

        public void out() {
            for (Map.Entry<ScalabilityBenchmark, DescriptiveStatistics> entry : this.stats.entrySet()) {
                DescriptiveStatistics statistics = entry.getValue();
                ScalabilityBenchmark benchmark = entry.getKey();
                System.out.format("# %-26.26s       min     10%%     50%%     90%%     max       N%n", benchmark.toString());
                if (ScalabilityAbstractSuite.this.out != null) {
                    ScalabilityAbstractSuite.this.out.format("# %-26.26s       min     10%%     50%%     90%%     max       N%n", benchmark.toString());
                }
                System.out.format("%-30.30s  %6.0f  %6.0f  %6.0f  %6.0f  %6.0f  %6d%n", ScalabilityAbstractSuite.this.fixture.toString(), statistics.getMin(), statistics.getPercentile(10.0), statistics.getPercentile(50.0), statistics.getPercentile(90.0), statistics.getMax(), statistics.getN());
                if (ScalabilityAbstractSuite.this.out != null) {
                    ScalabilityAbstractSuite.this.out.format("%-30.30s  %-6.0f  %-6.0f  %-6.0f  %-6.0f  %-6.0f  %-6d%n", ScalabilityAbstractSuite.this.fixture.toString(), statistics.getMin(), statistics.getPercentile(10.0), statistics.getPercentile(50.0), statistics.getPercentile(90.0), statistics.getMax(), statistics.getN());
                }
                StringBuilder header = new StringBuilder();
                header.append("\t# %-26.26s");
                for (String increment : INCREMENTS) {
                    header.append("\t");
                    header.append(increment);
                }
                header.append("%n");
                System.out.format(header.toString(), "Iterations/Load");
                StringBuffer format = new StringBuffer();
                format.append("%-30.30s");
                System.out.format(format.toString(), "\tTime (ms)");
                if (ScalabilityAbstractSuite.this.out != null) {
                    ScalabilityAbstractSuite.this.out.format(format.toString(), "\tTime (ms)");
                }
                for (int idx = 0; idx < INCREMENTS.size(); ++idx) {
                    format = new StringBuffer();
                    format.append("\t");
                    format.append("%-7.0f");
                    System.out.format(format.toString(), statistics.getValues()[idx]);
                    if (ScalabilityAbstractSuite.this.out == null) continue;
                    ScalabilityAbstractSuite.this.out.format(format.toString(), statistics.getValues()[idx]);
                }
                System.out.format("%n", new Object[0]);
            }
        }
    }
}

