/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.scalability.suites;

import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.math.stat.descriptive.SynchronizedDescriptiveStatistics;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.oak.benchmark.TestInputStream;
import org.apache.jackrabbit.oak.benchmark.util.Date;
import org.apache.jackrabbit.oak.benchmark.util.MimeType;
import org.apache.jackrabbit.oak.benchmark.util.OakIndexUtils;
import org.apache.jackrabbit.oak.scalability.suites.ScalabilityAbstractSuite;
import org.apache.jackrabbit.oak.scalability.suites.ScalabilityNodeSuite;
import org.apache.jackrabbit.oak.scalability.util.NodeTypeUtils;

public class ScalabilityBlobSearchSuite
extends ScalabilityNodeSuite {
    private static final int FILE_SIZE = Integer.getInteger("fileSize", 1);
    private static final int WRITERS = Integer.getInteger("fileWriters", 0);
    private static final int READERS = Integer.getInteger("fileReaders", 0);
    private static final int MAX_ASSETS_PER_LEVEL = Integer.getInteger("maxAssets", 500);
    public static final String CTX_FILE_NODE_TYPE_PROP = "nodeType";
    private static final String CUSTOM_PATH_PROP = "contentPath";
    private static final String CUSTOM_REF_PROP = "references";
    private static final String CUSTOM_NODE_TYPE = "Asset";
    private static final String CUSTOM_INDEX_TYPE = "AssetIndex";
    private final Random random = new Random(29L);
    private List<String> searchPaths;
    private List<String> readPaths;
    private String nodeType;
    private String indexType;

    public ScalabilityBlobSearchSuite(Boolean storageEnabled) {
        super(storageEnabled);
    }

    @Override
    protected void beforeSuite() throws Exception {
        Session session = this.loginWriter();
        Node root = session.getRootNode();
        root.addNode(ROOT_NODE_NAME);
        session.save();
        if (CUSTOM_TYPE) {
            this.indexType = NodeTypeUtils.createNodeType(session, CUSTOM_INDEX_TYPE, null, null, null, null, null, true);
            this.setNodeType(NodeTypeUtils.createNodeType(session, CUSTOM_NODE_TYPE, new String[]{CUSTOM_PATH_PROP, CUSTOM_REF_PROP}, new int[]{1, 1}, new String[]{this.indexType}, null, "nt:file", false));
        } else {
            String type = "nt:unstructured";
            if (session.getWorkspace().getNodeTypeManager().hasNodeType("oak:Unstructured")) {
                type = "oak:Unstructured";
            }
            this.setNodeType(type);
        }
        if (INDEX) {
            String[] stringArray;
            String[] stringArray2;
            String[] stringArray3 = new String[]{"jcr:mimeType"};
            if (Strings.isNullOrEmpty(this.indexType)) {
                stringArray2 = new String[]{};
            } else {
                String[] stringArray4 = new String[1];
                stringArray2 = stringArray4;
                stringArray4[0] = this.indexType;
            }
            OakIndexUtils.propertyIndexDefinition(session, "jcr:mimeType", stringArray3, false, stringArray2);
            String[] stringArray5 = new String[]{"jcr:lastModified"};
            if (Strings.isNullOrEmpty(this.indexType)) {
                stringArray = new String[]{};
            } else {
                String[] stringArray6 = new String[1];
                stringArray = stringArray6;
                stringArray6[0] = this.indexType;
            }
            OakIndexUtils.orderedIndexDefinition(session, "jcr:lastModified", ASYNC_INDEX, stringArray5, false, stringArray, null);
        }
    }

    @Override
    public void beforeIteration(ScalabilityAbstractSuite.ExecutionContext context) throws RepositoryException {
        int i;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Started beforeIteration()");
        }
        this.searchPaths = Lists.newArrayList();
        this.readPaths = Lists.newArrayListWithCapacity(READERS);
        this.createLoad(context);
        for (i = 0; i < WRITERS; ++i) {
            this.addBackgroundJob(new BlobWriter(String.valueOf(context.getIncrement() + "-b-" + i), 1, null));
        }
        for (i = 0; i < READERS; ++i) {
            this.addBackgroundJob(new Reader());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finish beforeIteration()");
        }
        context.getMap().put("rootNodeName", ROOT_NODE_NAME);
        context.getMap().put("searchPaths", this.searchPaths);
    }

    @Override
    protected ScalabilityNodeSuite.Writer getWriter(ScalabilityAbstractSuite.ExecutionContext context, SynchronizedDescriptiveStatistics writeStats, int idx) throws RepositoryException {
        return new BlobWriter(context.getIncrement() + "-" + idx, context.getIncrement() / LOADERS, writeStats);
    }

    private synchronized String getRandomReadPath() {
        if (this.readPaths.isEmpty()) {
            return "";
        }
        return this.readPaths.get(this.random.nextInt(this.readPaths.size()));
    }

    private synchronized void addReadPath(String file) {
        int limit = 1000;
        if (this.readPaths.size() < limit) {
            this.readPaths.add(file);
        } else if (this.random.nextDouble() < 0.5) {
            this.readPaths.set(this.random.nextInt(limit), file);
        }
    }

    private synchronized void addSearchPath(String path) {
        if (!this.searchPaths.contains(path)) {
            this.searchPaths.add(path);
        }
    }

    public String getNodeType() {
        return this.nodeType;
    }

    protected void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    private class BlobWriter
    extends ScalabilityNodeSuite.Writer
    implements Runnable {
        BlobWriter(String id, int maxAssets, SynchronizedDescriptiveStatistics writeStats) throws RepositoryException {
            super(ScalabilityBlobSearchSuite.this, id, maxAssets, writeStats);
        }

        @Override
        public void run() {
            try {
                for (int count = 0; count < this.maxAssets; ++count) {
                    this.session.refresh(false);
                    ArrayList<String> levels = Lists.newArrayList();
                    this.getParentLevels(count, this.maxAssets, levels);
                    String fileNamePrefix = this.getFileNamePrefix(levels);
                    String parentDir = this.getParentSuffix(levels);
                    Stopwatch watch = Stopwatch.createStarted();
                    Node file = this.putFile(fileNamePrefix, parentDir);
                    this.session.save();
                    if (this.stats != null) {
                        this.stats.addValue(watch.elapsed(TimeUnit.MILLISECONDS));
                    }
                    ScalabilityBlobSearchSuite.this.addReadPath(file.getPath());
                    ScalabilityBlobSearchSuite.this.addSearchPath(fileNamePrefix);
                    if (!ScalabilityNodeSuite.LOG.isDebugEnabled() || (count + 1) % 1000 != 0) continue;
                    ScalabilityNodeSuite.LOG.debug("Thread " + this.id + " - Added assets : " + (count + 1));
                }
            }
            catch (Exception e) {
                ScalabilityNodeSuite.LOG.error("Exception in load creation ", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Node putFile(String fileNamePrefix, String parentDir) throws RepositoryException {
            Node filepath = JcrUtils.getOrAddNode(this.parent, parentDir, this.getParentType());
            Node file = JcrUtils.getOrAddNode(filepath, fileNamePrefix + "File" + this.counter++, this.getType());
            Binary binary = this.parent.getSession().getValueFactory().createBinary(new TestInputStream(FILE_SIZE * 1024));
            try {
                Node content = JcrUtils.getOrAddNode(file, "{http://www.jcp.org/jcr/1.0}content", "{http://www.jcp.org/jcr/nt/1.0}resource");
                if (ScalabilityBlobSearchSuite.this.indexType != null) {
                    content.addMixin(ScalabilityBlobSearchSuite.CUSTOM_INDEX_TYPE);
                    file.addMixin(ScalabilityBlobSearchSuite.CUSTOM_INDEX_TYPE);
                }
                content.setProperty("{http://www.jcp.org/jcr/1.0}mimeType", MimeType.randomMimeType().getValue());
                content.setProperty("{http://www.jcp.org/jcr/1.0}lastModified", Date.randomDate().getCalendar());
                content.setProperty("{http://www.jcp.org/jcr/1.0}data", binary);
                file.setProperty(ScalabilityBlobSearchSuite.CUSTOM_PATH_PROP, file.getPath());
                String reference = ScalabilityBlobSearchSuite.this.getRandomReadPath();
                if (!Strings.isNullOrEmpty(reference)) {
                    file.setProperty(ScalabilityBlobSearchSuite.CUSTOM_REF_PROP, reference);
                }
            }
            finally {
                binary.dispose();
            }
            return file;
        }

        protected String getParentType() throws RepositoryException {
            String type = "nt:unstructured";
            if (this.parent.getSession().getWorkspace().getNodeTypeManager().hasNodeType("oak:Unstructured")) {
                type = "oak:Unstructured";
            }
            return type;
        }

        protected String getType() throws RepositoryException {
            String type = "nt:unstructured";
            if (!ScalabilityBlobSearchSuite.this.context.getMap().containsKey(ScalabilityBlobSearchSuite.CTX_FILE_NODE_TYPE_PROP)) {
                if (ScalabilityBlobSearchSuite.this.getNodeType() != null) {
                    type = ScalabilityBlobSearchSuite.this.getNodeType();
                } else if (this.parent.getSession().getWorkspace().getNodeTypeManager().hasNodeType("oak:Unstructured")) {
                    type = "oak:Unstructured";
                }
                ScalabilityBlobSearchSuite.this.context.getMap().put(ScalabilityBlobSearchSuite.CTX_FILE_NODE_TYPE_PROP, type);
            } else {
                type = (String)ScalabilityBlobSearchSuite.this.context.getMap().get(ScalabilityBlobSearchSuite.CTX_FILE_NODE_TYPE_PROP);
            }
            return type;
        }

        private String getFileNamePrefix(List<String> levels) {
            StringBuilder name = new StringBuilder();
            for (String level : levels) {
                name.append("Level").append(level);
            }
            return name.toString();
        }

        private String getParentSuffix(List<String> levels) {
            StringBuilder parentSuffix = new StringBuilder();
            for (String level : levels) {
                parentSuffix.append(level).append("/");
            }
            return parentSuffix.toString();
        }

        private void getParentLevels(long assetNum, long maxAssets, List<String> levels) {
            int maxAssetsNextLevel = (int)Math.ceil((double)maxAssets / (double)MAX_ASSETS_PER_LEVEL);
            long nextAssetBucket = assetNum / (long)maxAssetsNextLevel;
            levels.add(String.valueOf(nextAssetBucket));
            if (maxAssetsNextLevel > MAX_ASSETS_PER_LEVEL) {
                this.getParentLevels(assetNum - nextAssetBucket * (long)maxAssetsNextLevel, maxAssetsNextLevel, levels);
            }
        }
    }

    private class Reader
    implements Runnable {
        private final Session session;

        private Reader() {
            this.session = ScalabilityBlobSearchSuite.this.loginWriter();
        }

        @Override
        public void run() {
            try {
                String path = ScalabilityBlobSearchSuite.this.getRandomReadPath();
                this.session.refresh(false);
                JcrUtils.readFile(this.session.getNode(path), new NullOutputStream());
            }
            catch (Exception e) {
                ScalabilityNodeSuite.LOG.error("Exception in reader execution ", e);
            }
        }
    }
}

