/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.scalability.suites;

import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.math.stat.descriptive.SynchronizedDescriptiveStatistics;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.oak.benchmark.util.OakIndexUtils;
import org.apache.jackrabbit.oak.plugins.index.property.OrderedIndex;
import org.apache.jackrabbit.oak.scalability.suites.ScalabilityAbstractSuite;
import org.apache.jackrabbit.oak.scalability.suites.ScalabilityNodeSuite;
import org.apache.jackrabbit.oak.scalability.util.NodeTypeUtils;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalabilityNodeRelationshipSuite
extends ScalabilityNodeSuite {
    private static final Logger LOG = LoggerFactory.getLogger(ScalabilityNodeRelationshipSuite.class);
    public static final String CUSTOM_ACT_NODE_TYPE = "ActivityType";
    public static final String CUSTOM_REL_NODE_TYPE = "RelationshipType";
    public static final String ACTIVITIES = "Activities";
    public static final String RELATIONSHIPS = "Relationships";
    public static final String CTX_USER = "User";
    public static final String CTX_GROUP = "Group";
    public static final String CREATED = "jcr:created";
    public static final String SOURCE_ID = "sourceId";
    public static final String TARGET_ID = "targetId";
    public static final String ACTION = "action";
    public static final String SOURCE = "source";
    public static final String OBJECT = "object";
    public static final String OBJECT_ID = "objectId";
    public static final String TARGET = "target";
    protected static final List<String> NODE_LEVELS = Splitter.on(",").trimResults().omitEmptyStrings().splitToList(System.getProperty("nodeLevels", "10,5,2,1"));
    protected static final List<String> NODE_LEVELS_DEFAULT = ImmutableList.of("10", "5", "2", "1");
    private static final int NUM_USERS = NODE_LEVELS.size() >= 1 ? Integer.parseInt(NODE_LEVELS.get(0)) : Integer.parseInt(NODE_LEVELS_DEFAULT.get(0));
    private static final int NUM_GROUPS = NODE_LEVELS.size() >= 2 ? Integer.parseInt(NODE_LEVELS.get(1)) : Integer.parseInt(NODE_LEVELS_DEFAULT.get(1));
    private static final int NUM_RELATIONSHIPS = NODE_LEVELS.size() >= 3 ? Integer.parseInt(NODE_LEVELS.get(2)) : Integer.parseInt(NODE_LEVELS_DEFAULT.get(2));
    private static final int NUM_ACTIVITIES = NODE_LEVELS.size() >= 4 ? Integer.parseInt(NODE_LEVELS.get(3)) : Integer.parseInt(NODE_LEVELS_DEFAULT.get(3));
    private static final long BUCKET_SIZE = 100L;
    private static final List<String> actions = Lists.newArrayList("act1", "act2", "act3", "act4", "act5", "act6", "act7", "act8", "act9", "act10");
    private static final List<String> objects = Lists.newArrayList("obj1", "obj2", "obj3", "obj4", "obj5", "obj6", "obj7", "obj8", "obj9", "obj10");
    private final Random random = new Random(29L);
    private List<Authorizable> users;
    private List<Authorizable> groups;

    public ScalabilityNodeRelationshipSuite(Boolean storageEnabled) {
        super(storageEnabled);
    }

    @Override
    protected void beforeSuite() throws Exception {
        Session session = this.loginWriter();
        Node root = session.getRootNode();
        root.addNode(ROOT_NODE_NAME);
        session.save();
        this.users = Lists.newArrayList();
        this.groups = Lists.newArrayList();
        if (CUSTOM_TYPE) {
            NodeTypeUtils.createNodeType(session, CUSTOM_ACT_NODE_TYPE, new String[]{"title", CREATED, ACTION, SOURCE_ID}, new int[]{1, 5, 1, 1}, new String[0], new String[]{"oak:Unstructured"}, null, false);
            NodeTypeUtils.createNodeType(session, CUSTOM_REL_NODE_TYPE, new String[]{CREATED, SOURCE_ID, TARGET_ID}, new int[]{5, 1, 1}, new String[0], null, null, false);
            this.nodeTypes.add(CUSTOM_ACT_NODE_TYPE);
            this.nodeTypes.add(CUSTOM_REL_NODE_TYPE);
        }
        if (INDEX) {
            this.createIndexes(session);
        }
    }

    @Override
    protected void createIndexes(Session session) throws RepositoryException {
        HashMap<String, Map<String, String>> orderedMap = Maps.newHashMap();
        String persistencePath = "";
        switch (this.INDEX_TYPE) {
            case PROPERTY: {
                String[] stringArray;
                String[] stringArray2;
                String[] stringArray3 = new String[]{SOURCE_ID};
                if (!CUSTOM_TYPE) {
                    stringArray2 = new String[]{};
                } else {
                    String[] stringArray4 = new String[1];
                    stringArray2 = stringArray4;
                    stringArray4[0] = CUSTOM_ACT_NODE_TYPE;
                }
                OakIndexUtils.propertyIndexDefinition(session, "customIndexActivity", stringArray3, false, stringArray2);
                String[] stringArray5 = new String[]{SOURCE_ID};
                if (!CUSTOM_TYPE) {
                    stringArray = new String[]{};
                } else {
                    String[] stringArray6 = new String[1];
                    stringArray = stringArray6;
                    stringArray6[0] = CUSTOM_REL_NODE_TYPE;
                }
                OakIndexUtils.propertyIndexDefinition(session, "customIndexRelationship", stringArray5, false, stringArray);
                break;
            }
            case ORDERED: {
                String[] stringArray;
                String[] stringArray7;
                String[] stringArray8 = new String[]{CREATED};
                if (!CUSTOM_TYPE) {
                    stringArray7 = new String[]{};
                } else {
                    String[] stringArray9 = new String[1];
                    stringArray7 = stringArray9;
                    stringArray9[0] = CUSTOM_ACT_NODE_TYPE;
                }
                OakIndexUtils.orderedIndexDefinition(session, "customIndexActivity", ASYNC_INDEX, stringArray8, false, stringArray7, OrderedIndex.OrderDirection.DESC.getDirection());
                String[] stringArray10 = new String[]{CREATED};
                if (!CUSTOM_TYPE) {
                    stringArray = new String[]{};
                } else {
                    String[] stringArray11 = new String[1];
                    stringArray = stringArray11;
                    stringArray11[0] = CUSTOM_REL_NODE_TYPE;
                }
                OakIndexUtils.orderedIndexDefinition(session, "customIndexRelationship", ASYNC_INDEX, stringArray10, false, stringArray, OrderedIndex.OrderDirection.DESC.getDirection());
                break;
            }
            case LUCENE_FILE: {
                persistencePath = TARGET + StandardSystemProperty.FILE_SEPARATOR.value() + "lucene" + String.valueOf(System.currentTimeMillis());
                OakIndexUtils.luceneIndexDefinition(session, "customIndexActivity", ASYNC_INDEX, new String[]{SOURCE_ID, CREATED}, new String[]{"String", "Date"}, orderedMap, persistencePath);
                break;
            }
            case LUCENE_FILE_DOC: {
                persistencePath = TARGET + StandardSystemProperty.FILE_SEPARATOR.value() + "lucene" + String.valueOf(System.currentTimeMillis());
            }
            case LUCENE_DOC: {
                HashMap<String, String> propMap = Maps.newHashMap();
                propMap.put("type", "Date");
                orderedMap.put(CREATED, propMap);
            }
            case LUCENE: {
                OakIndexUtils.luceneIndexDefinition(session, "customIndexActivity", ASYNC_INDEX, new String[]{SOURCE_ID, CREATED}, new String[]{"String", "Date"}, orderedMap, persistencePath);
            }
        }
    }

    @Override
    public void beforeIteration(ScalabilityAbstractSuite.ExecutionContext context) throws RepositoryException {
        String name;
        int idx;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Started beforeIteration()");
        }
        if (this.nodeTypes != null && !this.nodeTypes.isEmpty()) {
            context.getMap().put("rootType", this.nodeTypes.get(0));
            context.getMap().put("descendantType", this.nodeTypes.get(1));
        }
        Session session = this.loginWriter();
        UserManager userMgr = ((JackrabbitSession)session).getUserManager();
        context.getMap().put("PREV_ITER_USERS", this.users.size());
        for (idx = 0; idx < NUM_USERS * context.getIncrement(); ++idx) {
            name = String.valueOf((char)(this.random.nextInt(26) + 97)) + CTX_USER + context.getIncrement() + "_" + idx;
            User user = userMgr.createUser(name, name);
            LOG.debug("User created : " + name);
            this.users.add(user);
        }
        for (idx = 0; idx < NUM_GROUPS * context.getIncrement(); ++idx) {
            name = String.valueOf((char)(this.random.nextInt(26) + 97)) + CTX_GROUP + context.getIncrement() + idx;
            Group group = userMgr.createGroup(name);
            this.groups.add(group);
            int groupMembers = this.random.nextInt(this.users.size());
            for (int i = 0; i < groupMembers; ++i) {
                group.addMember(this.users.get(this.random.nextInt(this.users.size())));
            }
        }
        session.save();
        this.createLoad(context);
        long loadFinish = System.currentTimeMillis();
        context.getMap().put("rootNodeName", ROOT_NODE_NAME);
        context.getMap().put(CTX_USER, this.users);
        context.getMap().put(CTX_GROUP, this.groups);
        this.waitBeforeIterationFinish(loadFinish);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished beforeIteration()");
        }
    }

    @Override
    protected ScalabilityNodeSuite.Writer getWriter(ScalabilityAbstractSuite.ExecutionContext context, SynchronizedDescriptiveStatistics writeStats, int idx) throws RepositoryException {
        int numUsers = context.getIncrement() * NUM_USERS / LOADERS;
        return new ActivityWriter(context.getIncrement() + "-" + idx, numUsers, idx * numUsers, writeStats);
    }

    class ActivityWriter
    extends ScalabilityNodeSuite.Writer {
        private int startIdx;

        ActivityWriter(String id, int numUsers, int startIdx, SynchronizedDescriptiveStatistics writeStats) throws RepositoryException {
            super(ScalabilityNodeRelationshipSuite.this, id, numUsers, writeStats);
            this.startIdx = startIdx;
        }

        @Override
        public void run() {
            try {
                int idx = this.startIdx;
                while (idx < this.maxAssets + this.startIdx) {
                    this.session.refresh(false);
                    int userIdx = (Integer)ScalabilityNodeRelationshipSuite.this.context.getMap().get("PREV_ITER_USERS") + idx;
                    Authorizable user = (Authorizable)ScalabilityNodeRelationshipSuite.this.users.get(userIdx);
                    Node activitiesParentNode = JcrUtils.getOrAddNode(this.session.getNode(user.getPath()), ScalabilityNodeRelationshipSuite.ACTIVITIES, "oak:Unstructured");
                    Node relationshipsParentNode = JcrUtils.getOrAddNode(this.session.getNode(user.getPath()), ScalabilityNodeRelationshipSuite.RELATIONSHIPS, "oak:Unstructured");
                    this.createRelationships(user, relationshipsParentNode, activitiesParentNode);
                    this.createActivities(user, activitiesParentNode);
                    if ((this.counter + 1L) % 100L == 0L) {
                        LOG.info("Thread " + this.id + " - Processed Users : " + (this.counter + 1L));
                    }
                    ++idx;
                    ++this.counter;
                }
            }
            catch (Exception e) {
                LOG.error("Exception in load creation ", e);
            }
        }

        private void createActivities(Authorizable user, Node activitiesParentNode) throws RepositoryException {
            for (int i = 0; i < NUM_ACTIVITIES; ++i) {
                this.timer.start();
                this.createActivity(activitiesParentNode, user.getID() + " " + i, (String)actions.get(ScalabilityNodeRelationshipSuite.this.random.nextInt(actions.size())), user.getID(), (String)objects.get(ScalabilityNodeRelationshipSuite.this.random.nextInt(objects.size())), (String)objects.get(ScalabilityNodeRelationshipSuite.this.random.nextInt(objects.size())));
                this.session.save();
                this.timer.stop();
            }
        }

        private void createActivity(Node activitiesParentNode, String title, String action, String source, String object, String target) throws RepositoryException {
            Node activityNode = this.getActivityParentNode(activitiesParentNode);
            HashMap<String, String> activityMap = Maps.newHashMap();
            activityMap.put("title", title);
            activityMap.put(ScalabilityNodeRelationshipSuite.ACTION, action);
            activityMap.put(ScalabilityNodeRelationshipSuite.SOURCE_ID, source);
            activityMap.put(ScalabilityNodeRelationshipSuite.OBJECT_ID, object);
            activityMap.put(ScalabilityNodeRelationshipSuite.TARGET_ID, target);
            this.createActivityNode(activityNode, activityMap);
        }

        private void createActivityNode(Node activityParent, Map<String, String> props) throws RepositoryException {
            activityParent.setProperty("title", props.get("title"));
            activityParent.setProperty(ScalabilityNodeRelationshipSuite.CREATED, this.generateDate());
            activityParent.setProperty(ScalabilityNodeRelationshipSuite.ACTION, props.get(ScalabilityNodeRelationshipSuite.ACTION));
            activityParent.setProperty(ScalabilityNodeRelationshipSuite.SOURCE_ID, props.get(ScalabilityNodeRelationshipSuite.SOURCE_ID));
            Node sourceNode = JcrUtils.getOrAddNode(activityParent, ScalabilityNodeRelationshipSuite.SOURCE, "oak:Unstructured");
            sourceNode.setProperty(ScalabilityNodeRelationshipSuite.SOURCE_ID, props.get(ScalabilityNodeRelationshipSuite.SOURCE_ID));
            Node objNode = JcrUtils.getOrAddNode(activityParent, ScalabilityNodeRelationshipSuite.OBJECT, "oak:Unstructured");
            objNode.setProperty(ScalabilityNodeRelationshipSuite.OBJECT_ID, props.get(ScalabilityNodeRelationshipSuite.OBJECT_ID));
            Node targetNode = JcrUtils.getOrAddNode(activityParent, ScalabilityNodeRelationshipSuite.TARGET, "oak:Unstructured");
            targetNode.setProperty(ScalabilityNodeRelationshipSuite.TARGET_ID, props.get(ScalabilityNodeRelationshipSuite.TARGET_ID));
            LOG.debug("Activity created for User : " + props.get(ScalabilityNodeRelationshipSuite.SOURCE_ID) + " " + activityParent.getPath());
        }

        private Node getActivityParentNode(Node activitiesParentNode) throws RepositoryException {
            Node dayNode;
            Calendar c = Calendar.getInstance();
            Node yearNode = JcrUtils.getOrAddNode(activitiesParentNode, String.valueOf(c.get(1)), "oak:Unstructured");
            String month = String.valueOf(c.get(2) + 1);
            month = month.length() > 1 ? month : "0" + month;
            Node monthNode = JcrUtils.getOrAddNode(yearNode, month, "oak:Unstructured");
            String day = String.valueOf(c.get(5));
            day = day.length() > 1 ? day : "0" + day;
            Node parentNode = dayNode = JcrUtils.getOrAddNode(monthNode, day, "oak:Unstructured");
            NodeIterator iterator = dayNode.getNodes();
            long size = iterator.getSize();
            if (size < 0L || size > 100L) {
                size = 0L;
                int maxNum = -1;
                while (iterator.hasNext()) {
                    int buckNum;
                    ++size;
                    Node child = iterator.nextNode();
                    String name = child.getName();
                    if (name.charAt(0) != '@' || (buckNum = Integer.parseInt(name.substring(1))) <= maxNum) continue;
                    maxNum = buckNum;
                    parentNode = child;
                }
                if (size > 100L && (maxNum < 0 || this.numChildNodes(parentNode) >= 100L)) {
                    parentNode = dayNode.addNode("@" + String.valueOf(maxNum + 1), "oak:Unstructured");
                }
            }
            return JcrUtils.getOrCreateUniqueByPath(parentNode, UUID.randomUUID().toString(), this.getType(0));
        }

        private long numChildNodes(Node node) throws RepositoryException {
            NodeIterator iterator = node.getNodes();
            if (iterator.getSize() >= 0L) {
                return iterator.getSize();
            }
            int num = 0;
            while (iterator.hasNext() && (long)num < 100L) {
                iterator.nextNode();
                ++num;
            }
            return num;
        }

        private void createRelationships(Authorizable user, Node relationshipsParentNode, Node activitiesParentNode) throws RepositoryException {
            ArrayList<Integer> usersIdx = Lists.newArrayList();
            for (int count = 0; count < ScalabilityNodeRelationshipSuite.this.users.size(); ++count) {
                usersIdx.add(count);
            }
            for (int i = 0; i < NUM_RELATIONSHIPS; ++i) {
                if (usersIdx.size() <= 0) continue;
                String otherUser = ((Authorizable)ScalabilityNodeRelationshipSuite.this.users.get((Integer)usersIdx.remove(ScalabilityNodeRelationshipSuite.this.random.nextInt(usersIdx.size())))).getID();
                this.timer.start();
                String nameHint = Text.getName(otherUser);
                Node rNode = relationshipsParentNode.addNode(nameHint, this.getType(1));
                rNode.setProperty(ScalabilityNodeRelationshipSuite.CREATED, this.generateDate());
                rNode.setProperty(ScalabilityNodeRelationshipSuite.SOURCE_ID, user.getID());
                rNode.setProperty(ScalabilityNodeRelationshipSuite.TARGET_ID, otherUser);
                LOG.debug("Relationship created for User : " + user.getID() + " " + rNode.getPath());
                this.createActivity(activitiesParentNode, user.getID() + " " + otherUser, (String)actions.get(ScalabilityNodeRelationshipSuite.this.random.nextInt(actions.size())), user.getID(), (String)objects.get(ScalabilityNodeRelationshipSuite.this.random.nextInt(objects.size())), otherUser);
                this.session.save();
                this.timer.stop();
            }
        }

        @Override
        protected String getType(int typeIdx) throws RepositoryException {
            String typeOfNode = typeIdx == 0 ? "rootType" : "descendantType";
            String type = "oak:Unstructured";
            if (ScalabilityNodeRelationshipSuite.this.context.getMap().containsKey(typeOfNode)) {
                type = (String)ScalabilityNodeRelationshipSuite.this.context.getMap().get(typeOfNode);
            } else {
                ScalabilityNodeRelationshipSuite.this.context.getMap().put(typeOfNode, type);
            }
            return type;
        }
    }
}

