/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.scalability.suites;

import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.math.stat.descriptive.SynchronizedDescriptiveStatistics;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.api.jmx.IndexStatsMBean;
import org.apache.jackrabbit.oak.benchmark.util.OakIndexUtils;
import org.apache.jackrabbit.oak.fixture.JcrCreator;
import org.apache.jackrabbit.oak.fixture.OakRepositoryFixture;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;
import org.apache.jackrabbit.oak.jcr.Jcr;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.LuceneInitializerHelper;
import org.apache.jackrabbit.oak.plugins.index.property.OrderedIndex;
import org.apache.jackrabbit.oak.scalability.ScalabilitySuite;
import org.apache.jackrabbit.oak.scalability.benchmarks.ScalabilityBenchmark;
import org.apache.jackrabbit.oak.scalability.suites.ScalabilityAbstractSuite;
import org.apache.jackrabbit.oak.scalability.util.NodeTypeUtils;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalabilityNodeSuite
extends ScalabilityAbstractSuite {
    protected static final Logger LOG = LoggerFactory.getLogger(ScalabilityNodeSuite.class);
    protected static final int LOADERS = Integer.getInteger("loaders", 1);
    protected static final List<String> NODE_LEVELS = Splitter.on(",").trimResults().omitEmptyStrings().splitToList(System.getProperty("nodeLevels", "10,5,2"));
    protected static final int TESTERS = Integer.getInteger("testers", 1);
    protected static final int DENSITY_LEVEL = Integer.getInteger("densityLevel", 100);
    protected static final boolean INDEX = Boolean.getBoolean("index");
    protected static final String ASYNC_INDEX = System.getProperty("asyncIndex");
    protected static final boolean FULL_TEXT = !Boolean.getBoolean("noFullIndex");
    protected static final boolean RAND_DATE = Boolean.getBoolean("randDate");
    protected static final boolean CUSTOM_TYPE = Boolean.getBoolean("customType");
    public static final String CTX_DESC_SEARCH_PATHS_PROP = "descPaths";
    public static final String CTX_ROOT_NODE_NAME_PROP = "rootNodeName";
    public static final String CTX_ACT_NODE_TYPE_PROP = "rootType";
    public static final String CTX_REL_NODE_TYPE_PROP = "descendantType";
    public static final String CUSTOM_ROOT_NODE_TYPE = "ParentType";
    public static final String CUSTOM_DESC_NODE_TYPE = "DescendantType";
    public static final String DATE_PROP = "added";
    public static final String CTX_PAGINATION_KEY_PROP = "added";
    public static final String FILTER_PROP = "filter";
    public static final String SORT_PROP = "viewed";
    public static final String TITLE_PROP = "title";
    public static final String ROOT_NODE_NAME = "LongevitySearchAssets" + TEST_ID;
    public final Index INDEX_TYPE = Index.valueOf(System.getProperty("indexType", Index.PROPERTY.toString()));
    protected final Boolean storageEnabled;
    protected Whiteboard whiteboard;
    protected final List<String> nodeTypes;
    private final Random random = new Random(29L);
    private List<String> searchRootPaths;
    private List<String> searchDescPaths;

    public ScalabilityNodeSuite(Boolean storageEnabled) {
        this.storageEnabled = storageEnabled;
        this.nodeTypes = Lists.newArrayList();
    }

    @Override
    public ScalabilitySuite addBenchmarks(ScalabilityBenchmark ... tests) {
        for (ScalabilityBenchmark test : tests) {
            this.benchmarks.put(test.toString(), test);
        }
        return this;
    }

    @Override
    protected void beforeSuite() throws Exception {
        Session session = this.loginWriter();
        Node root = session.getRootNode();
        root.addNode(ROOT_NODE_NAME);
        session.save();
        if (CUSTOM_TYPE) {
            NodeTypeUtils.createNodeType(session, CUSTOM_DESC_NODE_TYPE, new String[]{"added", SORT_PROP, FILTER_PROP, TITLE_PROP}, new int[]{5, 6, 1, 1}, new String[0], new String[]{CUSTOM_DESC_NODE_TYPE}, null, false);
            NodeTypeUtils.createNodeType(session, CUSTOM_ROOT_NODE_TYPE, new String[]{"added", SORT_PROP, FILTER_PROP, TITLE_PROP}, new int[]{5, 6, 1, 1}, new String[0], new String[]{CUSTOM_DESC_NODE_TYPE}, null, false);
            this.nodeTypes.add(CUSTOM_ROOT_NODE_TYPE);
            this.nodeTypes.add(CUSTOM_DESC_NODE_TYPE);
        }
        if (INDEX) {
            this.createIndexes(session);
        }
    }

    protected void createIndexes(Session session) throws RepositoryException {
        HashMap<String, Map<String, String>> orderedMap = Maps.newHashMap();
        String persistencePath = "";
        switch (this.INDEX_TYPE) {
            case ORDERED: {
                String[] stringArray;
                String[] stringArray2;
                String[] stringArray3 = new String[]{"added"};
                if (this.nodeTypes.isEmpty()) {
                    stringArray2 = new String[]{};
                } else {
                    String[] stringArray4 = new String[1];
                    stringArray2 = stringArray4;
                    stringArray4[0] = this.nodeTypes.get(0);
                }
                OakIndexUtils.orderedIndexDefinition(session, "customIndexParent", ASYNC_INDEX, stringArray3, false, stringArray2, OrderedIndex.OrderDirection.DESC.getDirection());
                String[] stringArray5 = new String[]{"added"};
                if (this.nodeTypes.isEmpty()) {
                    stringArray = new String[]{};
                } else {
                    String[] stringArray6 = new String[1];
                    stringArray = stringArray6;
                    stringArray6[0] = this.nodeTypes.get(1);
                }
                OakIndexUtils.orderedIndexDefinition(session, "customIndexDescendant", ASYNC_INDEX, stringArray5, false, stringArray, OrderedIndex.OrderDirection.DESC.getDirection());
                break;
            }
            case LUCENE_FILE: {
                persistencePath = "target" + StandardSystemProperty.FILE_SEPARATOR.value() + "lucene" + String.valueOf(System.currentTimeMillis());
                OakIndexUtils.luceneIndexDefinition(session, "customIndex", ASYNC_INDEX, new String[]{FILTER_PROP, "added"}, new String[]{"String", "Date"}, null, persistencePath);
                break;
            }
            case LUCENE_FILE_DOC: {
                persistencePath = "target" + StandardSystemProperty.FILE_SEPARATOR.value() + "lucene" + String.valueOf(System.currentTimeMillis());
            }
            case LUCENE_DOC: {
                HashMap<String, String> propMap = Maps.newHashMap();
                propMap.put("type", "Date");
                orderedMap.put("added", propMap);
            }
            case LUCENE: {
                OakIndexUtils.luceneIndexDefinition(session, "customIndex", ASYNC_INDEX, new String[]{FILTER_PROP, "added"}, new String[]{"String", "Date"}, orderedMap, persistencePath);
                break;
            }
        }
    }

    @Override
    public void beforeIteration(ScalabilityAbstractSuite.ExecutionContext context) throws RepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Started beforeIteration()");
        }
        if (this.nodeTypes != null && !this.nodeTypes.isEmpty()) {
            context.getMap().put(CTX_ACT_NODE_TYPE_PROP, this.nodeTypes.get(0));
            context.getMap().put(CTX_REL_NODE_TYPE_PROP, this.nodeTypes.get(1));
        }
        this.searchRootPaths = Lists.newArrayList();
        this.searchDescPaths = Lists.newArrayList();
        this.createLoad(context);
        long loadFinish = System.currentTimeMillis();
        context.getMap().put(CTX_ROOT_NODE_NAME_PROP, ROOT_NODE_NAME);
        context.getMap().put("searchPaths", this.searchRootPaths);
        context.getMap().put(CTX_DESC_SEARCH_PATHS_PROP, this.searchDescPaths);
        this.waitBeforeIterationFinish(loadFinish);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished beforeIteration()");
        }
    }

    protected void waitBeforeIterationFinish(long loadFinish) {
        IndexStatsMBean indexStatsMBean = WhiteboardUtils.getService(this.whiteboard, IndexStatsMBean.class);
        if (indexStatsMBean != null) {
            String lastIndexedTime = indexStatsMBean.getLastIndexedTime();
            while (lastIndexedTime == null || ISO8601.parse(lastIndexedTime).getTimeInMillis() < loadFinish) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Waiting for async indexing to finish");
                    }
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    LOG.error("Error waiting for async index to finish", e);
                }
                lastIndexedTime = indexStatsMBean.getLastIndexedTime();
            }
            LOG.info("Execution Count {}", (Object)indexStatsMBean.getExecutionCount());
            LOG.info("Execution Time {}", (Object)indexStatsMBean.getExecutionTime());
            LOG.info("Consolidated Execution Stats {}", (Object)indexStatsMBean.getConsolidatedExecutionStats());
        }
    }

    protected void createLoad(ScalabilityAbstractSuite.ExecutionContext context) throws RepositoryException {
        SynchronizedDescriptiveStatistics writeStats = new SynchronizedDescriptiveStatistics();
        ArrayList<Thread> loadThreads = Lists.newArrayList();
        for (int idx = 0; idx < LOADERS; ++idx) {
            Thread t = new Thread((Runnable)this.getWriter(context, writeStats, idx), "LoadThread-" + idx);
            loadThreads.add(t);
            t.start();
        }
        for (Thread t : loadThreads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                LOG.error("Exception waiting for join ", e);
            }
        }
        LOG.info("Write stats");
        LOG.info(String.format("# min     10%%     50%%     90%%     max       N%n", new Object[0]));
        LOG.info(String.format("%6.0f  %6.0f  %6.0f  %6.0f  %6.0f  %6d%n", writeStats.getMin(), writeStats.getPercentile(10.0), writeStats.getPercentile(50.0), writeStats.getPercentile(90.0), writeStats.getMax(), writeStats.getN()));
    }

    protected Writer getWriter(ScalabilityAbstractSuite.ExecutionContext context, SynchronizedDescriptiveStatistics writeStats, int idx) throws RepositoryException {
        return new Writer(context.getIncrement() + "-" + idx, context.getIncrement() * Integer.parseInt(NODE_LEVELS.get(0)) / LOADERS, writeStats);
    }

    @Override
    protected void executeBenchmark(final ScalabilityBenchmark benchmark, final ScalabilityAbstractSuite.ExecutionContext context) throws Exception {
        LOG.info("Started pre benchmark hook : {}", (Object)benchmark);
        benchmark.beforeExecute(this.getRepository(), CREDENTIALS, context);
        LOG.info("Started execution : {}", (Object)benchmark);
        if (PROFILE) {
            context.startProfiler();
        }
        ArrayList<Thread> threads = Lists.newArrayListWithCapacity(TESTERS);
        for (int idx = 0; idx < TESTERS; ++idx) {
            Thread t = new Thread("Tester-" + idx){

                @Override
                public void run() {
                    try {
                        benchmark.execute(ScalabilityNodeSuite.this.getRepository(), ScalabilityAbstractSuite.CREDENTIALS, context);
                    }
                    catch (Exception e) {
                        LOG.error("Exception in benchmark execution ", e);
                    }
                }
            };
            threads.add(t);
            t.start();
        }
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (Exception e) {
                LOG.error("Exception in search thread join ", e);
            }
        }
        context.stopProfiler();
        LOG.info("Started post benchmark hook : {}", (Object)benchmark);
        benchmark.afterExecute(this.getRepository(), CREDENTIALS, context);
    }

    @Override
    protected Repository[] createRepository(RepositoryFixture fixture) throws Exception {
        if (fixture instanceof OakRepositoryFixture) {
            return ((OakRepositoryFixture)fixture).setUpCluster(1, new JcrCreator(){

                @Override
                public Jcr customize(Oak oak) {
                    LuceneIndexProvider provider = new LuceneIndexProvider();
                    oak.with(provider).with(provider).with(new LuceneIndexEditorProvider());
                    if (!Strings.isNullOrEmpty(ASYNC_INDEX) && ASYNC_INDEX.equals("async")) {
                        oak.withAsyncIndexing();
                    }
                    if (FULL_TEXT) {
                        oak.with(new LuceneInitializerHelper("luceneGlobal", ScalabilityNodeSuite.this.storageEnabled));
                    }
                    ScalabilityNodeSuite.this.whiteboard = oak.getWhiteboard();
                    return new Jcr(oak);
                }
            });
        }
        return super.createRepository(fixture);
    }

    private synchronized void addRootSearchPath(String path) {
        int limit = 1000;
        if (this.searchRootPaths.size() < limit) {
            this.searchRootPaths.add(path);
        } else if (this.random.nextDouble() < 0.5) {
            this.searchRootPaths.set(this.random.nextInt(limit), path);
        }
    }

    private synchronized void addDescSearchPath(String path) {
        int limit = 1000;
        if (this.searchDescPaths.size() < limit) {
            this.searchDescPaths.add(path);
        } else if (this.random.nextDouble() < 0.5) {
            this.searchDescPaths.set(this.random.nextInt(limit), path);
        }
    }

    static class Timer {
        private final Stopwatch watch = Stopwatch.createUnstarted();
        private final SynchronizedDescriptiveStatistics stats;

        public Timer(SynchronizedDescriptiveStatistics stats) {
            this.stats = stats;
        }

        public void start() {
            if (this.watch.isRunning()) {
                this.watch.stop();
                this.watch.reset();
            }
            this.watch.start();
        }

        public void stop() {
            this.watch.stop();
            this.stats.addValue(this.watch.elapsed(TimeUnit.MILLISECONDS));
            this.watch.reset();
        }
    }

    class Writer
    implements Runnable {
        final Node parent;
        final Session session;
        final String id;
        final SynchronizedDescriptiveStatistics stats;
        long counter;
        int secsIn2Years = 31622400;
        Calendar start;
        long startMillis;
        Timer timer;
        final int maxAssets;

        Writer(String id, int maxAssets, SynchronizedDescriptiveStatistics writeStats) throws RepositoryException {
            this.id = id;
            this.maxAssets = maxAssets;
            this.stats = writeStats;
            this.session = ScalabilityNodeSuite.this.loginWriter();
            this.parent = this.session.getRootNode().getNode(ROOT_NODE_NAME).addNode("writer-" + id);
            this.start = Calendar.getInstance();
            this.start.add(1, -2);
            this.start.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.startMillis = this.start.getTimeInMillis();
            this.session.save();
            this.timer = new Timer(writeStats);
        }

        protected Calendar generateDate() {
            if (RAND_DATE) {
                this.start.setTimeInMillis(this.startMillis + (long)ScalabilityNodeSuite.this.random.nextInt(this.secsIn2Years));
            } else {
                this.start.add(13, 1);
            }
            return this.start;
        }

        @Override
        public void run() {
            try {
                for (int count = 1; count <= this.maxAssets; ++count) {
                    this.session.refresh(false);
                    Node node = this.createParent(this.parent, ScalabilityNodeSuite.this.random.nextInt(100) <= DENSITY_LEVEL, "Node" + count);
                    ScalabilityNodeSuite.this.addRootSearchPath(node.getPath());
                    if ((this.counter + 1L) % 1000L != 0L) continue;
                    LOG.info("Thread " + this.id + " - Added nodes : " + this.counter);
                }
            }
            catch (Exception e) {
                LOG.error("Exception in load creation ", e);
            }
            LOG.info("Max Assets created by " + this.id + " - " + this.counter);
        }

        private Node createParent(Node parent, boolean createChildren, String name) throws Exception {
            Node node = this.createNode(parent, 0, name);
            if (createChildren) {
                this.createChildren(node, 1);
            }
            return node;
        }

        private void createChildren(Node parent, int levelIdx) throws Exception {
            if (levelIdx > NODE_LEVELS.size() - 1) {
                return;
            }
            for (int idx = 0; idx < Integer.parseInt(NODE_LEVELS.get(levelIdx)); ++idx) {
                Node subNode = this.createNode(parent, levelIdx, "SubNode-" + levelIdx + "-" + idx);
                ScalabilityNodeSuite.this.addDescSearchPath(subNode.getPath());
                this.createChildren(subNode, levelIdx + 1);
            }
        }

        private Node createNode(Node parent, int levelIdx, String name) throws Exception {
            this.timer.start();
            Node node = JcrUtils.getOrAddNode(parent, name, this.getType(levelIdx));
            node.setProperty("added", this.generateDate());
            node.setProperty(ScalabilityNodeSuite.SORT_PROP, this.toss());
            node.setProperty(ScalabilityNodeSuite.FILTER_PROP, this.toss());
            node.setProperty(ScalabilityNodeSuite.TITLE_PROP, name);
            this.session.save();
            ++this.counter;
            if (LOG.isDebugEnabled()) {
                LOG.debug(node.getPath());
            }
            this.timer.stop();
            return node;
        }

        protected String getType(int levelIdx) throws RepositoryException {
            String typeOfNode = levelIdx == 0 ? ScalabilityNodeSuite.CTX_ACT_NODE_TYPE_PROP : ScalabilityNodeSuite.CTX_REL_NODE_TYPE_PROP;
            String type = "nt:unstructured";
            if (ScalabilityNodeSuite.this.context.getMap().containsKey(typeOfNode)) {
                type = (String)ScalabilityNodeSuite.this.context.getMap().get(typeOfNode);
            } else if (this.parent.getSession().getWorkspace().getNodeTypeManager().hasNodeType("oak:Unstructured")) {
                type = "oak:Unstructured";
                ScalabilityNodeSuite.this.context.getMap().put(typeOfNode, type);
            }
            return type;
        }

        private boolean toss() {
            int tossOutcome = ScalabilityNodeSuite.this.random.nextInt(2);
            return tossOutcome == 0;
        }
    }

    public static enum Index {
        PROPERTY,
        ORDERED,
        LUCENE,
        LUCENE_DOC,
        LUCENE_FILE,
        LUCENE_FILE_DOC;

    }
}

