/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.scalability.util;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;

public class NodeTypeUtils {
    public static String createNodeType(Session session, String name, String[] properties, int[] propTypes, String[] superTypes, String[] childrenTypes, String baseType, boolean isMixin) throws RepositoryException {
        NodeTypeManager ntm = session.getWorkspace().getNodeTypeManager();
        NodeTypeTemplate ntt = ntm.createNodeTypeTemplate();
        if (baseType != null) {
            NodeType ntd = ntm.getNodeType(baseType);
            ntt = ntm.createNodeTypeTemplate(ntd);
        }
        if (superTypes != null && superTypes.length != 0) {
            ntt.setDeclaredSuperTypeNames(superTypes);
        }
        ntt.setOrderableChildNodes(false);
        ntt.setName(name);
        if (properties != null) {
            for (int count = 0; count < properties.length; ++count) {
                ntt.getPropertyDefinitionTemplates().add(NodeTypeUtils.createPropertyDefTemplate(ntm, properties[count], propTypes[count]));
            }
        }
        if (childrenTypes != null) {
            ntt.getNodeDefinitionTemplates().add(NodeTypeUtils.createNodeDefTemplate(ntm, childrenTypes));
        }
        ntt.setMixin(isMixin);
        ntm.registerNodeType(ntt, true);
        return ntt.getName();
    }

    private static PropertyDefinitionTemplate createPropertyDefTemplate(NodeTypeManager ntm, String prop, int type) throws RepositoryException {
        PropertyDefinitionTemplate pdt = ntm.createPropertyDefinitionTemplate();
        pdt.setName(prop);
        pdt.setOnParentVersion(5);
        pdt.setRequiredType(type);
        pdt.setValueConstraints(null);
        pdt.setDefaultValues(null);
        pdt.setFullTextSearchable(true);
        pdt.setValueConstraints(new String[0]);
        return pdt;
    }

    private static NodeDefinitionTemplate createNodeDefTemplate(NodeTypeManager ntm, String[] types) throws RepositoryException {
        NodeDefinitionTemplate ndt = ntm.createNodeDefinitionTemplate();
        ndt.setOnParentVersion(5);
        ndt.setRequiredPrimaryTypeNames(types);
        ndt.setDefaultPrimaryTypeName(types[0]);
        ndt.setName("*");
        return ndt;
    }
}

