/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.security.authentication.AuthenticationConfigurationImpl;
import org.apache.jackrabbit.oak.security.authentication.token.TokenConfigurationImpl;
import org.apache.jackrabbit.oak.security.authorization.AuthorizationConfigurationImpl;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositeAuthorizationConfiguration;
import org.apache.jackrabbit.oak.security.principal.PrincipalConfigurationImpl;
import org.apache.jackrabbit.oak.security.privilege.PrivilegeConfigurationImpl;
import org.apache.jackrabbit.oak.security.user.UserConfigurationImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthenticationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.CompositeTokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.CompositePrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardAuthorizableActionProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardAuthorizableNodeName;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardAware;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardRestrictionProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUserAuthenticationFactory;
import org.osgi.framework.BundleContext;

public class SecurityProviderImpl
implements SecurityProvider,
WhiteboardAware {
    private volatile AuthenticationConfiguration authenticationConfiguration;
    private volatile PrivilegeConfiguration privilegeConfiguration;
    private volatile UserConfiguration userConfiguration;
    private final CompositeAuthorizationConfiguration authorizationConfiguration = new CompositeAuthorizationConfiguration(this);
    private final CompositePrincipalConfiguration principalConfiguration = new CompositePrincipalConfiguration(this);
    private final CompositeTokenConfiguration tokenConfiguration = new CompositeTokenConfiguration(this);
    private final WhiteboardAuthorizableNodeName authorizableNodeName = new WhiteboardAuthorizableNodeName();
    private final WhiteboardAuthorizableActionProvider authorizableActionProvider = new WhiteboardAuthorizableActionProvider();
    private final WhiteboardRestrictionProvider restrictionProvider = new WhiteboardRestrictionProvider();
    private final WhiteboardUserAuthenticationFactory userAuthenticationFactory = new WhiteboardUserAuthenticationFactory(UserConfigurationImpl.getDefaultAuthenticationFactory());
    private ConfigurationParameters configuration;
    private Whiteboard whiteboard;

    public SecurityProviderImpl() {
        this(ConfigurationParameters.EMPTY);
    }

    public SecurityProviderImpl(@Nonnull ConfigurationParameters configuration) {
        Preconditions.checkNotNull(configuration);
        this.configuration = configuration;
        this.authenticationConfiguration = new AuthenticationConfigurationImpl(this);
        this.userConfiguration = new UserConfigurationImpl(this);
        this.privilegeConfiguration = new PrivilegeConfigurationImpl();
        this.authorizationConfiguration.setDefaultConfig(new AuthorizationConfigurationImpl(this));
        this.principalConfiguration.setDefaultConfig(new PrincipalConfigurationImpl(this));
        this.tokenConfiguration.setDefaultConfig(new TokenConfigurationImpl(this));
    }

    @Override
    public void setWhiteboard(@Nonnull Whiteboard whiteboard) {
        this.whiteboard = whiteboard;
    }

    @Override
    public Whiteboard getWhiteboard() {
        return this.whiteboard;
    }

    @Override
    @Nonnull
    public ConfigurationParameters getParameters(@Nullable String name) {
        if (name == null) {
            return this.configuration;
        }
        ConfigurationParameters params = this.configuration.getConfigValue(name, ConfigurationParameters.EMPTY);
        for (SecurityConfiguration securityConfiguration : this.getConfigurations()) {
            if (securityConfiguration == null || !securityConfiguration.getName().equals(name)) continue;
            return ConfigurationParameters.of(params, securityConfiguration.getParameters());
        }
        return params;
    }

    @Override
    @Nonnull
    public Iterable<? extends SecurityConfiguration> getConfigurations() {
        HashSet<SecurityConfiguration> scs = new HashSet<SecurityConfiguration>();
        scs.add(this.authenticationConfiguration);
        scs.add(this.authorizationConfiguration);
        scs.add(this.userConfiguration);
        scs.add(this.principalConfiguration);
        scs.add(this.privilegeConfiguration);
        scs.add(this.tokenConfiguration);
        return scs;
    }

    @Override
    @Nonnull
    public <T> T getConfiguration(@Nonnull Class<T> configClass) {
        if (AuthenticationConfiguration.class == configClass) {
            return (T)this.authenticationConfiguration;
        }
        if (AuthorizationConfiguration.class == configClass) {
            return (T)this.authorizationConfiguration;
        }
        if (UserConfiguration.class == configClass) {
            return (T)this.userConfiguration;
        }
        if (PrincipalConfiguration.class == configClass) {
            return (T)this.principalConfiguration;
        }
        if (PrivilegeConfiguration.class == configClass) {
            return (T)this.privilegeConfiguration;
        }
        if (TokenConfiguration.class == configClass) {
            return (T)this.tokenConfiguration;
        }
        throw new IllegalArgumentException("Unsupported security configuration class " + configClass);
    }

    protected void activate(BundleContext context) {
        this.whiteboard = new OsgiWhiteboard(context);
        this.authorizableActionProvider.start(this.whiteboard);
        this.authorizableNodeName.start(this.whiteboard);
        this.restrictionProvider.start(this.whiteboard);
        this.userAuthenticationFactory.start(this.whiteboard);
        this.initializeConfigurations();
    }

    protected void deactivate() {
        this.authorizableActionProvider.stop();
        this.authorizableNodeName.stop();
        this.restrictionProvider.stop();
        this.userAuthenticationFactory.stop();
    }

    protected void bindPrincipalConfiguration(@Nonnull PrincipalConfiguration reference) {
        this.principalConfiguration.addConfiguration(this.initConfiguration(reference));
    }

    protected void unbindPrincipalConfiguration(@Nonnull PrincipalConfiguration reference) {
        this.principalConfiguration.removeConfiguration(reference);
    }

    protected void bindTokenConfiguration(@Nonnull TokenConfiguration reference) {
        this.tokenConfiguration.addConfiguration(this.initConfiguration(reference));
    }

    protected void unbindTokenConfiguration(@Nonnull TokenConfiguration reference) {
        this.tokenConfiguration.removeConfiguration(reference);
    }

    protected void bindAuthorizationConfiguration(@Nonnull AuthorizationConfiguration reference) {
        this.authorizationConfiguration.addConfiguration(this.initConfiguration(reference));
    }

    protected void unbindAuthorizationConfiguration(@Nonnull AuthorizationConfiguration reference) {
        this.authorizationConfiguration.removeConfiguration(reference);
    }

    private void initializeConfigurations() {
        this.initConfiguration(this.authorizationConfiguration, ConfigurationParameters.of("restrictionProvider", this.restrictionProvider));
        ImmutableMap<String, WhiteboardUserAuthenticationFactory> userMap = ImmutableMap.of("authorizableActionProvider", this.authorizableActionProvider, "authorizableNodeName", this.authorizableNodeName, "userAuthenticationFactory", this.userAuthenticationFactory);
        this.initConfiguration(this.userConfiguration, ConfigurationParameters.of(userMap));
        this.initConfiguration(this.authenticationConfiguration);
        this.initConfiguration(this.privilegeConfiguration);
    }

    private <T extends SecurityConfiguration> T initConfiguration(@Nonnull T config) {
        if (config instanceof ConfigurationBase) {
            ConfigurationBase cfg = (ConfigurationBase)config;
            cfg.setSecurityProvider(this);
            cfg.setParameters(ConfigurationParameters.of(ConfigurationParameters.EMPTY, cfg.getParameters()));
        }
        return config;
    }

    private <T extends SecurityConfiguration> T initConfiguration(@Nonnull T config, @Nonnull ConfigurationParameters params) {
        if (config instanceof ConfigurationBase) {
            ConfigurationBase cfg = (ConfigurationBase)config;
            cfg.setSecurityProvider(this);
            cfg.setParameters(ConfigurationParameters.of(params, cfg.getParameters()));
        }
        return config;
    }

    protected void bindAuthenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
        this.authenticationConfiguration = authenticationConfiguration;
    }

    protected void unbindAuthenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
        this.authenticationConfiguration = null;
    }

    protected void bindPrivilegeConfiguration(PrivilegeConfiguration privilegeConfiguration) {
        this.privilegeConfiguration = privilegeConfiguration;
    }

    protected void unbindPrivilegeConfiguration(PrivilegeConfiguration privilegeConfiguration) {
        this.privilegeConfiguration = null;
    }

    protected void bindUserConfiguration(UserConfiguration userConfiguration) {
        this.userConfiguration = userConfiguration;
    }

    protected void unbindUserConfiguration(UserConfiguration userConfiguration) {
        this.userConfiguration = null;
    }
}

