/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization;

import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.util.TreeUtil;

final class AuthorizationContext
implements Context,
AccessControlConstants,
PermissionConstants {
    private static final String[] NODE_NAMES = POLICY_NODE_NAMES.toArray(new String[POLICY_NODE_NAMES.size()]);
    private static final String[] PROPERTY_NAMES = ACE_PROPERTY_NAMES.toArray(new String[ACE_PROPERTY_NAMES.size()]);
    private static final String[] NT_NAMES = Iterables.toArray(Iterables.concat(AC_NODETYPE_NAMES, PERMISSION_NODETYPE_NAMES), String.class);
    private static final Context INSTANCE = new AuthorizationContext();

    private AuthorizationContext() {
    }

    static Context getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean definesProperty(@Nonnull Tree parent, @Nonnull PropertyState property) {
        return this.definesTree(parent);
    }

    @Override
    public boolean definesContextRoot(@Nonnull Tree tree) {
        String name = tree.getName();
        if (AuthorizationContext.isNodeName(name)) {
            return "rep:ACL".equals(TreeUtil.getPrimaryTypeName(tree));
        }
        return "rep:permissionStore".equals(name);
    }

    @Override
    public boolean definesTree(@Nonnull Tree tree) {
        String ntName = TreeUtil.getPrimaryTypeName(tree);
        return AuthorizationContext.isNtName(ntName);
    }

    @Override
    public boolean definesLocation(@Nonnull TreeLocation location) {
        Tree tree;
        PropertyState p = location.getProperty();
        Tree tree2 = tree = p == null ? location.getTree() : location.getParent().getTree();
        if (tree != null) {
            return p == null ? this.definesTree(tree) : this.definesProperty(tree, p);
        }
        return AuthorizationContext.isItemName(location.getName()) || location.getPath().startsWith("/jcr:system/rep:permissionStore");
    }

    @Override
    public boolean definesInternal(@Nonnull Tree tree) {
        return "rep:permissionStore".equals(tree.getName());
    }

    private static boolean isNodeName(@Nonnull String name) {
        for (String n : NODE_NAMES) {
            if (!n.equals(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean isItemName(@Nonnull String name) {
        if (AuthorizationContext.isNodeName(name)) {
            return true;
        }
        for (String n : PROPERTY_NAMES) {
            if (!n.equals(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNtName(@Nonnull String name) {
        for (String n : NT_NAMES) {
            if (!n.equals(name)) continue;
            return true;
        }
        return false;
    }
}

