/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.composite;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.commons.iterator.AccessControlPolicyIteratorAdapter;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractAccessControlManager;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.PolicyOwner;

class CompositeAccessControlManager
extends AbstractAccessControlManager {
    private final List<AccessControlManager> acMgrs;

    public CompositeAccessControlManager(@Nonnull Root root, @Nonnull NamePathMapper namePathMapper, @Nonnull SecurityProvider securityProvider, @Nonnull List<AccessControlManager> acMgrs) {
        super(root, namePathMapper, securityProvider);
        this.acMgrs = acMgrs;
    }

    @Override
    @Nonnull
    public Privilege[] getSupportedPrivileges(String absPath) throws RepositoryException {
        ImmutableSet.Builder privs = ImmutableSet.builder();
        for (AccessControlManager acMgr : this.acMgrs) {
            privs.add(acMgr.getSupportedPrivileges(absPath));
        }
        ImmutableCollection s = privs.build();
        return s.toArray(new Privilege[s.size()]);
    }

    @Override
    public AccessControlPolicy[] getPolicies(String absPath) throws RepositoryException {
        ImmutableList.Builder policies = ImmutableList.builder();
        for (AccessControlManager acMgr : this.acMgrs) {
            policies.add(acMgr.getPolicies(absPath));
        }
        ImmutableCollection l = policies.build();
        return l.toArray(new AccessControlPolicy[l.size()]);
    }

    @Override
    public AccessControlPolicy[] getEffectivePolicies(String absPath) throws RepositoryException {
        ImmutableList.Builder privs = ImmutableList.builder();
        for (AccessControlManager acMgr : this.acMgrs) {
            privs.add(acMgr.getEffectivePolicies(absPath));
        }
        ImmutableCollection l = privs.build();
        return l.toArray(new AccessControlPolicy[l.size()]);
    }

    @Override
    public AccessControlPolicyIterator getApplicablePolicies(String absPath) throws RepositoryException {
        ArrayList<AccessControlPolicyIterator> l = Lists.newArrayList();
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof PolicyOwner)) continue;
            l.add(acMgr.getApplicablePolicies(absPath));
        }
        return new AccessControlPolicyIteratorAdapter(Iterators.concat(l.toArray(new AccessControlPolicyIterator[l.size()])));
    }

    @Override
    public void setPolicy(String absPath, AccessControlPolicy policy) throws RepositoryException {
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof PolicyOwner) || !((PolicyOwner)((Object)acMgr)).defines(absPath, policy)) continue;
            acMgr.setPolicy(absPath, policy);
            return;
        }
        throw new AccessControlException("Cannot set access control policy " + policy + "; no PolicyOwner found.");
    }

    @Override
    public void removePolicy(String absPath, AccessControlPolicy policy) throws RepositoryException {
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof PolicyOwner) || !((PolicyOwner)((Object)acMgr)).defines(absPath, policy)) continue;
            acMgr.removePolicy(absPath, policy);
            return;
        }
        throw new AccessControlException("Cannot remove access control policy " + policy + "; no PolicyOwner found.");
    }

    @Override
    public JackrabbitAccessControlPolicy[] getApplicablePolicies(Principal principal) throws RepositoryException {
        ImmutableList.Builder policies = ImmutableList.builder();
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof JackrabbitAccessControlManager) || !(acMgr instanceof PolicyOwner)) continue;
            policies.add(((JackrabbitAccessControlManager)acMgr).getApplicablePolicies(principal));
        }
        ImmutableCollection l = policies.build();
        return l.toArray(new JackrabbitAccessControlPolicy[l.size()]);
    }

    @Override
    public JackrabbitAccessControlPolicy[] getPolicies(Principal principal) throws RepositoryException {
        ImmutableList.Builder privs = ImmutableList.builder();
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof JackrabbitAccessControlManager)) continue;
            privs.add(((JackrabbitAccessControlManager)acMgr).getPolicies(principal));
        }
        ImmutableCollection l = privs.build();
        return l.toArray(new JackrabbitAccessControlPolicy[l.size()]);
    }

    @Override
    public AccessControlPolicy[] getEffectivePolicies(Set<Principal> principals) throws RepositoryException {
        ImmutableList.Builder privs = ImmutableList.builder();
        for (AccessControlManager acMgr : this.acMgrs) {
            if (!(acMgr instanceof JackrabbitAccessControlManager)) continue;
            privs.add(((JackrabbitAccessControlManager)acMgr).getEffectivePolicies(principals));
        }
        ImmutableCollection l = privs.build();
        return l.toArray(new AccessControlPolicy[l.size()]);
    }
}

