/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.collect.ImmutableList;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.user.CacheValidatorProvider;
import org.apache.jackrabbit.oak.security.user.UserAuthenticationFactoryImpl;
import org.apache.jackrabbit.oak.security.user.UserContext;
import org.apache.jackrabbit.oak.security.user.UserImporter;
import org.apache.jackrabbit.oak.security.user.UserInitializer;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.security.user.UserPrincipalProvider;
import org.apache.jackrabbit.oak.security.user.UserValidatorProvider;
import org.apache.jackrabbit.oak.security.user.autosave.AutoSaveEnabledManager;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.user.UserAuthenticationFactory;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;

@Component(metatype=true, label="Apache Jackrabbit Oak UserConfiguration")
@Service(value={UserConfiguration.class, SecurityConfiguration.class})
@Properties(value={@Property(name="usersPath", label="User Path", description="Path underneath which user nodes are being created.", value={"/rep:security/rep:authorizables/rep:users"}), @Property(name="groupsPath", label="Group Path", description="Path underneath which group nodes are being created.", value={"/rep:security/rep:authorizables/rep:groups"}), @Property(name="systemRelativePath", label="System User Relative Path", description="Path relative to the user root path underneath which system user nodes are being created. The default value is 'system'.", value={"system"}), @Property(name="defaultDepth", label="Default Depth", description="Number of levels that are used by default to store authorizable nodes", intValue={2}), @Property(name="importBehavior", label="Import Behavior", description="Behavior for user/group related items upon XML import.", options={@PropertyOption(name="abort", value="abort"), @PropertyOption(name="besteffort", value="besteffort"), @PropertyOption(name="ignore", value="ignore")}, value={"ignore"}), @Property(name="passwordHashAlgorithm", label="Hash Algorithm", description="Name of the algorithm used to generate the password hash.", value={"SHA-256"}), @Property(name="passwordHashIterations", label="Hash Iterations", description="Number of iterations to generate the password hash.", intValue={1000}), @Property(name="passwordSaltSize", label="Hash Salt Size", description="Salt size to generate the password hash.", intValue={8}), @Property(name="supportAutoSave", label="Autosave Support", description="Configuration option to enable autosave behavior. Note: this config option is present for backwards compatibility with Jackrabbit 2.x and should only be used for broken code that doesn't properly verify the autosave behavior (see Jackrabbit API). If this option is turned on autosave will be enabled by default; otherwise autosave is not supported.", boolValue={false}), @Property(name="passwordMaxAge", label="Maximum Password Age", description="Maximum age in days a password may have. Values greater 0 will implicitly enable password expiry. A value of 0 indicates unlimited password age.", intValue={0}), @Property(name="initialPasswordChange", label="Change Password On First Login", description="When enabled, forces users to change their password upon first login.", boolValue={false}), @Property(name="passwordHistorySize", label="Maximum Password History Size", description="Maximum number of passwords recorded for a user after changing her password (NOTE: upper limit is 1000). When changing the password the new password must not be present in the password history. A value of 0 indicates no password history is recorded.", intValue={0}), @Property(name="cacheExpiration", label="Principal Cache Expiration", description="Optional configuration defining the number of milliseconds until the principal cache expires (NOTE: currently only respected for principal resolution with the internal system session such as used for login). If not set or equal/lower than zero no caches are created/evaluated.", longValue={0L})})
public class UserConfigurationImpl
extends ConfigurationBase
implements UserConfiguration,
SecurityConfiguration {
    private static final UserAuthenticationFactory DEFAULT_AUTH_FACTORY = new UserAuthenticationFactoryImpl();

    public UserConfigurationImpl() {
    }

    public UserConfigurationImpl(SecurityProvider securityProvider) {
        super(securityProvider, securityProvider.getParameters("org.apache.jackrabbit.oak.user"));
    }

    public static UserAuthenticationFactory getDefaultAuthenticationFactory() {
        return DEFAULT_AUTH_FACTORY;
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        this.setParameters(ConfigurationParameters.of(properties));
    }

    @Override
    @Nonnull
    public String getName() {
        return "org.apache.jackrabbit.oak.user";
    }

    @Override
    @Nonnull
    public ConfigurationParameters getParameters() {
        ConfigurationParameters params = super.getParameters();
        if (!params.containsKey("userAuthenticationFactory")) {
            return ConfigurationParameters.of(params, ConfigurationParameters.of("userAuthenticationFactory", DEFAULT_AUTH_FACTORY));
        }
        return params;
    }

    @Override
    @Nonnull
    public WorkspaceInitializer getWorkspaceInitializer() {
        return new UserInitializer(this.getSecurityProvider());
    }

    @Override
    @Nonnull
    public List<? extends ValidatorProvider> getValidators(@Nonnull String workspaceName, @Nonnull Set<Principal> principals, @Nonnull MoveTracker moveTracker) {
        return ImmutableList.of(new UserValidatorProvider(this.getParameters()), new CacheValidatorProvider(principals));
    }

    @Override
    @Nonnull
    public List<ProtectedItemImporter> getProtectedItemImporters() {
        return Collections.singletonList(new UserImporter(this.getParameters()));
    }

    @Override
    @Nonnull
    public Context getContext() {
        return UserContext.getInstance();
    }

    @Override
    @Nonnull
    public UserManager getUserManager(Root root, NamePathMapper namePathMapper) {
        UserManagerImpl umgr = new UserManagerImpl(root, namePathMapper, this.getSecurityProvider());
        if (this.getParameters().getConfigValue("supportAutoSave", false).booleanValue()) {
            return new AutoSaveEnabledManager(umgr, root);
        }
        return umgr;
    }

    @Override
    @Nullable
    public PrincipalProvider getUserPrincipalProvider(@Nonnull Root root, @Nonnull NamePathMapper namePathMapper) {
        return new UserPrincipalProvider(root, this, namePathMapper);
    }
}

