/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.security.user.GroupImpl;
import org.apache.jackrabbit.oak.security.user.MembershipProvider;
import org.apache.jackrabbit.oak.security.user.SystemUserImpl;
import org.apache.jackrabbit.oak.security.user.UserImpl;
import org.apache.jackrabbit.oak.security.user.UserProvider;
import org.apache.jackrabbit.oak.security.user.query.UserQueryManager;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableAction;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableActionProvider;
import org.apache.jackrabbit.oak.spi.security.user.action.DefaultAuthorizableActionProvider;
import org.apache.jackrabbit.oak.spi.security.user.util.PasswordUtil;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.apache.jackrabbit.oak.util.NodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserManagerImpl
implements UserManager {
    private static final Logger log = LoggerFactory.getLogger(UserManagerImpl.class);
    private final Root root;
    private final NamePathMapper namePathMapper;
    private final SecurityProvider securityProvider;
    private final UserProvider userProvider;
    private final MembershipProvider membershipProvider;
    private final ConfigurationParameters config;
    private final AuthorizableActionProvider actionProvider;
    private UserQueryManager queryManager;
    private ReadOnlyNodeTypeManager ntMgr;

    public UserManagerImpl(@Nonnull Root root, @Nonnull NamePathMapper namePathMapper, @Nonnull SecurityProvider securityProvider) {
        this.root = root;
        this.namePathMapper = namePathMapper;
        this.securityProvider = securityProvider;
        UserConfiguration uc = securityProvider.getConfiguration(UserConfiguration.class);
        this.config = uc.getParameters();
        this.userProvider = new UserProvider(root, this.config);
        this.membershipProvider = new MembershipProvider(root, this.config);
        this.actionProvider = UserManagerImpl.getActionProvider(this.config);
    }

    @Nonnull
    private static AuthorizableActionProvider getActionProvider(@Nonnull ConfigurationParameters config) {
        AuthorizableActionProvider actionProvider = config.getConfigValue("authorizableActionProvider", null, AuthorizableActionProvider.class);
        if (actionProvider == null) {
            actionProvider = new DefaultAuthorizableActionProvider(config);
        }
        return actionProvider;
    }

    @Override
    public Authorizable getAuthorizable(String id) throws RepositoryException {
        Tree tree;
        Authorizable authorizable = null;
        Tree tree2 = tree = Strings.isNullOrEmpty(id) ? null : this.userProvider.getAuthorizable(id);
        if (tree != null) {
            authorizable = this.getAuthorizable(UserUtil.getAuthorizableId(tree), tree);
        }
        return authorizable;
    }

    @Override
    public <T extends Authorizable> T getAuthorizable(String id, Class<T> authorizableClass) throws RepositoryException {
        return UserUtil.castAuthorizable(this.getAuthorizable(id), authorizableClass);
    }

    @Override
    public Authorizable getAuthorizable(Principal principal) throws RepositoryException {
        return principal == null ? null : this.getAuthorizable(this.userProvider.getAuthorizableByPrincipal(principal));
    }

    @Override
    public Authorizable getAuthorizableByPath(String path) throws RepositoryException {
        String oakPath = this.namePathMapper.getOakPath(path);
        if (oakPath == null) {
            throw new RepositoryException("Invalid path " + path);
        }
        return this.getAuthorizable(this.userProvider.getAuthorizableByPath(oakPath));
    }

    @Override
    public Iterator<Authorizable> findAuthorizables(String relPath, String value) throws RepositoryException {
        return this.findAuthorizables(relPath, value, 3);
    }

    @Override
    public Iterator<Authorizable> findAuthorizables(String relPath, String value, int searchType) throws RepositoryException {
        return this.getQueryManager().findAuthorizables(relPath, value, AuthorizableType.getType(searchType));
    }

    @Override
    public Iterator<Authorizable> findAuthorizables(Query query) throws RepositoryException {
        return this.getQueryManager().findAuthorizables(query);
    }

    @Override
    public User createUser(String userID, String password) throws RepositoryException {
        PrincipalImpl principal = new PrincipalImpl(userID);
        return this.createUser(userID, password, principal, null);
    }

    @Override
    public User createUser(String userID, String password, Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        this.checkValidId(userID);
        this.checkValidPrincipal(principal, false);
        if (intermediatePath != null) {
            intermediatePath = this.namePathMapper.getOakPath(intermediatePath);
        }
        Tree userTree = this.userProvider.createUser(userID, intermediatePath);
        this.setPrincipal(userTree, principal);
        if (password != null) {
            this.setPassword(userTree, userID, password, true);
        }
        UserImpl user = new UserImpl(userID, userTree, this);
        this.onCreate(user, password);
        log.debug("User created: " + userID);
        return user;
    }

    @Override
    public User createSystemUser(String userID, String intermediatePath) throws RepositoryException {
        this.checkValidId(userID);
        PrincipalImpl principal = new PrincipalImpl(userID);
        this.checkValidPrincipal(principal, false);
        Tree userTree = this.userProvider.createSystemUser(userID, intermediatePath);
        this.setPrincipal(userTree, principal);
        SystemUserImpl user = new SystemUserImpl(userID, userTree, this);
        log.debug("System user created: " + userID);
        return user;
    }

    @Override
    public Group createGroup(String groupId) throws RepositoryException {
        PrincipalImpl principal = new PrincipalImpl(groupId);
        return this.createGroup(groupId, principal, null);
    }

    @Override
    public Group createGroup(Principal principal) throws RepositoryException {
        return this.createGroup(principal, null);
    }

    @Override
    public Group createGroup(Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        return this.createGroup(principal.getName(), principal, intermediatePath);
    }

    @Override
    public Group createGroup(String groupID, Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        this.checkValidId(groupID);
        this.checkValidPrincipal(principal, true);
        if (intermediatePath != null) {
            intermediatePath = this.namePathMapper.getOakPath(intermediatePath);
        }
        Tree groupTree = this.userProvider.createGroup(groupID, intermediatePath);
        this.setPrincipal(groupTree, principal);
        GroupImpl group = new GroupImpl(groupID, groupTree, this);
        this.onCreate(group);
        log.debug("Group created: " + groupID);
        return group;
    }

    @Override
    public boolean isAutoSave() {
        return false;
    }

    @Override
    public void autoSave(boolean enable) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("Session#save() is always required.");
    }

    void onCreate(@Nonnull User user, @CheckForNull String password) throws RepositoryException {
        if (!user.isSystemUser()) {
            for (AuthorizableAction authorizableAction : this.actionProvider.getAuthorizableActions(this.securityProvider)) {
                authorizableAction.onCreate(user, password, this.root, this.namePathMapper);
            }
        } else {
            log.debug("Omit onCreate action for system users.");
        }
    }

    void onCreate(@Nonnull Group group) throws RepositoryException {
        for (AuthorizableAction authorizableAction : this.actionProvider.getAuthorizableActions(this.securityProvider)) {
            authorizableAction.onCreate(group, this.root, this.namePathMapper);
        }
    }

    void onRemove(@Nonnull Authorizable authorizable) throws RepositoryException {
        for (AuthorizableAction authorizableAction : this.actionProvider.getAuthorizableActions(this.securityProvider)) {
            authorizableAction.onRemove(authorizable, this.root, this.namePathMapper);
        }
    }

    void onPasswordChange(@Nonnull User user, @Nonnull String password) throws RepositoryException {
        for (AuthorizableAction authorizableAction : this.actionProvider.getAuthorizableActions(this.securityProvider)) {
            authorizableAction.onPasswordChange(user, password, this.root, this.namePathMapper);
        }
    }

    @CheckForNull
    Authorizable getAuthorizable(@CheckForNull Tree tree) throws RepositoryException {
        if (tree == null || !tree.exists()) {
            return null;
        }
        return this.getAuthorizable(UserUtil.getAuthorizableId(tree), tree);
    }

    @Nonnull
    NamePathMapper getNamePathMapper() {
        return this.namePathMapper;
    }

    @Nonnull
    ReadOnlyNodeTypeManager getNodeTypeManager() {
        if (this.ntMgr == null) {
            this.ntMgr = ReadOnlyNodeTypeManager.getInstance(this.root, NamePathMapper.DEFAULT);
        }
        return this.ntMgr;
    }

    @Nonnull
    MembershipProvider getMembershipProvider() {
        return this.membershipProvider;
    }

    @Nonnull
    PrincipalManager getPrincipalManager() throws RepositoryException {
        return this.securityProvider.getConfiguration(PrincipalConfiguration.class).getPrincipalManager(this.root, this.namePathMapper);
    }

    @Nonnull
    ConfigurationParameters getConfig() {
        return this.config;
    }

    @CheckForNull
    private Authorizable getAuthorizable(@CheckForNull String id, @CheckForNull Tree tree) throws RepositoryException {
        if (id == null || tree == null) {
            return null;
        }
        if (UserUtil.isType(tree, AuthorizableType.USER)) {
            if (UserUtil.isSystemUser(tree)) {
                return new SystemUserImpl(id, tree, this);
            }
            return new UserImpl(id, tree, this);
        }
        if (UserUtil.isType(tree, AuthorizableType.GROUP)) {
            return new GroupImpl(id, tree, this);
        }
        throw new RepositoryException("Not a user or group tree " + tree.getPath() + '.');
    }

    private void checkValidId(@CheckForNull String id) throws RepositoryException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Invalid ID " + id);
        }
        if (this.getAuthorizable(id) != null) {
            throw new AuthorizableExistsException("Authorizable with ID " + id + " already exists");
        }
    }

    void checkValidPrincipal(@CheckForNull Principal principal, boolean isGroup) throws RepositoryException {
        if (principal == null || Strings.isNullOrEmpty(principal.getName())) {
            throw new IllegalArgumentException("Principal may not be null and must have a valid name.");
        }
        if (!isGroup && "everyone".equals(principal.getName())) {
            throw new IllegalArgumentException("'everyone' is a reserved group principal name.");
        }
        if (this.getAuthorizable(principal) != null) {
            throw new AuthorizableExistsException("Authorizable with principal " + principal.getName() + " already exists.");
        }
    }

    void setPrincipal(@Nonnull Tree authorizableTree, @Nonnull Principal principal) {
        authorizableTree.setProperty("rep:principalName", principal.getName());
    }

    void setPassword(@Nonnull Tree userTree, @Nonnull String userId, @Nonnull String password, boolean forceHash) throws RepositoryException {
        boolean isNewUser;
        String pwHash;
        if (forceHash || PasswordUtil.isPlainTextPassword(password)) {
            try {
                pwHash = PasswordUtil.buildPasswordHash(password, this.config);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RepositoryException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new RepositoryException(e);
            }
        } else {
            pwHash = password;
        }
        userTree.setProperty("rep:password", pwHash);
        boolean expiryEnabled = this.passwordExpiryEnabled();
        boolean forceInitialPwChange = this.forceInitialPasswordChangeEnabled();
        boolean bl = isNewUser = userTree.getStatus() == Tree.Status.NEW;
        if (!UserUtil.isAdmin(this.config, userId) && (expiryEnabled && !forceInitialPwChange || forceInitialPwChange && !isNewUser)) {
            Tree pwdTree = new NodeUtil(userTree).getOrAddChild("rep:pwd", "rep:Password").getTree();
            pwdTree.setProperty("rep:passwordLastModified", System.currentTimeMillis(), Type.LONG);
        }
    }

    private boolean passwordExpiryEnabled() {
        return this.config.getConfigValue("passwordMaxAge", 0) > 0;
    }

    private boolean forceInitialPasswordChangeEnabled() {
        return this.config.getConfigValue("initialPasswordChange", false);
    }

    @Nonnull
    private UserQueryManager getQueryManager() {
        if (this.queryManager == null) {
            this.queryManager = new UserQueryManager(this, this.namePathMapper, this.config, this.root);
        }
        return this.queryManager;
    }
}

