/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.security.Principal;
import java.text.ParseException;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.security.user.AuthorizableBaseProvider;
import org.apache.jackrabbit.oak.security.user.TreeBasedPrincipal;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableNodeName;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.util.NodeUtil;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserProvider
extends AuthorizableBaseProvider {
    private static final Logger log = LoggerFactory.getLogger(UserProvider.class);
    private static final String DELIMITER = "/";
    private final int defaultDepth;
    private final String groupPath;
    private final String userPath;

    UserProvider(@Nonnull Root root, @Nonnull ConfigurationParameters config) {
        super(root, config);
        this.defaultDepth = config.getConfigValue("defaultDepth", 2);
        this.groupPath = config.getConfigValue("groupsPath", "/rep:security/rep:authorizables/rep:groups");
        this.userPath = config.getConfigValue("usersPath", "/rep:security/rep:authorizables/rep:users");
    }

    @Nonnull
    Tree createUser(@Nonnull String userID, @Nullable String intermediateJcrPath) throws RepositoryException {
        return this.createAuthorizableNode(userID, "rep:User", intermediateJcrPath);
    }

    @Nonnull
    Tree createGroup(@Nonnull String groupID, @Nullable String intermediateJcrPath) throws RepositoryException {
        return this.createAuthorizableNode(groupID, "rep:Group", intermediateJcrPath);
    }

    @Nonnull
    Tree createSystemUser(@Nonnull String userID, @Nullable String intermediateJcrPath) throws RepositoryException {
        String relPath;
        String relSysPath = this.config.getConfigValue("systemRelativePath", "system");
        if (intermediateJcrPath == null) {
            relPath = relSysPath;
        } else {
            if (!intermediateJcrPath.startsWith(relSysPath) && !intermediateJcrPath.startsWith(this.userPath + '/' + relSysPath)) {
                throw new ConstraintViolationException("System users must be located in the 'system' subtree of the user root.");
            }
            relPath = intermediateJcrPath;
        }
        return this.createAuthorizableNode(userID, "rep:SystemUser", relPath);
    }

    @CheckForNull
    Tree getAuthorizable(@Nonnull String authorizableId) {
        return this.getByID(authorizableId, AuthorizableType.AUTHORIZABLE);
    }

    @CheckForNull
    Tree getAuthorizableByPath(@Nonnull String authorizableOakPath) {
        return this.getByPath(authorizableOakPath);
    }

    @CheckForNull
    Tree getAuthorizableByPrincipal(@Nonnull Principal principal) {
        if (principal instanceof TreeBasedPrincipal) {
            return this.root.getTree(((TreeBasedPrincipal)principal).getOakPath());
        }
        try {
            StringBuilder stmt = new StringBuilder();
            stmt.append("SELECT * FROM [").append("rep:Authorizable").append(']');
            stmt.append(" WHERE [").append("rep:principalName").append("] = $principalName");
            stmt.append(" /* oak-internal */");
            Result result = this.root.getQueryEngine().executeQuery(stmt.toString(), "JCR-SQL2", 1L, 0L, Collections.singletonMap("principalName", PropertyValues.newString(principal.getName())), QueryEngine.NO_MAPPINGS);
            Iterator<? extends ResultRow> rows = result.getRows().iterator();
            if (rows.hasNext()) {
                String path = rows.next().getPath();
                return this.root.getTree(path);
            }
        }
        catch (ParseException ex) {
            log.error("Failed to retrieve authorizable by principal", ex);
        }
        return null;
    }

    private Tree createAuthorizableNode(@Nonnull String authorizableId, @Nonnull String ntName, @Nullable String intermediatePath) throws RepositoryException {
        String nodeName = this.getNodeName(authorizableId);
        Tree folder = this.createFolderNodes(nodeName, "rep:Group".equals(ntName), intermediatePath);
        if (folder.hasChild(nodeName)) {
            int i = 1;
            String tmp = nodeName + i;
            while (folder.hasChild(tmp)) {
                tmp = nodeName + ++i;
            }
            nodeName = tmp;
        }
        Tree typeRoot = this.root.getTree("/jcr:system/jcr:nodeTypes");
        String userId = Strings.nullToEmpty(this.root.getContentSession().getAuthInfo().getUserID());
        Tree authorizableNode = TreeUtil.addChild(folder, nodeName, ntName, typeRoot, userId);
        authorizableNode.setProperty("rep:authorizableId", authorizableId);
        authorizableNode.setProperty("jcr:uuid", UserProvider.getContentID(authorizableId));
        return authorizableNode;
    }

    private Tree createFolderNodes(@Nonnull String nodeName, boolean isGroup, @Nullable String intermediatePath) throws RepositoryException {
        NodeUtil colliding;
        String primaryType;
        NodeUtil folder;
        String authRoot = isGroup ? this.groupPath : this.userPath;
        String folderPath = authRoot + this.getFolderPath(nodeName, intermediatePath, authRoot);
        Tree tree = this.root.getTree(folderPath);
        while (!tree.isRoot() && !tree.exists()) {
            tree = tree.getParent();
        }
        if (tree.exists()) {
            folder = new NodeUtil(tree);
            String relativePath = PathUtils.relativize(tree.getPath(), folderPath);
            if (!relativePath.isEmpty()) {
                folder = folder.getOrAddTree(relativePath, "rep:AuthorizableFolder");
            }
        } else {
            throw new AccessDeniedException("Missing permission to create intermediate authorizable folders.");
        }
        while (folder.hasChild(nodeName) && "rep:AuthorizableFolder".equals(primaryType = TreeUtil.getPrimaryTypeName((colliding = folder.getChild(nodeName)).getTree()))) {
            log.debug("Existing folder node collides with user/group to be created. Expanding path by: " + colliding.getName());
            folder = colliding;
        }
        return folder.getTree();
    }

    @Nonnull
    private String getFolderPath(@Nonnull String nodeName, @Nullable String intermediatePath, @Nonnull String authRoot) throws ConstraintViolationException {
        boolean emptyOrNull = intermediatePath == null || intermediatePath.isEmpty() || authRoot.equals(intermediatePath);
        StringBuilder sb = new StringBuilder();
        if (!emptyOrNull) {
            if (intermediatePath.charAt(0) == '/') {
                if (!intermediatePath.startsWith(authRoot)) {
                    throw new ConstraintViolationException("Attempt to create authorizable at '" + intermediatePath + "' outside of the configured root '" + authRoot + '\'');
                }
                intermediatePath = intermediatePath.substring(authRoot.length() + 1);
            }
            sb.append(DELIMITER).append(intermediatePath);
        } else {
            String hint = Text.unescapeIllegalJcrChars(nodeName);
            int idLength = hint.length();
            StringBuilder segment = new StringBuilder();
            for (int i = 0; i < this.defaultDepth; ++i) {
                if (idLength > i) {
                    segment.append(hint.charAt(i));
                } else {
                    segment.append(hint.charAt(idLength - 1));
                }
                sb.append(DELIMITER).append(Text.escapeIllegalJcrChars(segment.toString()));
            }
        }
        return sb.toString();
    }

    private String getNodeName(@Nonnull String authorizableId) {
        AuthorizableNodeName generator = Preconditions.checkNotNull(this.config.getConfigValue("authorizableNodeName", AuthorizableNodeName.DEFAULT, AuthorizableNodeName.class));
        return generator.generateNodeName(authorizableId);
    }
}

