/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.blob.split;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStoreWrapper;
import org.apache.jackrabbit.oak.spi.blob.split.DefaultSplitBlobStore;
import org.apache.jackrabbit.oak.spi.blob.split.SplitBlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrappingSplitBlobStore
implements BlobStoreWrapper,
SplitBlobStore {
    private static final Logger log = LoggerFactory.getLogger(WrappingSplitBlobStore.class);
    private DefaultSplitBlobStore splitBlobStore;
    private final String repositoryDir;
    private final BlobStore newBlobStore;

    public WrappingSplitBlobStore(String repositoryDir, BlobStore newBlobStore) {
        this.repositoryDir = repositoryDir;
        this.newBlobStore = newBlobStore;
    }

    @Override
    public void setBlobStore(BlobStore blobStore) {
        log.info("Internal blob store set: {}", (Object)blobStore);
        this.splitBlobStore = new DefaultSplitBlobStore(this.repositoryDir, blobStore, this.newBlobStore);
    }

    private SplitBlobStore getSplitBlobStore() {
        if (this.splitBlobStore == null) {
            throw new IllegalStateException("The old blob store hasn't been set yet.");
        }
        return this.splitBlobStore;
    }

    @Override
    public String writeBlob(InputStream in) throws IOException {
        return this.getSplitBlobStore().writeBlob(in);
    }

    @Override
    public int readBlob(String blobId, long pos, byte[] buff, int off, int length) throws IOException {
        return this.getSplitBlobStore().readBlob(blobId, pos, buff, off, length);
    }

    @Override
    public long getBlobLength(String blobId) throws IOException {
        return this.getSplitBlobStore().getBlobLength(blobId);
    }

    @Override
    public InputStream getInputStream(String blobId) throws IOException {
        return this.getSplitBlobStore().getInputStream(blobId);
    }

    @Override
    public String getBlobId(String reference) {
        return this.getSplitBlobStore().getBlobId(reference);
    }

    @Override
    public String getReference(String blobId) {
        return this.getSplitBlobStore().getReference(blobId);
    }

    @Override
    public boolean isMigrated(String blobId) throws IOException {
        return this.getSplitBlobStore().isMigrated(blobId);
    }
}

