/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication;

import java.io.IOException;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.GuestCredentials;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.spi.LoginModule;
import org.apache.jackrabbit.oak.spi.security.authentication.callback.CredentialsCallback;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GuestLoginModule
implements LoginModule {
    private static final Logger log = LoggerFactory.getLogger(GuestLoginModule.class);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private GuestCredentials guestCredentials;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
    }

    @Override
    public boolean login() {
        if (this.callbackHandler != null) {
            CredentialsCallback ccb = new CredentialsCallback();
            try {
                this.callbackHandler.handle(new Callback[]{ccb});
                Credentials credentials = ccb.getCredentials();
                if (credentials == null) {
                    this.guestCredentials = new GuestCredentials();
                    this.sharedState.put("org.apache.jackrabbit.credentials", this.guestCredentials);
                    return true;
                }
            }
            catch (IOException e) {
                log.debug("Login: Failed to retrieve Credentials from CallbackHandler", e);
            }
            catch (UnsupportedCallbackException e) {
                log.debug("Login: Failed to retrieve Credentials from CallbackHandler", e);
            }
        }
        return false;
    }

    @Override
    public boolean commit() {
        if (this.authenticationSucceeded()) {
            if (!this.subject.isReadOnly()) {
                this.subject.getPublicCredentials().add(this.guestCredentials);
                this.subject.getPrincipals().add(EveryonePrincipal.getInstance());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean abort() {
        this.guestCredentials = null;
        return true;
    }

    @Override
    public boolean logout() {
        return this.authenticationSucceeded();
    }

    private boolean authenticationSucceeded() {
        return this.guestCredentials != null;
    }
}

