/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.commons.iterator.AccessControlPolicyIteratorAdapter;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractAccessControlManager;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.PolicyOwner;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.CugPolicy;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugPolicyImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugUtil;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CugAccessControlManager
extends AbstractAccessControlManager
implements CugConstants,
PolicyOwner {
    private static final Logger log = LoggerFactory.getLogger(CugAccessControlManager.class);
    private final ConfigurationParameters config;
    private final PrincipalManager principalManager;

    public CugAccessControlManager(@Nonnull Root root, @Nonnull NamePathMapper namePathMapper, @Nonnull SecurityProvider securityProvider) {
        super(root, namePathMapper, securityProvider);
        this.config = securityProvider.getConfiguration(AuthorizationConfiguration.class).getParameters();
        this.principalManager = securityProvider.getConfiguration(PrincipalConfiguration.class).getPrincipalManager(root, namePathMapper);
    }

    @Override
    @Nonnull
    public Privilege[] getSupportedPrivileges(@Nullable String absPath) throws RepositoryException {
        if (this.isSupportedPath(this.getOakPath(absPath))) {
            return new Privilege[]{this.privilegeFromName("jcr:read")};
        }
        return new Privilege[0];
    }

    @Override
    public AccessControlPolicy[] getPolicies(String absPath) throws RepositoryException {
        CugPolicy cug;
        String oakPath = this.getOakPath(absPath);
        if (oakPath != null && this.isSupportedPath(oakPath) && (cug = this.getCugPolicy(oakPath)) != null) {
            return new AccessControlPolicy[]{cug};
        }
        return new AccessControlPolicy[0];
    }

    @Override
    public AccessControlPolicy[] getEffectivePolicies(String absPath) throws RepositoryException {
        String oakPath = this.getOakPath(absPath);
        this.getTree(oakPath, 128L, true);
        boolean enabled = this.config.getConfigValue("cugEnabled", false);
        if (enabled) {
            Root r = this.getRoot().getContentSession().getLatestRoot();
            ArrayList<CugPolicy> effective = new ArrayList<CugPolicy>();
            while (oakPath != null) {
                CugPolicy cug;
                if (this.isSupportedPath(oakPath) && (cug = this.getCugPolicy(oakPath, r.getTree(oakPath))) != null) {
                    effective.add(cug);
                }
                oakPath = PathUtils.denotesRoot(oakPath) ? null : PathUtils.getAncestorPath(oakPath, 1);
            }
            return effective.toArray(new AccessControlPolicy[effective.size()]);
        }
        return new AccessControlPolicy[0];
    }

    @Override
    public AccessControlPolicyIterator getApplicablePolicies(String absPath) throws RepositoryException {
        String oakPath = this.getOakPath(absPath);
        if (oakPath == null || !this.isSupportedPath(oakPath)) {
            return AccessControlPolicyIteratorAdapter.EMPTY;
        }
        CugPolicy cug = this.getCugPolicy(oakPath);
        if (cug == null) {
            cug = new CugPolicyImpl(oakPath, this.getNamePathMapper(), this.principalManager, CugUtil.getImportBehavior(this.config));
            return new AccessControlPolicyIteratorAdapter(ImmutableSet.of(cug));
        }
        return AccessControlPolicyIteratorAdapter.EMPTY;
    }

    @Override
    public void removePolicy(String absPath, AccessControlPolicy policy) throws RepositoryException {
        Tree cug;
        String oakPath = this.getOakPath(absPath);
        if (this.isSupportedPath(oakPath)) {
            CugAccessControlManager.checkValidPolicy(absPath, policy);
            Tree tree = this.getTree(oakPath, 256L, true);
            cug = tree.getChild("rep:cugPolicy");
            if (!CugUtil.definesCug(cug)) {
                throw new AccessControlException("Unexpected primary type of node rep:cugPolicy.");
            }
        } else {
            throw new AccessControlException("Unsupported path: " + absPath);
        }
        cug.remove();
    }

    @Override
    public void setPolicy(String absPath, AccessControlPolicy policy) throws RepositoryException {
        Tree cug;
        String oakPath = this.getOakPath(absPath);
        if (this.isSupportedPath(oakPath)) {
            CugAccessControlManager.checkValidPolicy(absPath, policy);
            Tree tree = this.getTree(oakPath, 256L, true);
            Tree typeRoot = this.getRoot().getTree("/jcr:system/jcr:nodeTypes");
            if (!TreeUtil.isNodeType(tree, "rep:CugMixin", typeRoot)) {
                TreeUtil.addMixin(tree, "rep:CugMixin", typeRoot, null);
            }
            if (tree.hasChild("rep:cugPolicy")) {
                cug = tree.getChild("rep:cugPolicy");
                if (!CugUtil.definesCug(cug)) {
                    throw new AccessControlException("Unexpected primary type of node rep:cugPolicy.");
                }
            } else {
                cug = TreeUtil.addChild(tree, "rep:cugPolicy", "rep:CugPolicy", typeRoot, null);
            }
        } else {
            throw new AccessControlException("Unsupported path: " + absPath);
        }
        cug.setProperty("rep:principalNames", ((CugPolicyImpl)policy).getPrincipalNames(), Type.STRINGS);
    }

    @Override
    public JackrabbitAccessControlPolicy[] getApplicablePolicies(Principal principal) throws RepositoryException {
        return new JackrabbitAccessControlPolicy[0];
    }

    @Override
    public JackrabbitAccessControlPolicy[] getPolicies(Principal principal) throws RepositoryException {
        return new JackrabbitAccessControlPolicy[0];
    }

    @Override
    public AccessControlPolicy[] getEffectivePolicies(Set<Principal> principals) throws RepositoryException {
        return new AccessControlPolicy[0];
    }

    @Override
    public boolean defines(@Nullable String absPath, @Nonnull AccessControlPolicy accessControlPolicy) {
        return CugAccessControlManager.isValidPolicy(absPath, accessControlPolicy);
    }

    private boolean isSupportedPath(@Nullable String oakPath) throws RepositoryException {
        this.checkValidPath(oakPath);
        return CugUtil.isSupportedPath(oakPath, this.config);
    }

    private void checkValidPath(@Nullable String oakPath) throws RepositoryException {
        if (oakPath != null) {
            this.getTree(oakPath, 0L, false);
        }
    }

    @CheckForNull
    private CugPolicy getCugPolicy(@Nonnull String oakPath) throws RepositoryException {
        return this.getCugPolicy(oakPath, this.getTree(oakPath, 128L, true));
    }

    @CheckForNull
    private CugPolicy getCugPolicy(@Nonnull String oakPath, @Nonnull Tree tree) {
        Tree cug = tree.getChild("rep:cugPolicy");
        if (CugUtil.definesCug(cug)) {
            return new CugPolicyImpl(oakPath, this.getNamePathMapper(), this.principalManager, CugUtil.getImportBehavior(this.config), this.getPrincipals(cug));
        }
        return null;
    }

    private Set<Principal> getPrincipals(@Nonnull Tree cugTree) {
        PropertyState property = cugTree.getProperty("rep:principalNames");
        if (property == null) {
            return Collections.emptySet();
        }
        return ImmutableSet.copyOf(Iterables.transform(property.getValue(Type.STRINGS), new Function<String, Principal>(){

            @Override
            public Principal apply(String principalName) {
                Principal principal = CugAccessControlManager.this.principalManager.getPrincipal(principalName);
                if (principal == null) {
                    log.debug("Unknown principal " + principalName);
                    principal = new PrincipalImpl(principalName);
                }
                return principal;
            }
        }));
    }

    private static boolean isValidPolicy(@Nullable String absPath, @Nonnull AccessControlPolicy policy) {
        return policy instanceof CugPolicyImpl && ((CugPolicyImpl)policy).getPath().equals(absPath);
    }

    private static void checkValidPolicy(@Nullable String absPath, @Nonnull AccessControlPolicy policy) throws AccessControlException {
        if (!(policy instanceof CugPolicyImpl)) {
            throw new AccessControlException("Unsupported policy implementation: " + policy);
        }
        CugPolicyImpl cug = (CugPolicyImpl)policy;
        if (!cug.getPath().equals(absPath)) {
            throw new AccessControlException("Path mismatch: Expected " + cug.getPath() + ", Found: " + absPath);
        }
    }
}

