/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugUtil;
import org.apache.jackrabbit.util.Text;

final class CugContext
implements Context,
CugConstants {
    static final Context INSTANCE = new CugContext();

    private CugContext() {
    }

    @Override
    public boolean definesProperty(@Nonnull Tree parent, @Nonnull PropertyState property) {
        return CugUtil.definesCug(parent, property);
    }

    @Override
    public boolean definesContextRoot(@Nonnull Tree tree) {
        return CugUtil.definesCug(tree);
    }

    @Override
    public boolean definesTree(@Nonnull Tree tree) {
        return CugUtil.definesCug(tree);
    }

    @Override
    public boolean definesLocation(@Nonnull TreeLocation location) {
        Tree tree;
        PropertyState p = location.getProperty();
        Tree tree2 = tree = p == null ? location.getTree() : location.getParent().getTree();
        if (tree != null) {
            return p == null ? this.definesTree(tree) : this.definesProperty(tree, p);
        }
        String path = location.getPath();
        return "rep:cugPolicy".equals(Text.getName(path)) || path.endsWith("rep:cugPolicy/rep:principalNames");
    }

    @Override
    public boolean definesInternal(@Nonnull Tree tree) {
        return false;
    }
}

