/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import java.security.AccessControlException;
import java.security.Principal;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugUtil;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.xml.PropInfo;
import org.apache.jackrabbit.oak.spi.xml.ProtectedPropertyImporter;
import org.apache.jackrabbit.oak.spi.xml.ReferenceChangeTracker;
import org.apache.jackrabbit.oak.spi.xml.TextValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CugImporter
implements ProtectedPropertyImporter,
CugConstants {
    private static final Logger log = LoggerFactory.getLogger(CugImporter.class);
    private boolean initialized;
    private ConfigurationParameters config;
    private int importBehavior;
    private PrincipalManager principalManager;

    CugImporter() {
    }

    @Override
    public boolean init(@Nonnull Session session, @Nonnull Root root, @Nonnull NamePathMapper namePathMapper, boolean isWorkspaceImport, int uuidBehavior, @Nonnull ReferenceChangeTracker referenceTracker, @Nonnull SecurityProvider securityProvider) {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        try {
            this.config = securityProvider.getConfiguration(AuthorizationConfiguration.class).getParameters();
            this.importBehavior = CugUtil.getImportBehavior(this.config);
            if (isWorkspaceImport) {
                PrincipalConfiguration pConfig = securityProvider.getConfiguration(PrincipalConfiguration.class);
                this.principalManager = pConfig.getPrincipalManager(root, namePathMapper);
            } else {
                this.principalManager = ((JackrabbitSession)session).getPrincipalManager();
            }
            this.initialized = true;
        }
        catch (RepositoryException e) {
            log.warn("Error while initializing cug importer", e);
        }
        return this.initialized;
    }

    @Override
    public void processReferences() throws RepositoryException {
    }

    @Override
    public boolean handlePropInfo(@Nonnull Tree parent, @Nonnull PropInfo protectedPropInfo, @Nonnull PropertyDefinition def) throws RepositoryException {
        if (CugUtil.definesCug(parent) && this.isValid(protectedPropInfo, def) && CugUtil.isSupportedPath(parent.getPath(), this.config)) {
            HashSet<String> principalNames = new HashSet<String>();
            block5: for (TextValue textValue : protectedPropInfo.getTextValues()) {
                String principalName = textValue.getString();
                Principal principal = this.principalManager.getPrincipal(principalName);
                if (principal == null) {
                    switch (this.importBehavior) {
                        case 1: {
                            log.debug("Ignoring unknown principal with name '" + principalName + "'.");
                            continue block5;
                        }
                        case 3: {
                            throw new AccessControlException("Unknown principal '" + principalName + "'.");
                        }
                        case 2: {
                            log.debug("Importing unknown principal '" + principalName + '\'');
                            principalNames.add(principalName);
                            continue block5;
                        }
                    }
                    throw new IllegalArgumentException("Invalid import behavior " + this.importBehavior);
                }
                principalNames.add(principalName);
            }
            parent.setProperty("rep:principalNames", principalNames, Type.STRINGS);
            return true;
        }
        return false;
    }

    @Override
    public void propertiesCompleted(@Nonnull Tree protectedParent) throws IllegalStateException, RepositoryException {
        if (CugUtil.definesCug(protectedParent) && !protectedParent.hasProperty("rep:principalNames")) {
            log.debug("Removing incomplete rep:cugPolicy node (due to missing mandatory property or unsupported path).");
            protectedParent.remove();
        }
    }

    private boolean isValid(@Nonnull PropInfo propInfo, @Nonnull PropertyDefinition def) {
        if ("rep:principalNames".equals(propInfo.getName())) {
            return def.isMultiple() && "rep:CugPolicy".equals(def.getDeclaringNodeType().getName());
        }
        return false;
    }
}

