/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.cug.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.PostValidationHook;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.cug.impl.CugUtil;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NestedCugHook
implements PostValidationHook,
CugConstants {
    private static final Logger log = LoggerFactory.getLogger(NestedCugHook.class);
    private Set<String> deletedCUGs = Sets.newHashSet();

    NestedCugHook() {
    }

    @Override
    @Nonnull
    public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
        NodeBuilder builder = after.builder();
        after.compareAgainstBaseState(before, new Diff(before, builder));
        this.deletedCUGs.clear();
        return builder.getNodeState();
    }

    public String toString() {
        return "NestedCugHook";
    }

    private static long addNestedCugPath(@Nonnull NodeBuilder parentBuilder, @Nonnull NodeBuilder builder, @Nonnull String pathWithNewCug) {
        PropertyState ps = parentBuilder.getProperty(":nestedCugs");
        PropertyBuilder pb = NestedCugHook.getHiddenPropertyBuilder(ps);
        if (ps != null) {
            ArrayList<String> moveToNestedCug = Lists.newArrayList();
            for (String p : ps.getValue(Type.STRINGS)) {
                if (Text.isDescendant(pathWithNewCug, p)) {
                    pb.removeValue(p);
                    moveToNestedCug.add(p);
                    continue;
                }
                if (!p.equals(pathWithNewCug)) continue;
                log.debug("Path of node holding a new nested CUG is already listed with the parent CUG.");
                pb.removeValue(p);
            }
            if (!moveToNestedCug.isEmpty()) {
                PropertyBuilder pb2 = NestedCugHook.getHiddenPropertyBuilder(builder.getProperty(":nestedCugs"));
                pb2.addValues(moveToNestedCug);
                builder.setProperty(pb2.getPropertyState());
            }
        }
        pb.addValue(pathWithNewCug);
        parentBuilder.setProperty(pb.getPropertyState());
        return pb.count();
    }

    private static int removeNestedCugPath(@Nonnull NodeBuilder parentBuilder, @Nonnull String toRemove, @Nonnull Iterable<String> toReconnect) {
        PropertyState ps = parentBuilder.getProperty(":nestedCugs");
        PropertyBuilder pb = NestedCugHook.getHiddenPropertyBuilder(ps);
        if (pb.hasValue(toRemove)) {
            pb.removeValue(toRemove);
            pb.addValues(toReconnect);
            if (pb.isEmpty()) {
                parentBuilder.removeProperty(":nestedCugs");
                return 0;
            }
            parentBuilder.setProperty(pb.getPropertyState());
            return pb.count();
        }
        log.debug("Parent CUG doesn't contain expected entry for removed nested CUG");
        return -1;
    }

    private static PropertyBuilder getHiddenPropertyBuilder(@Nullable PropertyState ps) {
        return PropertyBuilder.copy(Type.STRING, ps).setName(":nestedCugs").setArray();
    }

    private final class Diff
    extends DefaultNodeStateDiff {
        private final Diff parentDiff;
        private final boolean isRoot;
        private String path;
        private NodeState beforeState = null;
        private NodeBuilder afterBuilder;
        private boolean afterHoldsCug;

        private Diff(@Nonnull NodeState rootBefore, NodeBuilder rootAfter) {
            this.parentDiff = null;
            this.isRoot = true;
            this.path = "/";
            this.beforeState = rootBefore;
            this.afterBuilder = rootAfter;
            this.afterHoldsCug = CugUtil.hasCug(rootAfter);
        }

        private Diff(@Nonnull Diff parentDiff, @Nullable String name, @Nullable NodeState before, NodeBuilder after) {
            this.parentDiff = parentDiff;
            this.isRoot = false;
            this.path = PathUtils.concat(parentDiff.path, name);
            this.beforeState = before;
            this.afterBuilder = after;
            this.afterHoldsCug = CugUtil.hasCug(after);
        }

        @Override
        public boolean childNodeAdded(String name, NodeState after) {
            if (!NodeStateUtils.isHidden(name)) {
                if (CugUtil.definesCug(name, after)) {
                    if (this.isRoot) {
                        PropertyState alt = this.afterBuilder.getProperty(":nestedCugs");
                        if (alt != null) {
                            NodeBuilder cugNode = this.afterBuilder.getChildNode("rep:cugPolicy");
                            cugNode.setProperty(alt);
                            this.afterBuilder.removeProperty(":nestedCugs");
                            this.afterBuilder.removeProperty(":topCugCnt");
                        }
                    } else {
                        Diff diff = this.parentDiff;
                        while (diff != null) {
                            if (diff.afterHoldsCug) {
                                NodeBuilder cugNode = diff.afterBuilder.getChildNode("rep:cugPolicy");
                                NestedCugHook.addNestedCugPath(cugNode, this.afterBuilder.getChildNode("rep:cugPolicy"), this.path);
                                break;
                            }
                            if (diff.isRoot) {
                                long cnt = NestedCugHook.addNestedCugPath(diff.afterBuilder, this.afterBuilder.getChildNode(name), this.path);
                                diff.afterBuilder.setProperty(":topCugCnt", cnt, Type.LONG);
                            }
                            diff = diff.parentDiff;
                        }
                    }
                } else {
                    after.compareAgainstBaseState(EmptyNodeState.EMPTY_NODE, new Diff(this, name, null, this.afterBuilder.getChildNode(name)));
                }
            }
            return true;
        }

        @Override
        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            if (!NodeStateUtils.isHidden(name)) {
                after.compareAgainstBaseState(before, new Diff(this, name, before, this.afterBuilder.getChildNode(name)));
            }
            return true;
        }

        @Override
        public boolean childNodeDeleted(String name, NodeState before) {
            if (!NodeStateUtils.isHidden(name)) {
                if (CugUtil.definesCug(name, before)) {
                    NestedCugHook.this.deletedCUGs.add(this.path);
                    HashSet<String> reconnect = Sets.newHashSet();
                    if (this.afterBuilder != null) {
                        for (String nestedCug : before.getStrings(":nestedCugs")) {
                            if (NestedCugHook.this.deletedCUGs.contains(nestedCug)) continue;
                            String relPath = PathUtils.relativize(this.path, nestedCug);
                            NodeState ns = NodeStateUtils.getNode(this.afterBuilder.getNodeState(), relPath);
                            if (!CugUtil.hasCug(ns)) continue;
                            reconnect.add(nestedCug);
                        }
                    }
                    if (this.isRoot) {
                        if (!Iterables.isEmpty(reconnect)) {
                            this.afterBuilder.setProperty(":nestedCugs", reconnect, Type.STRINGS);
                            this.afterBuilder.setProperty(":topCugCnt", reconnect.size());
                        }
                    } else {
                        NodeBuilder cugNode;
                        Diff diff = this.parentDiff;
                        while (!(diff == null || diff.afterHoldsCug && NestedCugHook.removeNestedCugPath(cugNode = diff.afterBuilder.getChildNode("rep:cugPolicy"), this.path, reconnect) > -1)) {
                            PropertyState ps;
                            if (CugUtil.hasCug(diff.beforeState) && (ps = (cugNode = diff.beforeState.getChildNode("rep:cugPolicy")).getProperty(":nestedCugs")) != null && Iterables.contains(ps.getValue(Type.STRINGS), this.path)) {
                                log.debug("Nested cug property containing " + this.path + " has also been removed; no reconnect required.");
                                break;
                            }
                            if (diff.isRoot) {
                                long cnt = NestedCugHook.removeNestedCugPath(diff.afterBuilder, this.path, reconnect);
                                if (cnt < 0L) {
                                    log.warn("Failed to updated nested CUG info for path '" + this.path + "'.");
                                } else if (cnt == 0L) {
                                    diff.afterBuilder.removeProperty(":topCugCnt");
                                } else {
                                    diff.afterBuilder.setProperty(":topCugCnt", cnt, Type.LONG);
                                }
                            }
                            diff = diff.parentDiff;
                        }
                    }
                } else {
                    EmptyNodeState.EMPTY_NODE.compareAgainstBaseState(before, new Diff(this, name, before, null));
                }
            }
            return true;
        }
    }
}

