/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.user.action;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.user.action.AccessControlAction;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableAction;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableActionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Jackrabbit Oak AuthorizableActionProvider")
@Service(value={AuthorizableActionProvider.class})
@Properties(value={@Property(name="enabledActions", label="Authorizable Actions", description="The set of actions that is supported by this provider implementation.", cardinality=4, options={@PropertyOption(name="org.apache.jackrabbit.oak.spi.security.user.action.AccessControlAction", value="AccessControlAction"), @PropertyOption(name="org.apache.jackrabbit.oak.spi.security.user.action.PasswordValidationAction", value="PasswordValidationAction"), @PropertyOption(name="org.apache.jackrabbit.oak.spi.security.user.action.PasswordChangeAction", value="PasswordChangeAction"), @PropertyOption(name="org.apache.jackrabbit.oak.spi.security.user.action.ClearMembershipAction", value="ClearMembershipAction")}), @Property(name="userPrivilegeNames", label="Configure AccessControlAction: User Privileges", description="The name of the privileges that should be granted to a given user on it's home.", cardinality=0x7FFFFFFF), @Property(name="groupPrivilegeNames", label="Configure AccessControlAction: Group Privileges", description="The name of the privileges that should be granted to a given group on it's home.", cardinality=0x7FFFFFFF), @Property(name="constraint", label="Configure PasswordValidationAction: Password Constraint", description="A regular expression specifying the pattern that must be matched by a user's password.")})
public class DefaultAuthorizableActionProvider
implements AuthorizableActionProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultAuthorizableActionProvider.class);
    static final String ENABLED_ACTIONS = "enabledActions";
    private String[] enabledActions = new String[]{AccessControlAction.class.getName()};
    private ConfigurationParameters config = ConfigurationParameters.EMPTY;

    public DefaultAuthorizableActionProvider() {
    }

    public DefaultAuthorizableActionProvider(ConfigurationParameters config) {
        this.config = config;
    }

    @Override
    @Nonnull
    public List<? extends AuthorizableAction> getAuthorizableActions(@Nonnull SecurityProvider securityProvider) {
        ArrayList<AuthorizableAction> actions = Lists.newArrayList();
        for (String className : this.enabledActions) {
            try {
                Object o = Class.forName(className).newInstance();
                if (!(o instanceof AuthorizableAction)) continue;
                actions.add((AuthorizableAction)o);
            }
            catch (Exception e) {
                log.debug("Unable to create authorizable action", e);
            }
        }
        for (AuthorizableAction action : actions) {
            action.init(securityProvider, this.config);
        }
        return actions;
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        this.config = ConfigurationParameters.of(properties);
        this.enabledActions = PropertiesUtil.toStringArray(properties.get(ENABLED_ACTIONS), new String[0]);
    }
}

