/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.state;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class ReadOnlyBuilder
implements NodeBuilder {
    @Nonnull
    private final NodeState state;

    public ReadOnlyBuilder(@Nonnull NodeState state) {
        this.state = Preconditions.checkNotNull(state);
    }

    protected RuntimeException unsupported() {
        return new UnsupportedOperationException("This builder is read-only.");
    }

    @Override
    public boolean exists() {
        return this.state.exists();
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public boolean isNew(String name) {
        return false;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public boolean isReplaced() {
        return false;
    }

    @Override
    public boolean isReplaced(String name) {
        return false;
    }

    @Override
    @Nonnull
    public NodeState getNodeState() {
        return this.state;
    }

    @Override
    @Nonnull
    public NodeState getBaseState() {
        return this.state;
    }

    @Override
    public long getChildNodeCount(long max) {
        return this.state.getChildNodeCount(max);
    }

    @Override
    public boolean hasChildNode(@Nonnull String name) {
        return this.state.hasChildNode(name);
    }

    @Override
    @Nonnull
    public Iterable<String> getChildNodeNames() {
        return this.state.getChildNodeNames();
    }

    @Override
    @Nonnull
    public NodeBuilder setChildNode(@Nonnull String name, @Nonnull NodeState nodeState) {
        throw this.unsupported();
    }

    @Override
    public boolean remove() {
        throw this.unsupported();
    }

    @Override
    public boolean moveTo(@Nonnull NodeBuilder newParent, @Nonnull String newName) {
        throw this.unsupported();
    }

    @Override
    public long getPropertyCount() {
        return this.state.getPropertyCount();
    }

    @Override
    @Nonnull
    public Iterable<? extends PropertyState> getProperties() {
        return this.state.getProperties();
    }

    @Override
    public boolean hasProperty(String name) {
        return this.state.hasProperty(name);
    }

    @Override
    public PropertyState getProperty(String name) {
        return this.state.getProperty(name);
    }

    @Override
    public boolean getBoolean(@Nonnull String name) {
        return this.state.getBoolean(name);
    }

    @Override
    @CheckForNull
    public String getString(@Nonnull String name) {
        return this.state.getString(name);
    }

    @Override
    @CheckForNull
    public String getName(@Nonnull String name) {
        return this.state.getName(name);
    }

    @Override
    @Nonnull
    public Iterable<String> getNames(@Nonnull String name) {
        return this.state.getNames(name);
    }

    @Override
    @Nonnull
    public NodeBuilder removeProperty(String name) {
        throw this.unsupported();
    }

    @Override
    @Nonnull
    public NodeBuilder setProperty(@Nonnull PropertyState property) {
        throw this.unsupported();
    }

    @Override
    @Nonnull
    public <T> NodeBuilder setProperty(String name, @Nonnull T value) {
        throw this.unsupported();
    }

    @Override
    @Nonnull
    public <T> NodeBuilder setProperty(String name, @Nonnull T value, Type<T> type) {
        throw this.unsupported();
    }

    @Override
    @Nonnull
    public ReadOnlyBuilder child(@Nonnull String name) {
        NodeState child = this.state.getChildNode(name);
        if (child.exists()) {
            return new ReadOnlyBuilder(child);
        }
        throw this.unsupported();
    }

    @Override
    @Nonnull
    public NodeBuilder getChildNode(@Nonnull String name) {
        return new ReadOnlyBuilder(this.state.getChildNode(name));
    }

    @Override
    @Nonnull
    public NodeBuilder setChildNode(@Nonnull String name) {
        throw this.unsupported();
    }

    @Override
    public Blob createBlob(InputStream stream) throws IOException {
        throw this.unsupported();
    }
}

