/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.TransformerException;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlRequestEntity
implements RequestEntity {
    private static Logger log = LoggerFactory.getLogger(XmlRequestEntity.class);
    private final ByteArrayOutputStream xml = new ByteArrayOutputStream();

    public XmlRequestEntity(Document xmlDocument) throws IOException {
        try {
            DomUtil.transformDocument(xmlDocument, this.xml);
        }
        catch (TransformerException e) {
            log.error(e.getMessage());
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            log.error(e.getMessage());
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public String getContentType() {
        return "text/xml; charset=UTF-8";
    }

    @Override
    public void writeRequest(OutputStream out) throws IOException {
        this.xml.writeTo(out);
    }

    @Override
    public long getContentLength() {
        return this.xml.size();
    }
}

