/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.LongRangeCounter;
import org.apache.lucene.facet.range.RangeFacetCounts;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.LongFieldSource;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;

public class LongRangeFacetCounts
extends RangeFacetCounts {
    public LongRangeFacetCounts(String field, FacetsCollector hits, LongRange ... ranges) throws IOException {
        this(field, (ValueSource)new LongFieldSource(field), hits, ranges);
    }

    public LongRangeFacetCounts(String field, ValueSource valueSource, FacetsCollector hits, LongRange ... ranges) throws IOException {
        this(field, valueSource, hits, (Filter)null, ranges);
    }

    public LongRangeFacetCounts(String field, ValueSource valueSource, FacetsCollector hits, Filter fastMatchFilter, LongRange ... ranges) throws IOException {
        super(field, ranges, fastMatchFilter);
        this.count(valueSource, hits.getMatchingDocs());
    }

    private void count(ValueSource valueSource, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        LongRange[] ranges = (LongRange[])this.ranges;
        LongRangeCounter counter = new LongRangeCounter(ranges);
        int missingCount = 0;
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            int doc;
            Bits bits;
            FunctionValues fv = valueSource.getValues(Collections.emptyMap(), hits.context);
            this.totCount += hits.totalHits;
            if (this.fastMatchFilter != null) {
                DocIdSet dis = this.fastMatchFilter.getDocIdSet(hits.context, null);
                if (dis == null) continue;
                bits = dis.bits();
                if (bits == null) {
                    throw new IllegalArgumentException("fastMatchFilter does not implement DocIdSet.bits");
                }
            } else {
                bits = null;
            }
            DocIdSetIterator docs = hits.bits.iterator();
            while ((doc = docs.nextDoc()) != Integer.MAX_VALUE) {
                if (bits != null && !bits.get(doc)) {
                    ++doc;
                    continue;
                }
                if (fv.exists(doc)) {
                    counter.add(fv.longVal(doc));
                    continue;
                }
                ++missingCount;
            }
        }
        int x = counter.fillCounts(this.counts);
        this.totCount -= (missingCount += x);
    }
}

