/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.Assign;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.OverseerCollectionProcessor;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClosableThread;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.ImplicitDocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.RoutingRule;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Overseer {
    public static final String QUEUE_OPERATION = "operation";
    public static final String DELETECORE = "deletecore";
    public static final String REMOVECOLLECTION = "removecollection";
    public static final String REMOVESHARD = "removeshard";
    public static final String ADD_ROUTING_RULE = "addroutingrule";
    public static final String REMOVE_ROUTING_RULE = "removeroutingrule";
    public static final int STATE_UPDATE_DELAY = 1500;
    private static Logger log = LoggerFactory.getLogger(Overseer.class);
    private long lastUpdatedTime = 0L;
    private volatile OverseerThread ccThread;
    private volatile OverseerThread updaterThread;
    private ZkStateReader reader;
    private ShardHandler shardHandler;
    private String adminPath;
    private OverseerCollectionProcessor ocp;

    static void getShardNames(Integer numShards, List<String> shardNames) {
        if (numShards == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards is a required param");
        }
        for (int i = 0; i < numShards; ++i) {
            String sliceName = "shard" + (i + 1);
            shardNames.add(sliceName);
        }
    }

    static void getShardNames(List<String> shardNames, String shards) {
        if (shards == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "shards is a required param");
        }
        for (String s : shards.split(",")) {
            if (s == null || s.trim().isEmpty()) continue;
            shardNames.add(s.trim());
        }
        if (shardNames.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "shards is a required param");
        }
    }

    public Overseer(ShardHandler shardHandler, String adminPath, ZkStateReader reader) throws KeeperException, InterruptedException {
        this.reader = reader;
        this.shardHandler = shardHandler;
        this.adminPath = adminPath;
    }

    public void start(String id) {
        this.close();
        log.info("Overseer (id=" + id + ") starting");
        Overseer.createOverseerNode(this.reader.getZkClient());
        ThreadGroup tg = new ThreadGroup("Overseer state updater.");
        this.updaterThread = new OverseerThread(tg, new ClusterStateUpdater(this.reader, id));
        this.updaterThread.setDaemon(true);
        ThreadGroup ccTg = new ThreadGroup("Overseer collection creation process.");
        this.ocp = new OverseerCollectionProcessor(this.reader, id, this.shardHandler, this.adminPath);
        this.ccThread = new OverseerThread(ccTg, this.ocp, "Overseer-" + id);
        this.ccThread.setDaemon(true);
        this.updaterThread.start();
        this.ccThread.start();
    }

    public OverseerThread getUpdaterThread() {
        return this.updaterThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.updaterThread != null) {
                try {
                    this.updaterThread.close();
                    this.updaterThread.interrupt();
                }
                catch (Exception e) {
                    log.error("Error closing updaterThread", e);
                }
            }
        }
        finally {
            if (this.ccThread != null) {
                try {
                    this.ccThread.close();
                    this.ccThread.interrupt();
                }
                catch (Exception e) {
                    log.error("Error closing ccThread", e);
                }
            }
        }
        this.updaterThread = null;
        this.ccThread = null;
    }

    public static DistributedQueue getInQueue(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedQueue(zkClient, "/overseer/queue", null);
    }

    static DistributedQueue getInternalQueue(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedQueue(zkClient, "/overseer/queue-work", null);
    }

    static DistributedQueue getCollectionQueue(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedQueue(zkClient, "/overseer/collection-queue-work", null);
    }

    private static void createOverseerNode(SolrZkClient zkClient) {
        try {
            zkClient.create("/overseer", new byte[0], CreateMode.PERSISTENT, true);
        }
        catch (KeeperException.NodeExistsException e) {
        }
        catch (InterruptedException e) {
            log.error("Could not create Overseer node", e);
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (KeeperException e) {
            log.error("Could not create Overseer node", e);
            throw new RuntimeException(e);
        }
    }

    class OverseerThread
    extends Thread
    implements ClosableThread {
        protected volatile boolean isClosed;
        private ClosableThread thread;

        public OverseerThread(ThreadGroup tg, ClosableThread thread) {
            super(tg, (Runnable)((Object)thread));
            this.thread = thread;
        }

        public OverseerThread(ThreadGroup ccTg, ClosableThread thread, String name) {
            super(ccTg, (Runnable)((Object)thread), name);
            this.thread = thread;
        }

        @Override
        public void close() {
            this.thread.close();
            this.isClosed = true;
        }

        @Override
        public boolean isClosed() {
            return this.isClosed;
        }
    }

    private class ClusterStateUpdater
    implements Runnable,
    ClosableThread {
        private final ZkStateReader reader;
        private final SolrZkClient zkClient;
        private final String myId;
        private final DistributedQueue stateUpdateQueue;
        private final DistributedQueue workQueue;
        private boolean isClosed = false;

        public ClusterStateUpdater(ZkStateReader reader, String myId) {
            this.zkClient = reader.getZkClient();
            this.stateUpdateQueue = Overseer.getInQueue(this.zkClient);
            this.workQueue = Overseer.getInternalQueue(this.zkClient);
            this.myId = myId;
            this.reader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String operation;
            ZkNodeProps message;
            ClusterState clusterState;
            LeaderStatus isLeader = this.amILeader();
            while (isLeader == LeaderStatus.DONT_KNOW) {
                log.debug("am_i_leader unclear {}", (Object)isLeader);
                isLeader = this.amILeader();
            }
            if (!this.isClosed && LeaderStatus.YES == isLeader) {
                Object object = this.reader.getUpdateLock();
                synchronized (object) {
                    block34: {
                        try {
                            byte[] head = this.workQueue.peek();
                            if (head == null) break block34;
                            this.reader.updateClusterState(true);
                            clusterState = this.reader.getClusterState();
                            log.info("Replaying operations from work queue.");
                            while (head != null && LeaderStatus.NO != (isLeader = this.amILeader())) {
                                if (LeaderStatus.YES == isLeader) {
                                    message = ZkNodeProps.load(head);
                                    operation = message.getStr(Overseer.QUEUE_OPERATION);
                                    try {
                                        clusterState = this.processMessage(clusterState, message, operation);
                                    }
                                    catch (Exception e) {
                                        log.error("Overseer could not process the current clusterstate state update message, skipping the message.", e);
                                    }
                                    this.zkClient.setData("/clusterstate.json", ZkStateReader.toJSON(clusterState), true);
                                    this.workQueue.poll();
                                } else {
                                    log.info("am_i_leader unclear {}", (Object)isLeader);
                                }
                                head = this.workQueue.peek();
                            }
                        }
                        catch (KeeperException e) {
                            if (e.code() == KeeperException.Code.SESSIONEXPIRED) {
                                log.warn("Solr cannot talk to ZK, exiting Overseer work queue loop", e);
                                return;
                            }
                            log.error("Exception in Overseer work queue loop", e);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                        catch (Exception e) {
                            log.error("Exception in Overseer work queue loop", e);
                        }
                    }
                }
            }
            log.info("Starting to work on the main queue");
            while (!this.isClosed && LeaderStatus.NO != (isLeader = this.amILeader())) {
                if (LeaderStatus.YES != isLeader) {
                    log.debug("am_i_leader unclear {}", (Object)isLeader);
                    continue;
                }
                DistributedQueue.QueueEvent head = null;
                try {
                    head = this.stateUpdateQueue.peek(true);
                }
                catch (KeeperException e) {
                    if (e.code() == KeeperException.Code.SESSIONEXPIRED) {
                        log.warn("Solr cannot talk to ZK, exiting Overseer main queue loop", e);
                        return;
                    }
                    log.error("Exception in Overseer main queue loop", e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (Exception e) {
                    log.error("Exception in Overseer main queue loop", e);
                }
                Object object = this.reader.getUpdateLock();
                synchronized (object) {
                    try {
                        this.reader.updateClusterState(true);
                        clusterState = this.reader.getClusterState();
                        while (head != null) {
                            message = ZkNodeProps.load(head.getBytes());
                            operation = message.getStr(Overseer.QUEUE_OPERATION);
                            try {
                                clusterState = this.processMessage(clusterState, message, operation);
                            }
                            catch (Exception e) {
                                log.error("Overseer could not process the current clusterstate state update message, skipping the message.", e);
                            }
                            this.workQueue.offer(head.getBytes());
                            this.stateUpdateQueue.poll();
                            if (System.nanoTime() - Overseer.this.lastUpdatedTime > TimeUnit.NANOSECONDS.convert(1500L, TimeUnit.MILLISECONDS)) break;
                            head = this.stateUpdateQueue.peek(100L);
                        }
                        Overseer.this.lastUpdatedTime = System.nanoTime();
                        this.zkClient.setData("/clusterstate.json", ZkStateReader.toJSON(clusterState), true);
                        while (this.workQueue.poll() != null) {
                        }
                    }
                    catch (KeeperException e) {
                        if (e.code() == KeeperException.Code.SESSIONEXPIRED) {
                            log.warn("Solr cannot talk to ZK, exiting Overseer main queue loop", e);
                            return;
                        }
                        log.error("Exception in Overseer main queue loop", e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    catch (Exception e) {
                        log.error("Exception in Overseer main queue loop", e);
                    }
                }
            }
        }

        private ClusterState processMessage(ClusterState clusterState, ZkNodeProps message, String operation) {
            if ("state".equals(operation)) {
                clusterState = this.updateState(clusterState, message);
            } else if (Overseer.DELETECORE.equals(operation)) {
                clusterState = this.removeCore(clusterState, message);
            } else if (Overseer.REMOVECOLLECTION.equals(operation)) {
                clusterState = this.removeCollection(clusterState, message);
            } else if (Overseer.REMOVESHARD.equals(operation)) {
                clusterState = this.removeShard(clusterState, message);
            } else if ("leader".equals(operation)) {
                StringBuilder sb = new StringBuilder();
                String baseUrl = message.getStr("base_url");
                String coreName = message.getStr("core");
                sb.append(baseUrl);
                if (baseUrl != null && !baseUrl.endsWith("/")) {
                    sb.append("/");
                }
                sb.append(coreName == null ? "" : coreName);
                if (!sb.substring(sb.length() - 1).equals("/")) {
                    sb.append("/");
                }
                clusterState = this.setShardLeader(clusterState, message.getStr("collection"), message.getStr("shard"), sb.length() > 0 ? sb.toString() : null);
            } else if ("createshard".equals(operation)) {
                clusterState = this.createShard(clusterState, message);
            } else if ("updateshardstate".equals(operation)) {
                clusterState = this.updateShardState(clusterState, message);
            } else if ("createcollection".equals(operation)) {
                clusterState = this.buildCollection(clusterState, message);
            } else if (Overseer.ADD_ROUTING_RULE.equals(operation)) {
                clusterState = this.addRoutingRule(clusterState, message);
            } else if (Overseer.REMOVE_ROUTING_RULE.equals(operation)) {
                clusterState = this.removeRoutingRule(clusterState, message);
            } else {
                throw new RuntimeException("unknown operation:" + operation + " contents:" + message.getProperties());
            }
            return clusterState;
        }

        private ClusterState buildCollection(ClusterState clusterState, ZkNodeProps message) {
            String collection = message.getStr("name");
            log.info("building a new collection: " + collection);
            if (clusterState.hasCollection(collection)) {
                log.warn("Collection {} already exists. exit", (Object)collection);
                return clusterState;
            }
            ArrayList<String> shardNames = new ArrayList<String>();
            if ("implicit".equals(message.getStr("router.name", "compositeId"))) {
                Overseer.getShardNames(shardNames, message.getStr("shards", "compositeId"));
            } else {
                int numShards = message.getInt("numShards", -1);
                if (numShards < 1) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "numShards is a required parameter for 'compositeId' router");
                }
                Overseer.getShardNames(numShards, shardNames);
            }
            return this.createCollection(clusterState, collection, shardNames, message);
        }

        private ClusterState updateShardState(ClusterState clusterState, ZkNodeProps message) {
            String collection = message.getStr("collection");
            if (!this.checkCollectionKeyExistence(message)) {
                return clusterState;
            }
            log.info("Update shard state invoked for collection: " + collection + " with message: " + message);
            for (String key : message.keySet()) {
                if ("collection".equals(key) || Overseer.QUEUE_OPERATION.equals(key)) continue;
                Slice slice = clusterState.getSlice(collection, key);
                if (slice == null) {
                    throw new RuntimeException("Overseer.updateShardState unknown collection: " + collection + " slice: " + key);
                }
                log.info("Update shard state " + key + " to " + message.getStr(key));
                Map<String, Object> props = slice.shallowCopy();
                if (Slice.RECOVERY.equals(props.get(Slice.STATE)) && Slice.ACTIVE.equals(message.getStr(key))) {
                    props.remove(Slice.PARENT);
                }
                props.put(Slice.STATE, message.getStr(key));
                Slice newSlice = new Slice(slice.getName(), slice.getReplicasCopy(), props);
                clusterState = this.updateSlice(clusterState, collection, newSlice);
            }
            return clusterState;
        }

        private ClusterState addRoutingRule(ClusterState clusterState, ZkNodeProps message) {
            Map<String, Object> map;
            RoutingRule r;
            String collection = message.getStr("collection");
            if (!this.checkCollectionKeyExistence(message)) {
                return clusterState;
            }
            String shard = message.getStr("shard");
            String routeKey = message.getStr("routeKey");
            String range = message.getStr("range");
            String targetCollection = message.getStr("targetCollection");
            String targetShard = message.getStr("targetShard");
            String expireAt = message.getStr("expireAt");
            Slice slice = clusterState.getSlice(collection, shard);
            if (slice == null) {
                throw new RuntimeException("Overseer.addRoutingRule unknown collection: " + collection + " slice:" + shard);
            }
            Map<String, RoutingRule> routingRules = slice.getRoutingRules();
            if (routingRules == null) {
                routingRules = new HashMap<String, RoutingRule>();
            }
            if ((r = routingRules.get(routeKey)) == null) {
                map = new HashMap<String, Object>();
                map.put("routeRanges", range);
                map.put("targetCollection", targetCollection);
                map.put("expireAt", expireAt);
                RoutingRule rule = new RoutingRule(routeKey, map);
                routingRules.put(routeKey, rule);
            } else {
                map = r.shallowCopy();
                map.put("routeRanges", map.get("routeRanges") + "," + range);
                map.put("expireAt", expireAt);
                routingRules.put(routeKey, new RoutingRule(routeKey, map));
            }
            Map<String, Object> props = slice.shallowCopy();
            props.put("routingRules", routingRules);
            Slice newSlice = new Slice(slice.getName(), slice.getReplicasCopy(), props);
            clusterState = this.updateSlice(clusterState, collection, newSlice);
            return clusterState;
        }

        private boolean checkCollectionKeyExistence(ZkNodeProps message) {
            return this.checkKeyExistence(message, "collection");
        }

        private boolean checkKeyExistence(ZkNodeProps message, String key) {
            String value = message.getStr(key);
            if (value == null || value.trim().length() == 0) {
                log.error("Skipping invalid Overseer message because it has no " + key + " specified: " + message);
                return false;
            }
            return true;
        }

        private ClusterState removeRoutingRule(ClusterState clusterState, ZkNodeProps message) {
            String collection = message.getStr("collection");
            if (!this.checkCollectionKeyExistence(message)) {
                return clusterState;
            }
            String shard = message.getStr("shard");
            String routeKeyStr = message.getStr("routeKey");
            log.info("Overseer.removeRoutingRule invoked for collection: " + collection + " shard: " + shard + " routeKey: " + routeKeyStr);
            Slice slice = clusterState.getSlice(collection, shard);
            if (slice == null) {
                log.warn("Unknown collection: " + collection + " shard: " + shard);
                return clusterState;
            }
            Map<String, RoutingRule> routingRules = slice.getRoutingRules();
            if (routingRules != null) {
                routingRules.remove(routeKeyStr);
                Map<String, Object> props = slice.shallowCopy();
                props.put("routingRules", routingRules);
                Slice newSlice = new Slice(slice.getName(), slice.getReplicasCopy(), props);
                clusterState = this.updateSlice(clusterState, collection, newSlice);
            }
            return clusterState;
        }

        private ClusterState createShard(ClusterState clusterState, ZkNodeProps message) {
            String collection = message.getStr("collection");
            if (!this.checkCollectionKeyExistence(message)) {
                return clusterState;
            }
            String shardId = message.getStr("shard");
            Slice slice = clusterState.getSlice(collection, shardId);
            if (slice == null) {
                Map replicas = Collections.EMPTY_MAP;
                HashMap<String, Object> sliceProps = new HashMap<String, Object>();
                String shardRange = message.getStr("shard_range");
                String shardState = message.getStr("shard_state");
                String shardParent = message.getStr("shard_parent");
                sliceProps.put(Slice.RANGE, shardRange);
                sliceProps.put(Slice.STATE, shardState);
                if (shardParent != null) {
                    sliceProps.put(Slice.PARENT, shardParent);
                }
                slice = new Slice(shardId, replicas, sliceProps);
                clusterState = this.updateSlice(clusterState, collection, slice);
            } else {
                log.error("Unable to create Shard: " + shardId + " because it already exists in collection: " + collection);
            }
            return clusterState;
        }

        private LeaderStatus amILeader() {
            try {
                ZkNodeProps props = ZkNodeProps.load(this.zkClient.getData("/overseer_elect/leader", null, null, true));
                if (this.myId.equals(props.getStr("id"))) {
                    return LeaderStatus.YES;
                }
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.CONNECTIONLOSS) {
                    log.error("", e);
                    return LeaderStatus.DONT_KNOW;
                }
                if (e.code() == KeeperException.Code.SESSIONEXPIRED) {
                    log.info("", e);
                } else {
                    log.warn("", e);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            log.info("According to ZK I (id=" + this.myId + ") am no longer a leader.");
            return LeaderStatus.NO;
        }

        private ClusterState updateState(ClusterState clusterState, ZkNodeProps message) {
            Map<Object, Object> replicas;
            Replica oldReplica;
            String collection = message.getStr("collection");
            if (!this.checkCollectionKeyExistence(message)) {
                return clusterState;
            }
            Integer numShards = message.getInt("numShards", null);
            log.info("Update state numShards={} message={}", (Object)numShards, (Object)message);
            ArrayList<String> shardNames = new ArrayList<String>();
            boolean collectionExists = clusterState.hasCollection(collection);
            if (!collectionExists && numShards != null) {
                Overseer.getShardNames(numShards, shardNames);
                clusterState = this.createCollection(clusterState, collection, shardNames, message);
            }
            String sliceName = message.getStr("shard");
            String coreNodeName = message.getStr("core_node_name");
            if (coreNodeName == null) {
                coreNodeName = this.getAssignedCoreNodeName(clusterState, message);
                if (coreNodeName != null) {
                    log.info("node=" + coreNodeName + " is already registered");
                } else {
                    coreNodeName = Assign.assignNode(collection, clusterState);
                }
                message.getProperties().put("core_node_name", coreNodeName);
            }
            if (sliceName == null && (sliceName = this.getAssignedId(clusterState, coreNodeName, message)) != null) {
                log.info("shard=" + sliceName + " is already registered");
            }
            if (sliceName == null) {
                if (collectionExists) {
                    numShards = clusterState.getCollection(collection).getSlices().size();
                    log.info("Collection already exists with numShards=" + numShards);
                }
                sliceName = Assign.assignShard(collection, clusterState, numShards);
                log.info("Assigning new node to shard shard=" + sliceName);
            }
            Slice slice = clusterState.getSlice(collection, sliceName);
            LinkedHashMap<String, Object> replicaProps = new LinkedHashMap<String, Object>();
            replicaProps.putAll(message.getProperties());
            if (slice != null && (oldReplica = slice.getReplicasMap().get(coreNodeName)) != null && oldReplica.containsKey("leader")) {
                replicaProps.put("leader", oldReplica.get("leader"));
            }
            replicaProps.remove("numShards");
            replicaProps.remove("core_node_name");
            replicaProps.remove("shard");
            replicaProps.remove("collection");
            replicaProps.remove(Overseer.QUEUE_OPERATION);
            Set entrySet = replicaProps.entrySet();
            ArrayList removeKeys = new ArrayList();
            for (Map.Entry entry : entrySet) {
                if (entry.getValue() != null) continue;
                removeKeys.add(entry.getKey());
            }
            for (String removeKey : removeKeys) {
                replicaProps.remove(removeKey);
            }
            replicaProps.remove("core_node_name");
            String shardRange = (String)replicaProps.remove("shard_range");
            String shardState = (String)replicaProps.remove("shard_state");
            String shardParent = (String)replicaProps.remove("shard_parent");
            Replica replica = new Replica(coreNodeName, replicaProps);
            Map<Object, Object> sliceProps = null;
            if (slice != null) {
                clusterState = this.checkAndCompleteShardSplit(clusterState, collection, coreNodeName, sliceName, replicaProps);
                slice = clusterState.getSlice(collection, sliceName);
                sliceProps = slice.getProperties();
                replicas = slice.getReplicasCopy();
            } else {
                replicas = new HashMap(1);
                sliceProps = new HashMap<String, String>();
                sliceProps.put(Slice.RANGE, shardRange);
                sliceProps.put(Slice.STATE, shardState);
                sliceProps.put(Slice.PARENT, shardParent);
            }
            replicas.put(replica.getName(), replica);
            slice = new Slice(sliceName, replicas, sliceProps);
            ClusterState newClusterState = this.updateSlice(clusterState, collection, slice);
            return newClusterState;
        }

        private ClusterState checkAndCompleteShardSplit(ClusterState state, String collection, String coreNodeName, String sliceName, Map<String, Object> replicaProps) {
            Slice slice = state.getSlice(collection, sliceName);
            Map<String, Object> sliceProps = slice.getProperties();
            String sliceState = slice.getState();
            if (Slice.RECOVERY.equals(sliceState)) {
                log.info("Shard: {} is in recovery state", (Object)sliceName);
                if ("active".equals(replicaProps.get("state"))) {
                    log.info("Shard: {} is in recovery state and coreNodeName: {} is active", (Object)sliceName, (Object)coreNodeName);
                    boolean allActive = true;
                    for (Map.Entry<String, Replica> entry : slice.getReplicasMap().entrySet()) {
                        if (coreNodeName.equals(entry.getKey()) || Slice.ACTIVE.equals(entry.getValue().getStr(Slice.STATE))) continue;
                        allActive = false;
                        break;
                    }
                    if (allActive) {
                        log.info("Shard: {} - all replicas are active. Finding status of fellow sub-shards", (Object)sliceName);
                        HashMap<String, Slice> allSlicesCopy = new HashMap<String, Slice>(state.getSlicesMap(collection));
                        ArrayList<Slice> subShardSlices = new ArrayList<Slice>();
                        block1: for (Map.Entry entry : allSlicesCopy.entrySet()) {
                            Slice otherSlice;
                            if (sliceName.equals(entry.getKey()) || !Slice.RECOVERY.equals((otherSlice = (Slice)entry.getValue()).getState()) || slice.getParent() == null || !slice.getParent().equals(otherSlice.getParent())) continue;
                            log.info("Shard: {} - Fellow sub-shard: {} found", (Object)sliceName, (Object)otherSlice.getName());
                            for (Map.Entry<String, Replica> sliceEntry : otherSlice.getReplicasMap().entrySet()) {
                                if ("active".equals(sliceEntry.getValue().getStr("state"))) continue;
                                allActive = false;
                                break block1;
                            }
                            log.info("Shard: {} - Fellow sub-shard: {} has all replicas active", (Object)sliceName, (Object)otherSlice.getName());
                            subShardSlices.add(otherSlice);
                        }
                        if (allActive) {
                            log.info("Shard: {} - All replicas across all fellow sub-shards are now ACTIVE. Preparing to switch shard states.", (Object)sliceName);
                            String parentSliceName = (String)sliceProps.remove(Slice.PARENT);
                            HashMap<String, Object> propMap = new HashMap<String, Object>();
                            propMap.put(Overseer.QUEUE_OPERATION, "updateshardstate");
                            propMap.put(parentSliceName, Slice.INACTIVE);
                            propMap.put(sliceName, Slice.ACTIVE);
                            for (Slice subShardSlice : subShardSlices) {
                                propMap.put(subShardSlice.getName(), Slice.ACTIVE);
                            }
                            propMap.put("collection", collection);
                            ZkNodeProps m = new ZkNodeProps(propMap);
                            state = this.updateShardState(state, m);
                        }
                    }
                }
            }
            return state;
        }

        private ClusterState createCollection(ClusterState state, String collectionName, List<String> shards, ZkNodeProps message) {
            log.info("Create collection {} with shards {}", (Object)collectionName, (Object)shards);
            Map<String, Object> routerSpec = DocRouter.getRouterSpec(message);
            String routerName = routerSpec.get("name") == null ? "compositeId" : (String)routerSpec.get("name");
            DocRouter router = DocRouter.getDocRouter(routerName);
            List<DocRouter.Range> ranges = router.partitionRange(shards.size(), router.fullRange());
            LinkedHashMap<String, Slice> newSlices = new LinkedHashMap<String, Slice>();
            for (int i = 0; i < shards.size(); ++i) {
                String sliceName = shards.get(i);
                LinkedHashMap<String, Object> sliceProps = new LinkedHashMap<String, Object>(1);
                sliceProps.put(Slice.RANGE, ranges == null ? null : ranges.get(i));
                newSlices.put(sliceName, new Slice(sliceName, null, sliceProps));
            }
            HashMap<String, Object> collectionProps = new HashMap<String, Object>();
            for (Map.Entry<String, Object> e : OverseerCollectionProcessor.COLL_PROPS.entrySet()) {
                Object val = message.get(e.getKey());
                if (val == null) {
                    val = OverseerCollectionProcessor.COLL_PROPS.get(e.getKey());
                }
                if (val == null) continue;
                collectionProps.put(e.getKey(), val);
            }
            collectionProps.put("router", routerSpec);
            if (message.getStr("fromApi") == null) {
                collectionProps.put("autoCreated", "true");
            }
            DocCollection newCollection = new DocCollection(collectionName, newSlices, collectionProps, router);
            return state.copyWith(Collections.singletonMap(newCollection.getName(), newCollection));
        }

        private String getAssignedId(ClusterState state, String nodeName, ZkNodeProps coreState) {
            Collection<Slice> slices = state.getSlices(coreState.getStr("collection"));
            if (slices != null) {
                for (Slice slice : slices) {
                    if (slice.getReplicasMap().get(nodeName) == null) continue;
                    return slice.getName();
                }
            }
            return null;
        }

        private String getAssignedCoreNodeName(ClusterState state, ZkNodeProps message) {
            Collection<Slice> slices = state.getSlices(message.getStr("collection"));
            if (slices != null) {
                for (Slice slice : slices) {
                    for (Replica replica : slice.getReplicas()) {
                        String nodeName = replica.getStr("node_name");
                        String core = replica.getStr("core");
                        String msgNodeName = message.getStr("node_name");
                        String msgCore = message.getStr("core");
                        if (!nodeName.equals(msgNodeName) || !core.equals(msgCore)) continue;
                        return replica.getName();
                    }
                }
            }
            return null;
        }

        private ClusterState updateSlice(ClusterState state, String collectionName, Slice slice) {
            DocRouter router;
            Map<String, Object> props;
            HashMap<String, Slice> slices;
            LinkedHashMap<String, DocCollection> newCollections = new LinkedHashMap<String, DocCollection>(state.getCollectionStates());
            DocCollection coll = (DocCollection)newCollections.get(collectionName);
            if (coll == null) {
                slices = new HashMap<String, Slice>(1);
                props = new HashMap<String, Object>(1);
                props.put("router", ZkNodeProps.makeMap("name", "implicit"));
                router = new ImplicitDocRouter();
            } else {
                props = coll.getProperties();
                router = coll.getRouter();
                slices = new LinkedHashMap<String, Slice>(coll.getSlicesMap());
            }
            slices.put(slice.getName(), slice);
            DocCollection newCollection = new DocCollection(collectionName, slices, props, router);
            newCollections.put(collectionName, newCollection);
            return new ClusterState(state.getLiveNodes(), newCollections);
        }

        private ClusterState setShardLeader(ClusterState state, String collectionName, String sliceName, String leaderUrl) {
            LinkedHashMap<String, DocCollection> newCollections = new LinkedHashMap<String, DocCollection>(state.getCollectionStates());
            DocCollection coll = (DocCollection)newCollections.get(collectionName);
            if (coll == null) {
                log.error("Could not mark shard leader for non existing collection:" + collectionName);
                return state;
            }
            Map<String, Slice> slices = coll.getSlicesMap();
            Slice slice = (slices = new LinkedHashMap<String, Slice>(slices)).get(sliceName);
            if (slice == null) {
                slice = coll.getSlice(sliceName);
            }
            if (slice == null) {
                log.error("Could not mark leader for non existing/active slice:" + sliceName);
                return state;
            }
            Replica oldLeader = slice.getLeader();
            LinkedHashMap<String, Replica> newReplicas = new LinkedHashMap<String, Replica>();
            for (Replica replica : slice.getReplicas()) {
                LinkedHashMap<String, Object> replicaProps;
                String coreURL = ZkCoreNodeProps.getCoreUrl(replica.getStr("base_url"), replica.getStr("core"));
                if (replica == oldLeader && !coreURL.equals(leaderUrl)) {
                    replicaProps = new LinkedHashMap<String, Object>(replica.getProperties());
                    replicaProps.remove(Slice.LEADER);
                    replica = new Replica(replica.getName(), replicaProps);
                } else if (coreURL.equals(leaderUrl)) {
                    replicaProps = new LinkedHashMap<String, Object>(replica.getProperties());
                    replicaProps.put(Slice.LEADER, "true");
                    replica = new Replica(replica.getName(), replicaProps);
                }
                newReplicas.put(replica.getName(), replica);
            }
            Map<String, Object> newSliceProps = slice.shallowCopy();
            newSliceProps.put(Slice.REPLICAS, newReplicas);
            Slice newSlice = new Slice(slice.getName(), newReplicas, slice.getProperties());
            slices.put(newSlice.getName(), newSlice);
            DocCollection newCollection = new DocCollection(coll.getName(), slices, coll.getProperties(), coll.getRouter());
            newCollections.put(collectionName, newCollection);
            return new ClusterState(state.getLiveNodes(), newCollections);
        }

        private ClusterState newState(ClusterState state, Map<String, DocCollection> colls) {
            return state.copyWith(colls);
        }

        private ClusterState removeCollection(ClusterState clusterState, ZkNodeProps message) {
            String collection = message.getStr("name");
            if (!this.checkKeyExistence(message, "name")) {
                return clusterState;
            }
            return clusterState.copyWith(Collections.singletonMap(collection, null));
        }

        private ClusterState removeShard(ClusterState clusterState, ZkNodeProps message) {
            String sliceId = message.getStr("shard");
            String collection = message.getStr("collection");
            if (!this.checkCollectionKeyExistence(message)) {
                return clusterState;
            }
            log.info("Removing collection: " + collection + " shard: " + sliceId + " from clusterstate");
            DocCollection coll = clusterState.getCollection(collection);
            LinkedHashMap<String, Slice> newSlices = new LinkedHashMap<String, Slice>(coll.getSlicesMap());
            newSlices.remove(sliceId);
            DocCollection newCollection = new DocCollection(coll.getName(), newSlices, coll.getProperties(), coll.getRouter());
            return this.newState(clusterState, Collections.singletonMap(collection, newCollection));
        }

        private ClusterState removeCore(ClusterState clusterState, ZkNodeProps message) {
            String cnn = message.getStr("core_node_name");
            String collection = message.getStr("collection");
            if (!this.checkCollectionKeyExistence(message)) {
                return clusterState;
            }
            DocCollection coll = clusterState.getCollectionOrNull(collection);
            if (coll == null) {
                try {
                    this.zkClient.clean("/collections/" + collection);
                }
                catch (InterruptedException e) {
                    SolrException.log(log, "Cleaning up collection in zk was interrupted:" + collection, e);
                    Thread.currentThread().interrupt();
                }
                catch (KeeperException e) {
                    SolrException.log(log, "Problem cleaning up collection in zk:" + collection, e);
                }
                return clusterState;
            }
            LinkedHashMap<String, Slice> newSlices = new LinkedHashMap<String, Slice>();
            boolean lastSlice = false;
            for (Slice slice : coll.getSlices()) {
                Replica replica = slice.getReplica(cnn);
                if (replica != null) {
                    Map<String, Replica> newReplicas = slice.getReplicasCopy();
                    newReplicas.remove(cnn);
                    if (newReplicas.size() == 0) {
                        slice = null;
                        lastSlice = true;
                    } else {
                        slice = new Slice(slice.getName(), newReplicas, slice.getProperties());
                    }
                }
                if (slice == null) continue;
                newSlices.put(slice.getName(), slice);
            }
            if (lastSlice) {
                for (Slice slice : coll.getSlices()) {
                    if (slice.getReplicas().size() != 0) continue;
                    newSlices.remove(slice.getName());
                }
            }
            if (newSlices.size() == 0) {
                try {
                    this.zkClient.clean("/collections/" + collection);
                }
                catch (InterruptedException e) {
                    SolrException.log(log, "Cleaning up collection in zk was interrupted:" + collection, e);
                    Thread.currentThread().interrupt();
                }
                catch (KeeperException e) {
                    SolrException.log(log, "Problem cleaning up collection in zk:" + collection, e);
                }
                return this.newState(clusterState, Collections.singletonMap(collection, null));
            }
            DocCollection newCollection = new DocCollection(coll.getName(), newSlices, coll.getProperties(), coll.getRouter());
            return this.newState(clusterState, Collections.singletonMap(collection, newCollection));
        }

        @Override
        public void close() {
            this.isClosed = true;
        }

        @Override
        public boolean isClosed() {
            return this.isClosed;
        }
    }

    static enum LeaderStatus {
        DONT_KNOW,
        NO,
        YES;

    }
}

