/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.ConfigSolr;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SolrCores {
    private static Object modifyLock = new Object();
    private final Map<String, SolrCore> cores = new LinkedHashMap<String, SolrCore>();
    private Map<String, SolrCore> transientCores = new LinkedHashMap<String, SolrCore>();
    private final Map<String, CoreDescriptor> dynamicDescriptors = new LinkedHashMap<String, CoreDescriptor>();
    private final Map<String, SolrCore> createdCores = new LinkedHashMap<String, SolrCore>();
    private Map<SolrCore, String> coreToOrigName = new ConcurrentHashMap<SolrCore, String>();
    private final CoreContainer container;
    private static final Logger logger = LoggerFactory.getLogger(SolrCores.class);
    private static final Set<String> pendingCoreOps = new HashSet<String>();
    private static final List<SolrCore> pendingCloses = new ArrayList<SolrCore>();

    SolrCores(CoreContainer container) {
        this.container = container;
    }

    protected void allocateLazyCores(final int cacheSize, SolrResourceLoader loader) {
        if (cacheSize != Integer.MAX_VALUE) {
            CoreContainer.log.info("Allocating transient cache for {} transient cores", (Object)cacheSize);
            this.transientCores = new LinkedHashMap<String, SolrCore>(cacheSize, 0.75f, true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected boolean removeEldestEntry(Map.Entry<String, SolrCore> eldest) {
                    if (this.size() > cacheSize) {
                        Object object = modifyLock;
                        synchronized (object) {
                            SolrCore coreToClose = eldest.getValue();
                            logger.info("Closing transient core [{}]", (Object)coreToClose.getName());
                            pendingCloses.add(coreToClose);
                            modifyLock.notifyAll();
                        }
                        return true;
                    }
                    return false;
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putDynamicDescriptor(String rawName, CoreDescriptor p) {
        Object object = modifyLock;
        synchronized (object) {
            this.dynamicDescriptors.put(rawName, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        ArrayList<SolrCore> coreList = new ArrayList<SolrCore>();
        do {
            coreList.clear();
            Object object = modifyLock;
            synchronized (object) {
                coreList.addAll(this.cores.values());
                this.cores.clear();
                coreList.addAll(this.transientCores.values());
                this.transientCores.clear();
                coreList.addAll(pendingCloses);
                pendingCloses.clear();
            }
            for (SolrCore core : coreList) {
                try {
                    core.close();
                }
                catch (Throwable e) {
                    SolrException.log(CoreContainer.log, "Error shutting down core", e);
                    if (!(e instanceof Error)) continue;
                    throw (Error)e;
                }
            }
        } while (coreList.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore putTransientCore(ConfigSolr cfg, String name, SolrCore core, SolrResourceLoader loader) {
        SolrCore retCore;
        CoreContainer.log.info("Opening transient core {}", (Object)name);
        Object object = modifyLock;
        synchronized (object) {
            retCore = this.transientCores.put(name, core);
        }
        return retCore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore putCore(String name, SolrCore core) {
        Object object = modifyLock;
        synchronized (object) {
            return this.cores.put(name, core);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SolrCore> getCores() {
        ArrayList<SolrCore> lst = new ArrayList<SolrCore>();
        Object object = modifyLock;
        synchronized (object) {
            lst.addAll(this.cores.values());
            return lst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getCoreNames() {
        TreeSet<String> set = new TreeSet<String>();
        Object object = modifyLock;
        synchronized (object) {
            set.addAll(this.cores.keySet());
            set.addAll(this.transientCores.keySet());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getCoreNames(SolrCore core) {
        ArrayList<String> lst = new ArrayList<String>();
        Object object = modifyLock;
        synchronized (object) {
            for (Map.Entry<String, SolrCore> entry : this.cores.entrySet()) {
                if (core != entry.getValue()) continue;
                lst.add(entry.getKey());
            }
            for (Map.Entry<String, SolrCore> entry : this.transientCores.entrySet()) {
                if (core != entry.getValue()) continue;
                lst.add(entry.getKey());
            }
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getAllCoreNames() {
        TreeSet<String> set = new TreeSet<String>();
        Object object = modifyLock;
        synchronized (object) {
            set.addAll(this.cores.keySet());
            set.addAll(this.transientCores.keySet());
            set.addAll(this.dynamicDescriptors.keySet());
            set.addAll(this.createdCores.keySet());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SolrCore getCore(String name) {
        Object object = modifyLock;
        synchronized (object) {
            return this.cores.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void swap(String n0, String n1) {
        Object object = modifyLock;
        synchronized (object) {
            SolrCore c0 = this.cores.get(n0);
            SolrCore c1 = this.cores.get(n1);
            if (c0 == null && (c0 = this.container.getCore(n0)) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + n0);
            }
            if (c1 == null && (c1 = this.container.getCore(n1)) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + n1);
            }
            this.cores.put(n0, c1);
            this.cores.put(n1, c0);
            c0.setName(n1);
            c1.setName(n0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore remove(String name, boolean removeOrig) {
        Object object = modifyLock;
        synchronized (object) {
            SolrCore tmp = this.cores.remove(name);
            SolrCore ret = null;
            if (removeOrig && tmp != null) {
                this.coreToOrigName.remove(tmp);
            }
            ret = ret == null ? tmp : ret;
            tmp = this.transientCores.remove(name);
            ret = ret == null ? tmp : ret;
            tmp = this.createdCores.remove(name);
            ret = ret == null ? tmp : ret;
            this.dynamicDescriptors.remove(name);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putCoreToOrigName(SolrCore c, String name) {
        Object object = modifyLock;
        synchronized (object) {
            this.coreToOrigName.put(c, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCoreToOrigName(SolrCore newCore, SolrCore core) {
        Object object = modifyLock;
        synchronized (object) {
            String origName = this.coreToOrigName.remove(core);
            if (origName != null) {
                this.coreToOrigName.put(newCore, origName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore getCoreFromAnyList(String name, boolean incRefCount) {
        Object object = modifyLock;
        synchronized (object) {
            SolrCore core = this.cores.get(name);
            if (core == null) {
                core = this.transientCores.get(name);
            }
            if (core != null && incRefCount) {
                core.open();
            }
            return core;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoreDescriptor getDynamicDescriptor(String name) {
        Object object = modifyLock;
        synchronized (object) {
            return this.dynamicDescriptors.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLoadedNotPendingClose(String name) {
        Object object = modifyLock;
        synchronized (object) {
            if (this.cores.containsKey(name)) {
                return true;
            }
            if (this.transientCores.containsKey(name)) {
                for (SolrCore core : pendingCloses) {
                    if (!core.getName().equals(name)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLoaded(String name) {
        Object object = modifyLock;
        synchronized (object) {
            if (this.cores.containsKey(name)) {
                return true;
            }
            if (this.transientCores.containsKey(name)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoreDescriptor getUnloadedCoreDescriptor(String cname) {
        Object object = modifyLock;
        synchronized (object) {
            CoreDescriptor desc = this.dynamicDescriptors.get(cname);
            if (desc == null) {
                return null;
            }
            return new CoreDescriptor(cname, desc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCoreToOrigName(SolrCore solrCore) {
        Object object = modifyLock;
        synchronized (object) {
            return this.coreToOrigName.get(solrCore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore waitAddPendingCoreOps(String name) {
        Object object = modifyLock;
        synchronized (object) {
            boolean pending;
            do {
                if (!(pending = pendingCoreOps.contains(name))) {
                    for (SolrCore core : pendingCloses) {
                        if (!core.getName().equals(name)) continue;
                        pending = true;
                        break;
                    }
                }
                if (this.container.isShutDown()) {
                    return null;
                }
                if (!pending) continue;
                try {
                    modifyLock.wait();
                }
                catch (InterruptedException e) {
                    return null;
                }
            } while (pending);
            if (!this.container.isShutDown()) {
                if (!pendingCoreOps.add(name)) {
                    CoreContainer.log.warn("Replaced an entry in pendingCoreOps {}, we should not be doing this", (Object)name);
                }
                return this.getCoreFromAnyList(name, false);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromPendingOps(String name) {
        Object object = modifyLock;
        synchronized (object) {
            if (!pendingCoreOps.remove(name)) {
                CoreContainer.log.warn("Tried to remove core {} from pendingCoreOps and it wasn't there. ", (Object)name);
            }
            modifyLock.notifyAll();
        }
    }

    protected Object getModifyLock() {
        return modifyLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore getCoreToClose() {
        Object object = modifyLock;
        synchronized (object) {
            for (SolrCore core : pendingCloses) {
                if (pendingCoreOps.contains(core.getName())) continue;
                pendingCoreOps.add(core.getName());
                pendingCloses.remove(core);
                return core;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCreated(SolrCore core) {
        Object object = modifyLock;
        synchronized (object) {
            this.createdCores.put(core.getName(), core);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreDescriptor getCoreDescriptor(String coreName) {
        Object object = modifyLock;
        synchronized (object) {
            if (this.cores.containsKey(coreName)) {
                return this.cores.get(coreName).getCoreDescriptor();
            }
            if (this.dynamicDescriptors.containsKey(coreName)) {
                return this.dynamicDescriptors.get(coreName);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CoreDescriptor> getCoreDescriptors() {
        ArrayList<CoreDescriptor> cds = Lists.newArrayList();
        Object object = modifyLock;
        synchronized (object) {
            for (String coreName : this.getAllCoreNames()) {
                CoreDescriptor cd = this.getCoreDescriptor(coreName);
                if (cd == null) continue;
                cds.add(cd);
            }
        }
        return cds;
    }
}

