/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.loader;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.handler.loader.ContentStreamLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.noggit.JSONParser;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLoader
extends ContentStreamLoader {
    static final Logger log = LoggerFactory.getLogger(JsonLoader.class);

    @Override
    public String getDefaultWT() {
        return "json";
    }

    @Override
    public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream, UpdateRequestProcessor processor) throws Exception {
        new SingleThreadedJsonLoader(req, processor).load(req, rsp, stream, processor);
    }

    static class SingleThreadedJsonLoader
    extends ContentStreamLoader {
        protected final UpdateRequestProcessor processor;
        protected final SolrQueryRequest req;
        protected JSONParser parser;
        protected final int commitWithin;
        protected final boolean overwrite;

        public SingleThreadedJsonLoader(SolrQueryRequest req, UpdateRequestProcessor processor) {
            this.processor = processor;
            this.req = req;
            this.commitWithin = req.getParams().getInt("commitWithin", -1);
            this.overwrite = req.getParams().getBool("overwrite", true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream, UpdateRequestProcessor processor) throws Exception {
            Reader reader = null;
            try {
                reader = stream.getReader();
                if (log.isTraceEnabled()) {
                    String body = IOUtils.toString(reader);
                    log.trace("body", (Object)body);
                    reader = new StringReader(body);
                }
                this.parser = new JSONParser(reader);
                this.processUpdate();
            }
            finally {
                IOUtils.closeQuietly(reader);
            }
        }

        void processUpdate() throws IOException {
            int ev = this.parser.nextEvent();
            while (ev != 11) {
                switch (ev) {
                    case 9: {
                        this.handleAdds();
                        break;
                    }
                    case 1: {
                        if (this.parser.wasKey()) {
                            String v = this.parser.getString();
                            if (v.equals("add")) {
                                int ev2 = this.parser.nextEvent();
                                if (ev2 == 7) {
                                    this.processor.processAdd(this.parseAdd());
                                    break;
                                }
                                if (ev2 == 9) {
                                    this.handleAdds();
                                    break;
                                }
                                this.assertEvent(ev2, 7);
                                break;
                            }
                            if (v.equals("commit")) {
                                CommitUpdateCommand cmd = new CommitUpdateCommand(this.req, false);
                                cmd.waitSearcher = true;
                                this.parseCommitOptions(cmd);
                                this.processor.processCommit(cmd);
                                break;
                            }
                            if (v.equals("optimize")) {
                                CommitUpdateCommand cmd = new CommitUpdateCommand(this.req, true);
                                cmd.waitSearcher = true;
                                this.parseCommitOptions(cmd);
                                this.processor.processCommit(cmd);
                                break;
                            }
                            if (v.equals("delete")) {
                                this.handleDeleteCommand();
                                break;
                            }
                            if (v.equals("rollback")) {
                                this.processor.processRollback(this.parseRollback());
                                break;
                            }
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown command: " + v + " [" + this.parser.getPosition() + "]");
                        }
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        log.info("can't have a value here! " + JSONParser.getEventString(ev) + " " + this.parser.getPosition());
                    }
                    case 7: 
                    case 8: 
                    case 10: {
                        break;
                    }
                    default: {
                        log.info("Noggit UNKNOWN_EVENT_ID:" + ev);
                    }
                }
                ev = this.parser.nextEvent();
            }
        }

        void handleDeleteCommand() throws IOException {
            int ev = this.parser.nextEvent();
            switch (ev) {
                case 9: {
                    this.handleDeleteArray(ev);
                    break;
                }
                case 7: {
                    this.handleDeleteMap(ev);
                    break;
                }
                default: {
                    this.handleSingleDelete(ev);
                }
            }
        }

        String getString(int ev) throws IOException {
            switch (ev) {
                case 1: {
                    return this.parser.getString();
                }
                case 2: 
                case 3: 
                case 4: {
                    return this.parser.getNumberChars().toString();
                }
                case 5: {
                    return Boolean.toString(this.parser.getBoolean());
                }
                case 6: {
                    return null;
                }
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expected primitive JSON value but got: " + JSONParser.getEventString(ev) + " at [" + this.parser.getPosition() + "]");
        }

        void handleSingleDelete(int ev) throws IOException {
            if (ev == 7) {
                this.handleDeleteMap(ev);
            } else {
                DeleteUpdateCommand cmd = new DeleteUpdateCommand(this.req);
                cmd.commitWithin = this.commitWithin;
                String id = this.getString(ev);
                cmd.setId(id);
                this.processor.processDelete(cmd);
            }
        }

        void handleDeleteArray(int ev) throws IOException {
            assert (ev == 9);
            while ((ev = this.parser.nextEvent()) != 10) {
                this.handleSingleDelete(ev);
            }
            return;
        }

        void handleDeleteMap(int ev) throws IOException {
            assert (ev == 7);
            DeleteUpdateCommand cmd = new DeleteUpdateCommand(this.req);
            cmd.commitWithin = this.commitWithin;
            while ((ev = this.parser.nextEvent()) == 1) {
                String key = this.parser.getString();
                if (this.parser.wasKey()) {
                    if ("id".equals(key)) {
                        cmd.setId(this.getString(this.parser.nextEvent()));
                        continue;
                    }
                    if ("query".equals(key)) {
                        cmd.setQuery(this.parser.getString());
                        continue;
                    }
                    if ("commitWithin".equals(key)) {
                        cmd.commitWithin = (int)this.parser.getLong();
                        continue;
                    }
                    if ("_version_".equals(key)) {
                        cmd.setVersion(this.parser.getLong());
                        continue;
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown key: " + key + " [" + this.parser.getPosition() + "]");
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "invalid string: " + key + " at [" + this.parser.getPosition() + "]");
            }
            if (ev == 8) {
                if (cmd.getId() == null && cmd.getQuery() == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing id or query for delete [" + this.parser.getPosition() + "]");
                }
                this.processor.processDelete(cmd);
                return;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Got: " + JSONParser.getEventString(ev) + " at [" + this.parser.getPosition() + "]");
        }

        RollbackUpdateCommand parseRollback() throws IOException {
            this.assertNextEvent(7);
            this.assertNextEvent(8);
            return new RollbackUpdateCommand(this.req);
        }

        void parseCommitOptions(CommitUpdateCommand cmd) throws IOException {
            this.assertNextEvent(7);
            final Map map = (Map)ObjectBuilder.getVal(this.parser);
            SolrParams p = new SolrParams(){

                @Override
                public String get(String param) {
                    Object o = map.get(param);
                    return o == null ? null : o.toString();
                }

                @Override
                public String[] getParams(String param) {
                    return new String[]{this.get(param)};
                }

                @Override
                public Iterator<String> getParameterNamesIterator() {
                    return map.keySet().iterator();
                }
            };
            RequestHandlerUtils.validateCommitParams(p);
            p = SolrParams.wrapDefaults(p, this.req.getParams());
            RequestHandlerUtils.updateCommit(cmd, p);
        }

        AddUpdateCommand parseAdd() throws IOException {
            int ev;
            AddUpdateCommand cmd = new AddUpdateCommand(this.req);
            cmd.commitWithin = this.commitWithin;
            cmd.overwrite = this.overwrite;
            float boost = 1.0f;
            while ((ev = this.parser.nextEvent()) == 1) {
                if (this.parser.wasKey()) {
                    String key = this.parser.getString();
                    if ("doc".equals(key)) {
                        if (cmd.solrDoc != null) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "multiple docs in same add command");
                        }
                        ev = this.assertNextEvent(7);
                        cmd.solrDoc = this.parseDoc(ev);
                        continue;
                    }
                    if ("overwrite".equals(key)) {
                        cmd.overwrite = this.parser.getBoolean();
                        continue;
                    }
                    if ("commitWithin".equals(key)) {
                        cmd.commitWithin = (int)this.parser.getLong();
                        continue;
                    }
                    if ("boost".equals(key)) {
                        boost = Float.parseFloat(this.parser.getNumberChars().toString());
                        continue;
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown key: " + key + " [" + this.parser.getPosition() + "]");
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Should be a key  at [" + this.parser.getPosition() + "]");
            }
            if (ev == 8) {
                if (cmd.solrDoc == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing solr document. " + this.parser.getPosition());
                }
                cmd.solrDoc.setDocumentBoost(boost);
                return cmd;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Got: " + JSONParser.getEventString(ev) + " at [" + this.parser.getPosition() + "]");
        }

        void handleAdds() throws IOException {
            while (true) {
                AddUpdateCommand cmd = new AddUpdateCommand(this.req);
                cmd.commitWithin = this.commitWithin;
                cmd.overwrite = this.overwrite;
                int ev = this.parser.nextEvent();
                if (ev == 10) break;
                this.assertEvent(ev, 7);
                cmd.solrDoc = this.parseDoc(ev);
                this.processor.processAdd(cmd);
            }
        }

        int assertNextEvent(int expected) throws IOException {
            int got = this.parser.nextEvent();
            this.assertEvent(got, expected);
            return got;
        }

        void assertEvent(int ev, int expected) {
            if (ev != expected) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expected: " + JSONParser.getEventString(expected) + " but got " + JSONParser.getEventString(ev) + " at [" + this.parser.getPosition() + "]");
            }
        }

        private SolrInputDocument parseDoc(int ev) throws IOException {
            assert (ev == 7);
            SolrInputDocument sdoc = new SolrInputDocument();
            SolrInputField sif;
            while ((sif = this.parseField()) != null) {
                sdoc.addField(sif.getName(), sif.getValue(), sif.getBoost());
            }
            return sdoc;
        }

        private SolrInputField parseField() throws IOException {
            int ev = this.parser.nextEvent();
            if (ev == 8) {
                return null;
            }
            String fieldName = this.parser.getString();
            SolrInputField sif = new SolrInputField(fieldName);
            this.parseFieldValue(sif);
            return sif;
        }

        private void parseFieldValue(SolrInputField sif) throws IOException {
            int ev = this.parser.nextEvent();
            if (ev == 7) {
                this.parseExtendedFieldValue(sif, ev);
            } else {
                Object val = this.parseNormalFieldValue(ev);
                sif.setValue(val, 1.0f);
            }
        }

        private void parseExtendedFieldValue(SolrInputField sif, int ev) throws IOException {
            assert (ev == 7);
            float boost = 1.0f;
            Object normalFieldValue = null;
            HashMap<String, Object> extendedInfo = null;
            block4: while (true) {
                ev = this.parser.nextEvent();
                switch (ev) {
                    case 1: {
                        String label = this.parser.getString();
                        if ("boost".equals(label)) {
                            ev = this.parser.nextEvent();
                            if (ev != 3 && ev != 2 && ev != 4) {
                                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "boost should have number! " + JSONParser.getEventString(ev));
                            }
                            boost = (float)this.parser.getDouble();
                            continue block4;
                        }
                        if ("value".equals(label)) {
                            normalFieldValue = this.parseNormalFieldValue(this.parser.nextEvent());
                            continue block4;
                        }
                        if (extendedInfo == null) {
                            extendedInfo = new HashMap<String, Object>(2);
                        }
                        Object val = this.parseNormalFieldValue(this.parser.nextEvent());
                        extendedInfo.put(label, val);
                        continue block4;
                    }
                    case 8: {
                        if (extendedInfo != null) {
                            if (normalFieldValue != null) {
                                extendedInfo.put("value", normalFieldValue);
                            }
                            sif.setValue(extendedInfo, boost);
                        } else {
                            sif.setValue(normalFieldValue, boost);
                        }
                        return;
                    }
                }
                break;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error parsing JSON extended field value. Unexpected " + JSONParser.getEventString(ev));
        }

        private Object parseNormalFieldValue(int ev) throws IOException {
            if (ev == 9) {
                List<Object> val = this.parseArrayFieldValue(ev);
                return val;
            }
            Object val = this.parseSingleFieldValue(ev);
            return val;
        }

        private Object parseSingleFieldValue(int ev) throws IOException {
            switch (ev) {
                case 1: {
                    return this.parser.getString();
                }
                case 2: {
                    return this.parser.getLong();
                }
                case 3: {
                    return this.parser.getDouble();
                }
                case 4: {
                    return this.parser.getNumberChars().toString();
                }
                case 5: {
                    return this.parser.getBoolean();
                }
                case 6: {
                    this.parser.getNull();
                    return null;
                }
                case 9: {
                    return this.parseArrayFieldValue(ev);
                }
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error parsing JSON field value. Unexpected " + JSONParser.getEventString(ev));
        }

        private List<Object> parseArrayFieldValue(int ev) throws IOException {
            assert (ev == 9);
            ArrayList<Object> lst = new ArrayList<Object>(2);
            while ((ev = this.parser.nextEvent()) != 10) {
                Object val = this.parseSingleFieldValue(ev);
                lst.add(val);
            }
            return lst;
        }
    }
}

