/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DocTermOrds;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.FieldFacetStats;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.handler.component.StatsValuesFactory;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.LongPriorityQueue;
import org.apache.solr.util.PrimUtils;

public class UnInvertedField
extends DocTermOrds {
    private static int TNUM_OFFSET = 2;
    long memsz;
    final AtomicLong use = new AtomicLong();
    int[] maxTermCounts = new int[1024];
    final Map<Integer, TopTerm> bigTerms = new LinkedHashMap<Integer, TopTerm>();
    private SolrIndexSearcher.DocsEnumState deState;
    private final SolrIndexSearcher searcher;
    private final boolean isPlaceholder;
    private static UnInvertedField uifPlaceholder = new UnInvertedField();

    private UnInvertedField() {
        super("fake", 0, 0);
        this.isPlaceholder = true;
        this.searcher = null;
    }

    @Override
    protected void visitTerm(TermsEnum te, int termNum) throws IOException {
        if (termNum >= this.maxTermCounts.length) {
            int[] newMaxTermCounts = new int[this.maxTermCounts.length * 2];
            System.arraycopy(this.maxTermCounts, 0, newMaxTermCounts, 0, termNum);
            this.maxTermCounts = newMaxTermCounts;
        }
        BytesRef term = te.term();
        if (te.docFreq() > this.maxTermDocFreq) {
            TopTerm topTerm = new TopTerm();
            topTerm.term = BytesRef.deepCopyOf(term);
            topTerm.termNum = termNum;
            this.bigTerms.put(topTerm.termNum, topTerm);
            if (this.deState == null) {
                this.deState = new SolrIndexSearcher.DocsEnumState();
                this.deState.fieldName = this.field;
                this.deState.liveDocs = this.searcher.getAtomicReader().getLiveDocs();
                this.deState.termsEnum = te;
                this.deState.docsEnum = this.docsEnum;
                this.deState.minSetSizeCached = this.maxTermDocFreq;
            }
            this.docsEnum = this.deState.docsEnum;
            DocSet set = this.searcher.getDocSet(this.deState);
            this.maxTermCounts[termNum] = set.size();
        }
    }

    @Override
    protected void setActualDocFreq(int termNum, int docFreq) {
        this.maxTermCounts[termNum] = docFreq;
    }

    public long memSize() {
        if (this.memsz != 0L) {
            return this.memsz;
        }
        long sz = super.ramUsedInBytes();
        sz += 96L;
        sz += (long)(this.bigTerms.size() * 64);
        for (TopTerm tt : this.bigTerms.values()) {
            sz += tt.memSize();
        }
        if (this.maxTermCounts != null) {
            sz += (long)(this.maxTermCounts.length * 4);
        }
        if (this.indexedTermsArray != null) {
            sz += (long)(32 + (this.indexedTermsArray.length << 3)) + this.sizeOfIndexedStrings;
        }
        this.memsz = sz;
        return sz;
    }

    public UnInvertedField(String field, SolrIndexSearcher searcher) throws IOException {
        super(field, searcher.maxDoc() / 20 + 2, 7);
        this.isPlaceholder = false;
        String prefix = TrieField.getMainValuePrefix(searcher.getSchema().getFieldType(field));
        this.searcher = searcher;
        try {
            AtomicReader r = searcher.getAtomicReader();
            this.uninvert(r, r.getLiveDocs(), prefix == null ? null : new BytesRef(prefix));
        }
        catch (IllegalStateException ise) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ise.getMessage());
        }
        if (this.tnums != null) {
            for (byte[] target : this.tnums) {
                if (target == null || !((double)target.length > 1.50994944E7)) continue;
                SolrCore.log.warn("Approaching too many values for UnInvertedField faceting on field '" + field + "' : bucket size=" + target.length);
            }
        }
        if (this.maxTermCounts.length - this.numTermsInField > 1024) {
            int[] newMaxTermCounts = new int[this.numTermsInField];
            System.arraycopy(this.maxTermCounts, 0, newMaxTermCounts, 0, this.numTermsInField);
            this.maxTermCounts = newMaxTermCounts;
        }
        SolrCore.log.info("UnInverted multi-valued field " + this.toString());
    }

    public int getNumTerms() {
        return this.numTermsInField;
    }

    public NamedList<Integer> getCounts(SolrIndexSearcher searcher, DocSet baseDocs, int offset, int limit, Integer mincount, boolean missing, String sort, String prefix) throws IOException {
        this.use.incrementAndGet();
        FieldType ft = searcher.getSchema().getFieldType(this.field);
        NamedList<Integer> res = new NamedList<Integer>();
        DocSet docs = baseDocs;
        int baseSize = docs.size();
        int maxDoc = searcher.maxDoc();
        if (baseSize >= mincount) {
            int lim;
            boolean doNegative;
            int[] index = this.index;
            int[] counts = new int[this.numTermsInField + 1];
            int startTerm = 0;
            int endTerm = this.numTermsInField;
            TermsEnum te = this.getOrdTermsEnum(searcher.getAtomicReader());
            if (te != null && prefix != null && prefix.length() > 0) {
                BytesRef prefixBr = new BytesRef(prefix);
                startTerm = te.seekCeil(prefixBr) == TermsEnum.SeekStatus.END ? this.numTermsInField : (int)te.ord();
                prefixBr.append(UnicodeUtil.BIG_TERM);
                endTerm = te.seekCeil(prefixBr) == TermsEnum.SeekStatus.END ? this.numTermsInField : (int)te.ord();
            }
            boolean bl = doNegative = baseSize > maxDoc >> 1 && this.termInstances > 0L && startTerm == 0 && endTerm == this.numTermsInField && docs instanceof BitDocSet;
            if (doNegative) {
                FixedBitSet bs = ((BitDocSet)docs).getBits().clone();
                bs.flip(0, maxDoc);
                docs = new BitDocSet(bs, maxDoc - baseSize);
            }
            for (TopTerm tt : this.bigTerms.values()) {
                if (tt.termNum < startTerm || tt.termNum >= endTerm) continue;
                counts[tt.termNum] = searcher.numDocs((Query)new TermQuery(new Term(this.field, tt.term)), docs);
            }
            if (this.termInstances > 0L) {
                DocIterator iter = docs.iterator();
                block1: while (iter.hasNext()) {
                    int doc = iter.nextDoc();
                    int code = index[doc];
                    if ((code & 0xFF) == 1) {
                        int pos = code >>> 8;
                        int whichArray = doc >>> 16 & 0xFF;
                        byte[] arr = this.tnums[whichArray];
                        int tnum = 0;
                        while (true) {
                            byte b;
                            int delta = 0;
                            do {
                                b = arr[pos++];
                                delta = delta << 7 | b & 0x7F;
                            } while ((b & 0x80) != 0);
                            if (delta == 0) continue block1;
                            int n = tnum += delta - TNUM_OFFSET;
                            counts[n] = counts[n] + 1;
                        }
                    }
                    int tnum = 0;
                    int delta = 0;
                    while (true) {
                        delta = delta << 7 | code & 0x7F;
                        if ((code & 0x80) == 0) {
                            if (delta == 0) continue block1;
                            int n = tnum += delta - TNUM_OFFSET;
                            counts[n] = counts[n] + 1;
                            delta = 0;
                        }
                        code >>>= 8;
                    }
                }
            }
            CharsRef charsRef = new CharsRef();
            int off = offset;
            int n = lim = limit >= 0 ? limit : Integer.MAX_VALUE;
            if (sort.equals("count") || sort.equals("true")) {
                int i;
                int maxsize = limit > 0 ? offset + limit : 0x7FFFFFFE;
                maxsize = Math.min(maxsize, this.numTermsInField);
                LongPriorityQueue queue = new LongPriorityQueue(Math.min(maxsize, 1000), maxsize, Long.MIN_VALUE);
                int min = mincount - 1;
                for (int i2 = startTerm; i2 < endTerm; ++i2) {
                    long pair;
                    boolean displaced;
                    int c;
                    int n2 = c = doNegative ? this.maxTermCounts[i2] - counts[i2] : counts[i2];
                    if (c <= min || !(displaced = queue.insert(pair = ((long)c << 32) + (long)(Integer.MAX_VALUE - i2)))) continue;
                    min = (int)(queue.top() >>> 32);
                }
                int collectCount = Math.max(0, queue.size() - off);
                assert (collectCount <= lim);
                int sortedIdxStart = queue.size() - (collectCount - 1);
                int sortedIdxEnd = queue.size() + 1;
                final long[] sorted = queue.sort(collectCount);
                int[] indirect = counts;
                assert (indirect.length >= sortedIdxEnd);
                for (i = sortedIdxStart; i < sortedIdxEnd; ++i) {
                    long pair = sorted[i];
                    int c = (int)(pair >>> 32);
                    int tnum = Integer.MAX_VALUE - (int)pair;
                    indirect[i] = i;
                    sorted[i] = tnum;
                    res.add(null, c);
                }
                PrimUtils.sort(sortedIdxStart, sortedIdxEnd, indirect, new PrimUtils.IntComparator(){

                    @Override
                    public int compare(int a, int b) {
                        return (int)sorted[a] - (int)sorted[b];
                    }

                    @Override
                    public boolean lessThan(int a, int b) {
                        return sorted[a] < sorted[b];
                    }

                    @Override
                    public boolean equals(int a, int b) {
                        return sorted[a] == sorted[b];
                    }
                });
                for (i = sortedIdxStart; i < sortedIdxEnd; ++i) {
                    int idx = indirect[i];
                    int tnum = (int)sorted[idx];
                    String label = this.getReadableValue(this.getTermValue(te, tnum), ft, charsRef);
                    res.setName(idx - sortedIdxStart, label);
                }
            } else {
                int i = startTerm;
                if (mincount <= 0) {
                    i = startTerm + off;
                    off = 0;
                }
                while (i < endTerm) {
                    int c;
                    int n3 = c = doNegative ? this.maxTermCounts[i] - counts[i] : counts[i];
                    if (c >= mincount && --off < 0) {
                        if (--lim < 0) break;
                        String label = this.getReadableValue(this.getTermValue(te, i), ft, charsRef);
                        res.add(label, c);
                    }
                    ++i;
                }
            }
        }
        if (missing) {
            res.add(null, SimpleFacets.getFieldMissingCount(searcher, baseDocs, this.field));
        }
        return res;
    }

    public StatsValues getStats(SolrIndexSearcher searcher, DocSet baseDocs, boolean calcDistinct, String[] facet) throws IOException {
        this.use.incrementAndGet();
        SchemaField sf = searcher.getSchema().getField(this.field);
        StatsValues allstats = StatsValuesFactory.createStatsValues(sf, calcDistinct);
        DocSet docs = baseDocs;
        int baseSize = docs.size();
        int maxDoc = searcher.maxDoc();
        if (baseSize <= 0) {
            return allstats;
        }
        DocSet missing = docs.andNot(searcher.getDocSet(new TermRangeQuery(this.field, null, null, false, false)));
        int i = 0;
        FieldFacetStats[] finfo = new FieldFacetStats[facet.length];
        for (String f : facet) {
            SchemaField facet_sf = searcher.getSchema().getField(f);
            finfo[i] = new FieldFacetStats(searcher, f, sf, facet_sf, calcDistinct);
            ++i;
        }
        int[] index = this.index;
        int[] counts = new int[this.numTermsInField];
        TermsEnum te = this.getOrdTermsEnum(searcher.getAtomicReader());
        boolean doNegative = false;
        if (finfo.length == 0) {
            boolean bl = doNegative = baseSize > maxDoc >> 1 && this.termInstances > 0L && docs instanceof BitDocSet;
        }
        if (doNegative) {
            FixedBitSet bs = ((BitDocSet)docs).getBits().clone();
            bs.flip(0, maxDoc);
            docs = new BitDocSet(bs, maxDoc - baseSize);
        }
        for (TopTerm tt : this.bigTerms.values()) {
            if (tt.termNum < 0 || tt.termNum >= this.numTermsInField) continue;
            Term t = new Term(this.field, tt.term);
            if (finfo.length == 0) {
                counts[tt.termNum] = searcher.numDocs((Query)new TermQuery(t), docs);
                continue;
            }
            DocSet bigTermDocSet = searcher.getDocSet(new TermQuery(t)).intersection(docs);
            DocIterator iter = bigTermDocSet.iterator();
            while (iter.hasNext()) {
                int doc = iter.nextDoc();
                int n = tt.termNum;
                counts[n] = counts[n] + 1;
                for (FieldFacetStats f : finfo) {
                    f.facetTermNum(doc, tt.termNum);
                }
            }
        }
        if (this.termInstances > 0L) {
            DocIterator iter = docs.iterator();
            block4: while (iter.hasNext()) {
                int doc = iter.nextDoc();
                int code = index[doc];
                if ((code & 0xFF) == 1) {
                    int pos = code >>> 8;
                    int whichArray = doc >>> 16 & 0xFF;
                    byte[] arr = this.tnums[whichArray];
                    int tnum = 0;
                    block5: while (true) {
                        byte b;
                        int delta = 0;
                        do {
                            b = arr[pos++];
                            delta = delta << 7 | b & 0x7F;
                        } while ((b & 0x80) != 0);
                        if (delta == 0) continue block4;
                        int n = tnum += delta - TNUM_OFFSET;
                        counts[n] = counts[n] + 1;
                        FieldFacetStats[] arr$ = finfo;
                        int len$ = arr$.length;
                        int i$ = 0;
                        while (true) {
                            if (i$ >= len$) continue block5;
                            FieldFacetStats f = arr$[i$];
                            f.facetTermNum(doc, tnum);
                            ++i$;
                        }
                        break;
                    }
                }
                int tnum = 0;
                int delta = 0;
                while (true) {
                    delta = delta << 7 | code & 0x7F;
                    if ((code & 0x80) == 0) {
                        if (delta == 0) continue block4;
                        int n = tnum += delta - TNUM_OFFSET;
                        counts[n] = counts[n] + 1;
                        for (FieldFacetStats f : finfo) {
                            f.facetTermNum(doc, tnum);
                        }
                        delta = 0;
                    }
                    code >>>= 8;
                }
            }
        }
        for (i = 0; i < this.numTermsInField; ++i) {
            int c;
            int n = c = doNegative ? this.maxTermCounts[i] - counts[i] : counts[i];
            if (c == 0) continue;
            BytesRef value = this.getTermValue(te, i);
            allstats.accumulate(value, c);
            for (FieldFacetStats f : finfo) {
                f.accumulateTermNum(i, value);
            }
        }
        int c = missing.size();
        allstats.addMissing(c);
        if (finfo.length > 0) {
            for (FieldFacetStats f : finfo) {
                Map<String, StatsValues> facetStatsValues = f.facetStatsValues;
                FieldType facetType = searcher.getSchema().getFieldType(f.name);
                for (Map.Entry<String, StatsValues> entry : facetStatsValues.entrySet()) {
                    String termLabel = entry.getKey();
                    int missingCount = searcher.numDocs((Query)new TermQuery(new Term(f.name, facetType.toInternal(termLabel))), missing);
                    entry.getValue().addMissing(missingCount);
                }
                allstats.addFacet(f.name, facetStatsValues);
            }
        }
        return allstats;
    }

    String getReadableValue(BytesRef termval, FieldType ft, CharsRef charsRef) {
        return ft.indexedToReadable(termval, charsRef).toString();
    }

    BytesRef getTermValue(TermsEnum te, int termNum) throws IOException {
        TopTerm tt;
        if (this.bigTerms.size() > 0 && (tt = this.bigTerms.get(termNum)) != null) {
            return tt.term;
        }
        return this.lookupTerm(te, termNum);
    }

    public String toString() {
        long indexSize = this.indexedTermsArray == null ? 0L : (long)(32 + (this.indexedTermsArray.length << 3)) + this.sizeOfIndexedStrings;
        return "{field=" + this.field + ",memSize=" + this.memSize() + ",tindexSize=" + indexSize + ",time=" + this.total_time + ",phase1=" + this.phase1_time + ",nTerms=" + this.numTermsInField + ",bigTerms=" + this.bigTerms.size() + ",termInstances=" + this.termInstances + ",uses=" + this.use.get() + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UnInvertedField getUnInvertedField(String field, SolrIndexSearcher searcher) throws IOException {
        SolrCache<String, UnInvertedField> cache = searcher.getFieldValueCache();
        if (cache == null) {
            return new UnInvertedField(field, searcher);
        }
        UnInvertedField uif = null;
        Boolean doWait = false;
        SolrCache<String, UnInvertedField> solrCache = cache;
        synchronized (solrCache) {
            uif = cache.get(field);
            if (uif == null) {
                cache.put(field, uifPlaceholder);
            } else {
                if (!uif.isPlaceholder) {
                    return uif;
                }
                doWait = true;
            }
        }
        while (doWait.booleanValue()) {
            try {
                solrCache = cache;
                synchronized (solrCache) {
                    uif = cache.get(field);
                    if (!uif.isPlaceholder) {
                        return uif;
                    }
                    cache.wait();
                }
            }
            catch (InterruptedException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Thread interrupted in getUninvertedField.");
            }
        }
        uif = new UnInvertedField(field, searcher);
        solrCache = cache;
        synchronized (solrCache) {
            cache.put(field, uif);
            cache.notifyAll();
        }
        return uif;
    }

    static class TopTerm {
        BytesRef term;
        int termNum;

        TopTerm() {
        }

        long memSize() {
            return 24 + this.term.length + 4;
        }
    }
}

