/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.Date;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.DualFloatFunction;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.LongConstValueSource;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.ValueSourceParser;

class DateValueSourceParser
extends ValueSourceParser {
    DateField df = new TrieDateField();

    DateValueSourceParser() {
    }

    @Override
    public void init(NamedList args) {
    }

    public Date getDate(FunctionQParser fp, String arg) {
        if (arg == null) {
            return null;
        }
        if (arg.startsWith("NOW") || arg.length() > 0 && Character.isDigit(arg.charAt(0))) {
            return this.df.parseMathLenient(null, arg, fp.req);
        }
        return null;
    }

    public ValueSource getValueSource(FunctionQParser fp, String arg) {
        if (arg == null) {
            return null;
        }
        SchemaField f = fp.req.getSchema().getField(arg);
        if (f.getType().getClass() == DateField.class) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't use ms() function on non-numeric legacy date field " + arg);
        }
        return f.getType().getValueSource(f, fp);
    }

    @Override
    public ValueSource parse(FunctionQParser fp) throws SyntaxError {
        long ms2;
        Date d1;
        String first = fp.parseArg();
        String second = fp.parseArg();
        if (first == null) {
            first = "NOW";
        }
        ValueSource v1 = (d1 = this.getDate(fp, first)) == null ? this.getValueSource(fp, first) : null;
        Date d2 = this.getDate(fp, second);
        ValueSource v2 = d2 == null ? this.getValueSource(fp, second) : null;
        final long ms1 = d1 == null ? 0L : d1.getTime();
        long l = ms2 = d2 == null ? 0L : d2.getTime();
        if (d1 != null && v2 == null) {
            return new LongConstValueSource(ms1 - ms2);
        }
        if (v1 != null && v2 == null && d2 == null) {
            return v1;
        }
        if (d1 != null && v2 != null) {
            return new DualFloatFunction(new LongConstValueSource(ms1), v2){

                @Override
                protected String name() {
                    return "ms";
                }

                @Override
                protected float func(int doc, FunctionValues aVals, FunctionValues bVals) {
                    return ms1 - bVals.longVal(doc);
                }
            };
        }
        if (v1 != null && d2 != null) {
            return new DualFloatFunction(v1, new LongConstValueSource(ms2)){

                @Override
                protected String name() {
                    return "ms";
                }

                @Override
                protected float func(int doc, FunctionValues aVals, FunctionValues bVals) {
                    return aVals.longVal(doc) - ms2;
                }
            };
        }
        if (v1 != null && v2 != null) {
            return new DualFloatFunction(v1, v2){

                @Override
                protected String name() {
                    return "ms";
                }

                @Override
                protected float func(int doc, FunctionValues aVals, FunctionValues bVals) {
                    return aVals.longVal(doc) - bVals.longVal(doc);
                }
            };
        }
        return null;
    }
}

