/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayList;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.LuceneQParser;
import org.apache.solr.search.SyntaxError;

public class MaxScoreQParser
extends LuceneQParser {
    float tie = 0.0f;

    public MaxScoreQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
        if (this.getParam("tie") != null) {
            this.tie = Float.parseFloat(this.getParam("tie"));
        }
    }

    @Override
    public Query parse() throws SyntaxError {
        Query q = super.parse();
        if (!(q instanceof BooleanQuery)) {
            return q;
        }
        BooleanQuery obq = (BooleanQuery)q;
        ArrayList<Query> should = new ArrayList<Query>();
        ArrayList<BooleanClause> prohibOrReq = new ArrayList<BooleanClause>();
        BooleanQuery newq = new BooleanQuery();
        for (BooleanClause clause : obq.getClauses()) {
            if (clause.isProhibited() || clause.isRequired()) {
                prohibOrReq.add(clause);
                continue;
            }
            BooleanQuery bq = new BooleanQuery();
            bq.add(clause);
            should.add(bq);
        }
        if (should.size() > 0) {
            DisjunctionMaxQuery dmq = new DisjunctionMaxQuery(should, this.tie);
            newq.add(dmq, BooleanClause.Occur.SHOULD);
        }
        for (BooleanClause c : prohibOrReq) {
            newq.add(c);
        }
        newq.setBoost(obq.getBoost());
        return newq;
    }
}

