/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;

public final class LoadAdminUiServlet
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CoreContainer cores = (CoreContainer)request.getAttribute("org.apache.solr.CoreContainer");
        InputStream in = this.getServletContext().getResourceAsStream("/admin.html");
        if (in != null && cores != null) {
            try {
                response.setCharacterEncoding("UTF-8");
                response.setContentType("text/html");
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
                String html = IOUtils.toString(in, "UTF-8");
                Package pack = SolrCore.class.getPackage();
                String[] search = new String[]{"${contextPath}", "${adminPath}", "${version}"};
                String[] replace = new String[]{StringEscapeUtils.escapeJavaScript(request.getContextPath()), StringEscapeUtils.escapeJavaScript(cores.getAdminPath()), StringEscapeUtils.escapeJavaScript(pack.getSpecificationVersion())};
                out.write(StringUtils.replaceEach(html, search, replace));
                ((Writer)out).flush();
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        } else {
            response.sendError(404);
        }
    }
}

