/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet.cache;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.IndexDeletionPolicyWrapper;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.servlet.cache.Method;

public final class HttpCacheHeaderUtil {
    private static Map<SolrCore, EtagCacheVal> etagCoreCache = new WeakHashMap<SolrCore, EtagCacheVal>();

    public static void sendNotModified(HttpServletResponse res) {
        res.setStatus(304);
    }

    public static void sendPreconditionFailed(HttpServletResponse res) {
        res.setStatus(412);
    }

    public static String calcEtag(SolrQueryRequest solrReq) {
        SolrCore core = solrReq.getCore();
        long currentIndexVersion = solrReq.getSearcher().getIndexReader().getVersion();
        EtagCacheVal etagCache = etagCoreCache.get(core);
        if (null == etagCache) {
            String etagSeed = core.getSolrConfig().getHttpCachingConfig().getEtagSeed();
            etagCache = new EtagCacheVal(etagSeed);
            etagCoreCache.put(core, etagCache);
        }
        return etagCache.calcEtag(currentIndexVersion);
    }

    public static boolean isMatchingEtag(List<String> headerList, String etag) {
        for (String header : headerList) {
            String[] headerEtags;
            for (String s : headerEtags = header.split(",")) {
                if (!(s = s.trim()).equals(etag) && !"*".equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    public static long calcLastModified(SolrQueryRequest solrReq) {
        long lastMod;
        SolrCore core = solrReq.getCore();
        SolrIndexSearcher searcher = solrReq.getSearcher();
        SolrConfig.HttpCachingConfig.LastModFrom lastModFrom = core.getSolrConfig().getHttpCachingConfig().getLastModFrom();
        try {
            lastMod = SolrConfig.HttpCachingConfig.LastModFrom.DIRLASTMOD == lastModFrom ? IndexDeletionPolicyWrapper.getCommitTimestamp(searcher.getIndexReader().getIndexCommit()) : searcher.getOpenTime();
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        return lastMod - lastMod % 1000L;
    }

    public static void setCacheControlHeader(SolrConfig conf, HttpServletResponse resp, Method method) {
        Long maxAge;
        if (Method.POST == method || Method.OTHER == method) {
            return;
        }
        String cc = conf.getHttpCachingConfig().getCacheControlHeader();
        if (null != cc) {
            resp.setHeader("Cache-Control", cc);
        }
        if (null != (maxAge = conf.getHttpCachingConfig().getMaxAge())) {
            resp.setDateHeader("Expires", System.currentTimeMillis() + maxAge * 1000L);
        }
    }

    public static boolean doCacheHeaderValidation(SolrQueryRequest solrReq, HttpServletRequest req, Method reqMethod, HttpServletResponse resp) {
        if (Method.POST == reqMethod || Method.OTHER == reqMethod) {
            return false;
        }
        long lastMod = HttpCacheHeaderUtil.calcLastModified(solrReq);
        String etag = HttpCacheHeaderUtil.calcEtag(solrReq);
        resp.setDateHeader("Last-Modified", lastMod);
        resp.setHeader("ETag", etag);
        if (HttpCacheHeaderUtil.checkETagValidators(req, resp, reqMethod, etag)) {
            return true;
        }
        return HttpCacheHeaderUtil.checkLastModValidators(req, resp, lastMod);
    }

    public static boolean checkETagValidators(HttpServletRequest req, HttpServletResponse resp, Method reqMethod, String etag) {
        ArrayList<String> ifNoneMatchList = Collections.list(req.getHeaders("If-None-Match"));
        if (ifNoneMatchList.size() > 0 && HttpCacheHeaderUtil.isMatchingEtag(ifNoneMatchList, etag)) {
            if (reqMethod == Method.GET || reqMethod == Method.HEAD) {
                HttpCacheHeaderUtil.sendNotModified(resp);
            } else {
                HttpCacheHeaderUtil.sendPreconditionFailed(resp);
            }
            return true;
        }
        ArrayList<String> ifMatchList = Collections.list(req.getHeaders("If-Match"));
        if (ifMatchList.size() > 0 && !HttpCacheHeaderUtil.isMatchingEtag(ifMatchList, etag)) {
            HttpCacheHeaderUtil.sendPreconditionFailed(resp);
            return true;
        }
        return false;
    }

    public static boolean checkLastModValidators(HttpServletRequest req, HttpServletResponse resp, long lastMod) {
        try {
            long modifiedSince = req.getDateHeader("If-Modified-Since");
            if (modifiedSince != -1L && lastMod <= modifiedSince) {
                HttpCacheHeaderUtil.sendNotModified(resp);
                return true;
            }
            long unmodifiedSince = req.getDateHeader("If-Unmodified-Since");
            if (unmodifiedSince != -1L && lastMod > unmodifiedSince) {
                HttpCacheHeaderUtil.sendPreconditionFailed(resp);
                return true;
            }
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        return false;
    }

    public static void checkHttpCachingVeto(SolrQueryResponse solrRsp, HttpServletResponse resp, Method reqMethod) {
        if (Method.POST == reqMethod || Method.OTHER == reqMethod) {
            return;
        }
        if (solrRsp.isHttpCaching() && solrRsp.getException() == null) {
            return;
        }
        resp.setHeader("Cache-Control", "no-cache, no-store");
        resp.setHeader("Pragma", "no-cache");
        resp.setHeader("Expires", "Sat, 01 Jan 2000 01:00:00 GMT");
        resp.setDateHeader("Last-Modified", System.currentTimeMillis());
        resp.setHeader("ETag", '\"' + Long.toHexString(System.currentTimeMillis()) + '\"');
    }

    private static class EtagCacheVal {
        private final String etagSeed;
        private String etagCache = null;
        private long indexVersionCache = -1L;

        public EtagCacheVal(String etagSeed) {
            this.etagSeed = etagSeed;
        }

        public String calcEtag(long currentIndexVersion) {
            if (currentIndexVersion != this.indexVersionCache) {
                this.indexVersionCache = currentIndexVersion;
                try {
                    this.etagCache = "\"" + new String(Base64.encodeBase64((Long.toHexString(Long.reverse(this.indexVersionCache)) + this.etagSeed).getBytes("US-ASCII")), "US-ASCII") + "\"";
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.etagCache;
        }
    }
}

