/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.apache.solr.core.ConfigSolr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateShardHandler {
    private static Logger log = LoggerFactory.getLogger(UpdateShardHandler.class);
    private ExecutorService updateExecutor = Executors.newCachedThreadPool(new SolrjNamedThreadFactory("updateExecutor"));
    private PoolingClientConnectionManager clientConnectionManager = new PoolingClientConnectionManager(SchemeRegistryFactory.createSystemDefault());
    private final HttpClient client;

    public UpdateShardHandler(ConfigSolr cfg) {
        this.clientConnectionManager.setMaxTotal(cfg.getMaxUpdateConnections());
        this.clientConnectionManager.setDefaultMaxPerRoute(cfg.getMaxUpdateConnectionsPerHost());
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("socketTimeout", cfg.getDistributedSocketTimeout());
        params.set("connTimeout", cfg.getDistributedConnectionTimeout());
        params.set("retry", false);
        this.client = HttpClientUtil.createClient(params, this.clientConnectionManager);
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public ClientConnectionManager getConnectionManager() {
        return this.clientConnectionManager;
    }

    public ExecutorService getUpdateExecutor() {
        return this.updateExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            ExecutorUtil.shutdownAndAwaitTermination(this.updateExecutor);
        }
        catch (Exception e) {
            SolrException.log(log, e);
        }
        finally {
            this.clientConnectionManager.shutdown();
        }
    }
}

