/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.io.GeohashUtils;
import com.spatial4j.core.shape.Point;
import java.io.IOException;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.LiteralValueSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SpatialQueryable;
import org.apache.solr.schema.StrFieldSource;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrConstantScoreQuery;
import org.apache.solr.search.SpatialOptions;
import org.apache.solr.search.function.ValueSourceRangeFilter;
import org.apache.solr.search.function.distance.GeohashHaversineFunction;
import org.apache.solr.util.SpatialUtils;

public class GeoHashField
extends FieldType
implements SpatialQueryable {
    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        return this.getStringSort(field, top);
    }

    @Override
    public Query createSpatialQuery(QParser parser, SpatialOptions options) {
        String geohash = this.toInternal(options.pointStr);
        return new SolrConstantScoreQuery(new ValueSourceRangeFilter(new GeohashHaversineFunction(this.getValueSource(options.field, parser), new LiteralValueSource(geohash), options.radius), "0", String.valueOf(options.distance), true, true));
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, this.toExternal(f), false);
    }

    @Override
    public String toExternal(IndexableField f) {
        Point p = GeohashUtils.decode(f.stringValue(), SpatialContext.GEO);
        return p.getY() + "," + p.getX();
    }

    @Override
    public String toInternal(String val) {
        Point point = SpatialUtils.parsePointSolrException(val, SpatialContext.GEO);
        return GeohashUtils.encodeLatLon(point.getY(), point.getX());
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        field.checkFieldCacheSource(parser);
        return new StrFieldSource(field.name);
    }
}

