/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.DocTermsIndexDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueLong;
import org.apache.solr.util.NumberUtils;

class SortableLongFieldSource
extends FieldCacheSource {
    protected long defVal;
    private static int hcode = SortableLongFieldSource.class.hashCode();

    public SortableLongFieldSource(String field) {
        this(field, 0L);
    }

    public SortableLongFieldSource(String field, long defVal) {
        super(field);
        this.defVal = defVal;
    }

    @Override
    public String description() {
        return "slong(" + this.field + ')';
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        final long def = this.defVal;
        return new DocTermsIndexDocValues(this, readerContext, this.field){
            private final BytesRef spare;
            {
                super(x0, x1, x2);
                this.spare = new BytesRef();
            }

            @Override
            protected String toTerm(String readableValue) {
                return NumberUtils.long2sortableStr(readableValue);
            }

            @Override
            public boolean exists(int doc) {
                return this.termsIndex.getOrd(doc) >= 0;
            }

            @Override
            public float floatVal(int doc) {
                return this.longVal(doc);
            }

            @Override
            public int intVal(int doc) {
                return (int)this.longVal(doc);
            }

            @Override
            public long longVal(int doc) {
                int ord = this.termsIndex.getOrd(doc);
                if (ord == -1) {
                    return def;
                }
                this.termsIndex.lookupOrd(ord, this.spare);
                return NumberUtils.SortableStr2long(this.spare, 0, 5);
            }

            @Override
            public double doubleVal(int doc) {
                return this.longVal(doc);
            }

            @Override
            public String strVal(int doc) {
                return Long.toString(this.longVal(doc));
            }

            @Override
            public Object objectVal(int doc) {
                return this.exists(doc) ? Long.valueOf(this.longVal(doc)) : null;
            }

            @Override
            public String toString(int doc) {
                return SortableLongFieldSource.this.description() + '=' + this.longVal(doc);
            }

            @Override
            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueLong mval = new MutableValueLong();

                    @Override
                    public MutableValue getValue() {
                        return this.mval;
                    }

                    @Override
                    public void fillValue(int doc) {
                        int ord = termsIndex.getOrd(doc);
                        if (ord == -1) {
                            this.mval.value = def;
                            this.mval.exists = false;
                        } else {
                            termsIndex.lookupOrd(ord, spare);
                            this.mval.value = NumberUtils.SortableStr2long(spare, 0, 5);
                            this.mval.exists = true;
                        }
                    }
                };
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof SortableLongFieldSource && super.equals(o) && this.defVal == ((SortableLongFieldSource)o).defVal;
    }

    @Override
    public int hashCode() {
        return hcode + super.hashCode() + (int)this.defVal;
    }
}

