/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.config;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Provides;
import java.net.URI;
import javax.inject.Singleton;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.cinder.v1.CinderApi;
import org.jclouds.openstack.cinder.v1.handlers.CinderErrorHandler;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;

@ConfiguresHttpApi
public class CinderHttpApiModule
extends HttpApiModule<CinderApi> {
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        super.configure();
    }

    @Provides
    @Singleton
    public Multimap<URI, URI> aliases() {
        return ImmutableMultimap.builder().build();
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(CinderErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(CinderErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(CinderErrorHandler.class);
    }
}

