/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.mongodb.config;

import com.mongodb.MongoClientOptions;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.mongodb.mongo.MongoDB;
import org.apache.jmeter.protocol.mongodb.mongo.MongoUtils;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class MongoSourceElement
extends ConfigTestElement
implements TestStateListener,
TestBean {
    private static final long serialVersionUID = 2100L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private String connection;
    private String source;
    private boolean autoConnectRetry;
    private int connectionsPerHost;
    private int connectTimeout;
    private long maxAutoConnectRetryTime;
    private int maxWaitTime;
    private int socketTimeout;
    private boolean socketKeepAlive;
    private int threadsAllowedToBlockForConnectionMultiplier;
    private boolean fsync;
    private boolean safe;
    private boolean waitForJournaling;
    private int writeOperationNumberOfServers;
    private int writeOperationTimeout;
    private boolean continueOnInsertError;

    public String getTitle() {
        return this.getName();
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public static MongoDB getMongoDB(String source) {
        Object mongoSource = JMeterContextService.getContext().getVariables().getObject(source);
        if (mongoSource == null) {
            throw new IllegalStateException("mongoSource is null");
        }
        if (mongoSource instanceof MongoDB) {
            return (MongoDB)mongoSource;
        }
        throw new IllegalStateException("Variable:" + source + " is not a MongoDB instance, class:" + mongoSource.getClass());
    }

    public void addConfigElement(ConfigElement configElement) {
    }

    public boolean expectsModification() {
        return false;
    }

    public void testStarted() {
        if (log.isDebugEnabled()) {
            log.debug(this.getTitle() + " testStarted");
        }
        MongoClientOptions.Builder builder = MongoClientOptions.builder().autoConnectRetry(this.getAutoConnectRetry()).connectTimeout(this.getConnectTimeout()).connectionsPerHost(this.getConnectionsPerHost()).maxAutoConnectRetryTime(this.getMaxAutoConnectRetryTime()).maxWaitTime(this.getMaxWaitTime()).socketKeepAlive(this.getSocketKeepAlive()).socketTimeout(this.getSocketTimeout()).threadsAllowedToBlockForConnectionMultiplier(this.getThreadsAllowedToBlockForConnectionMultiplier());
        if (this.getSafe()) {
            builder.writeConcern(WriteConcern.SAFE);
        } else {
            builder.writeConcern(new WriteConcern(this.getWriteOperationNumberOfServers(), this.getWriteOperationTimeout(), this.getFsync(), this.getWaitForJournaling(), this.getContinueOnInsertError()));
        }
        MongoClientOptions mongoOptions = builder.build();
        if (log.isDebugEnabled()) {
            log.debug("options : " + mongoOptions.toString());
        }
        if (this.getThreadContext().getVariables().getObject(this.getSource()) != null) {
            if (log.isWarnEnabled()) {
                log.warn(this.getSource() + " has already been defined.");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug(this.getSource() + "  is being defined.");
            }
            try {
                this.getThreadContext().getVariables().putObject(this.getSource(), (Object)new MongoDB(MongoUtils.toServerAddresses(this.getConnection()), mongoOptions));
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void testStarted(String s) {
        this.testStarted();
    }

    public void testEnded() {
        if (log.isDebugEnabled()) {
            log.debug(this.getTitle() + " testEnded");
        }
        ((MongoDB)this.getThreadContext().getVariables().getObject(this.getSource())).clear();
    }

    public void testEnded(String s) {
        this.testEnded();
    }

    public boolean getAutoConnectRetry() {
        return this.autoConnectRetry;
    }

    public void setAutoConnectRetry(boolean autoConnectRetry) {
        this.autoConnectRetry = autoConnectRetry;
    }

    public int getConnectionsPerHost() {
        return this.connectionsPerHost;
    }

    public void setConnectionsPerHost(int connectionsPerHost) {
        this.connectionsPerHost = connectionsPerHost;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getMaxAutoConnectRetryTime() {
        return this.maxAutoConnectRetryTime;
    }

    public void setMaxAutoConnectRetryTime(long maxAutoConnectRetryTime) {
        this.maxAutoConnectRetryTime = maxAutoConnectRetryTime;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public boolean getSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public void setSocketKeepAlive(boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
    }

    public int getThreadsAllowedToBlockForConnectionMultiplier() {
        return this.threadsAllowedToBlockForConnectionMultiplier;
    }

    public void setThreadsAllowedToBlockForConnectionMultiplier(int threadsAllowedToBlockForConnectionMultiplier) {
        this.threadsAllowedToBlockForConnectionMultiplier = threadsAllowedToBlockForConnectionMultiplier;
    }

    public boolean getFsync() {
        return this.fsync;
    }

    public void setFsync(boolean fsync) {
        this.fsync = fsync;
    }

    public boolean getSafe() {
        return this.safe;
    }

    public void setSafe(boolean safe) {
        this.safe = safe;
    }

    public boolean getWaitForJournaling() {
        return this.waitForJournaling;
    }

    public void setWaitForJournaling(boolean waitForJournaling) {
        this.waitForJournaling = waitForJournaling;
    }

    public int getWriteOperationNumberOfServers() {
        return this.writeOperationNumberOfServers;
    }

    public void setWriteOperationNumberOfServers(int writeOperationNumberOfServers) {
        this.writeOperationNumberOfServers = writeOperationNumberOfServers;
    }

    public int getWriteOperationTimeout() {
        return this.writeOperationTimeout;
    }

    public void setWriteOperationTimeout(int writeOperationTimeout) {
        this.writeOperationTimeout = writeOperationTimeout;
    }

    public boolean getContinueOnInsertError() {
        return this.continueOnInsertError;
    }

    public void setContinueOnInsertError(boolean continueOnInsertError) {
        this.continueOnInsertError = continueOnInsertError;
    }
}

