/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.kafka.common.record.ByteBufferLogInputStream;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.TimestampType;
import org.junit.Assert;
import org.junit.Test;

public class ByteBufferLogInputStreamTest {
    @Test
    public void iteratorIgnoresIncompleteEntries() {
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(15L, "a".getBytes(), "1".getBytes());
        builder.append(20L, "b".getBytes(), "2".getBytes());
        ByteBuffer recordsBuffer = builder.build().buffer();
        recordsBuffer.limit(recordsBuffer.limit() - 5);
        Iterator iterator = MemoryRecords.readableRecords((ByteBuffer)recordsBuffer).shallowEntries().iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        ByteBufferLogInputStream.ByteBufferLogEntry first = (ByteBufferLogInputStream.ByteBufferLogEntry)iterator.next();
        Assert.assertEquals((long)0L, (long)first.offset());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testSetCreateTimeV1() {
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(15L, "a".getBytes(), "1".getBytes());
        Iterator iterator = builder.build().shallowEntries().iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        ByteBufferLogInputStream.ByteBufferLogEntry entry = (ByteBufferLogInputStream.ByteBufferLogEntry)iterator.next();
        long createTimeMs = 20L;
        entry.setCreateTime(createTimeMs);
        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)entry.record().timestampType());
        Assert.assertEquals((long)createTimeMs, (long)entry.record().timestamp());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetCreateTimeNotAllowedV0() {
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)0, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(15L, "a".getBytes(), "1".getBytes());
        Iterator iterator = builder.build().shallowEntries().iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        ByteBufferLogInputStream.ByteBufferLogEntry entry = (ByteBufferLogInputStream.ByteBufferLogEntry)iterator.next();
        long createTimeMs = 20L;
        entry.setCreateTime(createTimeMs);
    }

    @Test
    public void testSetLogAppendTimeV1() {
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(15L, "a".getBytes(), "1".getBytes());
        Iterator iterator = builder.build().shallowEntries().iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        ByteBufferLogInputStream.ByteBufferLogEntry entry = (ByteBufferLogInputStream.ByteBufferLogEntry)iterator.next();
        long logAppendTime = 20L;
        entry.setLogAppendTime(logAppendTime);
        Assert.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)entry.record().timestampType());
        Assert.assertEquals((long)logAppendTime, (long)entry.record().timestamp());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetLogAppendTimeNotAllowedV0() {
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)0, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(15L, "a".getBytes(), "1".getBytes());
        Iterator iterator = builder.build().shallowEntries().iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        ByteBufferLogInputStream.ByteBufferLogEntry entry = (ByteBufferLogInputStream.ByteBufferLogEntry)iterator.next();
        long logAppendTime = 20L;
        entry.setLogAppendTime(logAppendTime);
    }
}

