/*
 * Decompiled with CFR 0.152.
 */
package kafka.etl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;

public class KafkaETLKey
implements WritableComparable<KafkaETLKey> {
    protected int _inputIndex;
    protected long _offset;
    protected long _checksum;

    public KafkaETLKey() {
        this._inputIndex = 0;
        this._offset = 0L;
        this._checksum = 0L;
    }

    public KafkaETLKey(int index, long offset) {
        this._inputIndex = index;
        this._offset = offset;
        this._checksum = 0L;
    }

    public KafkaETLKey(int index, long offset, long checksum) {
        this._inputIndex = index;
        this._offset = offset;
        this._checksum = checksum;
    }

    public void set(int index, long offset, long checksum) {
        this._inputIndex = index;
        this._offset = offset;
        this._checksum = checksum;
    }

    public int getIndex() {
        return this._inputIndex;
    }

    public long getOffset() {
        return this._offset;
    }

    public long getChecksum() {
        return this._checksum;
    }

    public void readFields(DataInput in) throws IOException {
        this._inputIndex = in.readInt();
        this._offset = in.readLong();
        this._checksum = in.readLong();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this._inputIndex);
        out.writeLong(this._offset);
        out.writeLong(this._checksum);
    }

    public int compareTo(KafkaETLKey o) {
        if (this._inputIndex != o._inputIndex) {
            this._inputIndex = o._inputIndex;
            return this._inputIndex;
        }
        if (this._offset > o._offset) {
            return 1;
        }
        if (this._offset < o._offset) {
            return -1;
        }
        if (this._checksum > o._checksum) {
            return 1;
        }
        if (this._checksum < o._checksum) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return "index=" + this._inputIndex + " offset=" + this._offset + " checksum=" + this._checksum;
    }
}

