/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.util.Collections;
import junit.framework.Assert;
import kafka.common.MessageStreamsExistException;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.consumer.PartitionTopicInfo;
import kafka.consumer.ZookeeperConsumerConnector;
import kafka.consumer.ZookeeperConsumerConnectorTest$;
import kafka.consumer.ZookeeperConsumerConnectorTest$$anonfun$testConsumerDecoder$2$;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.message.CompressionCodec;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.serializer.Decoder;
import kafka.serializer.StringDecoder;
import kafka.serializer.StringDecoder$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.TestUtils$;
import kafka.utils.TestZKUtils$;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZKStringSerializer$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0001\u0003\u0001\u001d\u0011aDW8pW\u0016,\u0007/\u001a:D_:\u001cX/\\3s\u0007>tg.Z2u_J$Vm\u001d;\u000b\u0005\r!\u0011\u0001C2p]N,X.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u0011IA\u0002CA\u0005\u0011\u001b\u0005Q!BA\u0006\r\u0003\u0015QWO\\5u\u0015\tia\"A\u0005tG\u0006d\u0017\r^3ti*\tq\"A\u0002pe\u001eL!!\u0005\u0006\u0003\u0017)+f.\u001b;4'VLG/\u001a\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0011\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011q\u0003\u0006\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tgB\u0011\u0011\u0004H\u0007\u00025)\u00111\u0004B\u0001\u0006kRLGn]\u0005\u0003;i\u0011q\u0001T8hO&tw\rC\u0003 \u0001\u0011\u0005\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011!\u0005A\u0007\u0002\u0005!9A\u0005\u0001b\u0001\n\u0003)\u0013A\u0005*fE\u0006d\u0017M\\2f\u0005\u0006\u001c7n\u001c4g\u001bN,\u0012A\n\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0004\u0013:$\bBB\u0017\u0001A\u0003%a%A\nSK\n\fG.\u00198dK\n\u000b7m[8gM6\u001b\b\u0005C\u00040\u0001\u0001\u0007I\u0011\u0001\u0019\u0002\t\u0011L'o]\u000b\u0002cA\u0011\u0011DM\u0005\u0003gi\u0011\u0001CW&He>,\b\u000fV8qS\u000e$\u0015N]:\t\u000fU\u0002\u0001\u0019!C\u0001m\u0005AA-\u001b:t?\u0012*\u0017\u000f\u0006\u00028uA\u0011q\u0005O\u0005\u0003s!\u0012A!\u00168ji\"91\bNA\u0001\u0002\u0004\t\u0014a\u0001=%c!1Q\b\u0001Q!\nE\nQ\u0001Z5sg\u0002Bqa\u0010\u0001C\u0002\u0013\u0005\u0001)\u0001\t{_>\\W-\u001a9fe\u000e{gN\\3diV\t\u0011\t\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u0006!A.\u00198h\u0015\u00051\u0015\u0001\u00026bm\u0006L!\u0001S\"\u0003\rM#(/\u001b8h\u0011\u0019Q\u0005\u0001)A\u0005\u0003\u0006\t\"p\\8lK\u0016\u0004XM]\"p]:,7\r\u001e\u0011\t\u000f1\u0003!\u0019!C\u0001K\u0005Aa.^7O_\u0012,7\u000f\u0003\u0004O\u0001\u0001\u0006IAJ\u0001\n]Vlgj\u001c3fg\u0002Bq\u0001\u0015\u0001C\u0002\u0013\u0005Q%\u0001\u0005ok6\u0004\u0016M\u001d;t\u0011\u0019\u0011\u0006\u0001)A\u0005M\u0005Ia.^7QCJ$8\u000f\t\u0005\b)\u0002\u0011\r\u0011\"\u0001A\u0003\u0015!x\u000e]5d\u0011\u00191\u0006\u0001)A\u0005\u0003\u00061Ao\u001c9jG\u0002Bq\u0001\u0017\u0001C\u0002\u0013\u0005\u0011,A\u0004d_:4\u0017nZ:\u0016\u0003i\u00032a\u00171c\u001b\u0005a&BA/_\u0003%IW.\\;uC\ndWM\u0003\u0002`Q\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0005d&\u0001\u0002'jgR\u0004\"a\u00194\u000e\u0003\u0011T!!\u001a\u0003\u0002\rM,'O^3s\u0013\t9GMA\u0006LC\u001a\\\u0017mQ8oM&<\u0007BB5\u0001A\u0003%!,\u0001\u0005d_:4\u0017nZ:!\u0011\u001dY\u0007A1A\u0005\u0002\u0001\u000bQa\u001a:pkBDa!\u001c\u0001!\u0002\u0013\t\u0015AB4s_V\u0004\b\u0005C\u0004p\u0001\t\u0007I\u0011\u0001!\u0002\u0013\r|gn];nKJ\u0004\u0004BB9\u0001A\u0003%\u0011)\u0001\u0006d_:\u001cX/\\3sa\u0001Bqa\u001d\u0001C\u0002\u0013\u0005\u0001)A\u0005d_:\u001cX/\\3sc!1Q\u000f\u0001Q\u0001\n\u0005\u000b!bY8ogVlWM]\u0019!\u0011\u001d9\bA1A\u0005\u0002\u0001\u000b\u0011bY8ogVlWM\u001d\u001a\t\re\u0004\u0001\u0015!\u0003B\u0003)\u0019wN\\:v[\u0016\u0014(\u0007\t\u0005\bw\u0002\u0011\r\u0011\"\u0001A\u0003%\u0019wN\\:v[\u0016\u00148\u0007\u0003\u0004~\u0001\u0001\u0006I!Q\u0001\u000bG>t7/^7feN\u0002\u0003bB@\u0001\u0005\u0004%\t!J\u0001\n]6+7o]1hKNDq!a\u0001\u0001A\u0003%a%\u0001\u0006o\u001b\u0016\u001c8/Y4fg\u0002Bq!a\u0002\u0001\t\u0003\nI!A\u0003tKR,\u0006\u000fF\u00018\u0011\u001d\ti\u0001\u0001C!\u0003\u0013\t\u0001\u0002^3be\u0012{wO\u001c\u0005\b\u0003#\u0001A\u0011AA\u0005\u0003%!Xm\u001d;CCNL7\rC\u0004\u0002\u0016\u0001!\t!!\u0003\u0002\u001fQ,7\u000f^\"p[B\u0014Xm]:j_:Dq!!\u0007\u0001\t\u0003\tI!A\u000fuKN$8i\\7qe\u0016\u001c8/[8o'\u0016$8i\u001c8tk6\u0004H/[8o\u0011\u001d\ti\u0002\u0001C\u0001\u0003\u0013\t1\u0003^3ti\u000e{gn];nKJ$UmY8eKJDq!!\t\u0001\t\u0003\tI!A\u0010uKN$H*Z1eKJ\u001cV\r\\3di&|gNR8s!\u0006\u0014H/\u001b;j_:Dq!!\n\u0001\t\u0003\t9#A\nhKRT6j\u00115jY\u0012\u0014XM\u001c,bYV,7\u000f\u0006\u0003\u0002*\u0005\r\u0003CBA\u0016\u0003[\t\t$D\u0001_\u0013\r\tyC\u0018\u0002\u0004'\u0016\f\bcB\u0014\u00024\u0005]\u0012qG\u0005\u0004\u0003kA#A\u0002+va2,'\u0007\u0005\u0003\u0002:\u0005}bbA\u0014\u0002<%\u0019\u0011Q\b\u0015\u0002\rA\u0013X\rZ3g\u0013\rA\u0015\u0011\t\u0006\u0004\u0003{A\u0003\u0002CA#\u0003G\u0001\r!a\u000e\u0002\tA\fG\u000f\u001b")
public class ZookeeperConsumerConnectorTest
extends JUnit3Suite
implements KafkaServerTestHarness,
Logging {
    private final int RebalanceBackoffMs;
    private ZKGroupTopicDirs dirs;
    private final String zookeeperConnect;
    private final int numNodes;
    private final int numParts;
    private final String topic;
    private final List<KafkaConfig> configs;
    private final String group;
    private final String consumer0;
    private final String consumer1;
    private final String consumer2;
    private final String consumer3;
    private final int nMessages;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private List<KafkaServer> servers;
    private String brokerList;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ZookeeperConsumerConnectorTest zookeeperConsumerConnectorTest = this;
        synchronized (zookeeperConsumerConnectorTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Override
    public List<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(List<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    public int RebalanceBackoffMs() {
        return this.RebalanceBackoffMs;
    }

    public ZKGroupTopicDirs dirs() {
        return this.dirs;
    }

    public void dirs_$eq(ZKGroupTopicDirs x$1) {
        this.dirs = x$1;
    }

    public String zookeeperConnect() {
        return this.zookeeperConnect;
    }

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public String topic() {
        return this.topic;
    }

    @Override
    public List<KafkaConfig> configs() {
        return this.configs;
    }

    public String group() {
        return this.group;
    }

    public String consumer0() {
        return this.consumer0;
    }

    public String consumer1() {
        return this.consumer1;
    }

    public String consumer2() {
        return this.consumer2;
    }

    public String consumer3() {
        return this.consumer3;
    }

    public int nMessages() {
        return this.nMessages;
    }

    @Override
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
        this.dirs_$eq(new ZKGroupTopicDirs(this.group(), this.topic()));
    }

    @Override
    public void tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    public void testBasic() {
        Logger requestHandlerLogger = Logger.getLogger(KafkaRequestHandler.class);
        requestHandlerLogger.setLevel(Level.FATAL);
        ConsumerConfig consumerConfig0 = new ConsumerConfig(this){
            private final int consumerTimeoutMs;

            public int consumerTimeoutMs() {
                return this.consumerTimeoutMs;
            }
            {
                this.consumerTimeoutMs = 200;
            }
        };
        ZookeeperConsumerConnector zkConsumerConnector0 = new ZookeeperConsumerConnector(consumerConfig0, true);
        Map topicMessageStreams0 = zkConsumerConnector0.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)new Serializable(this, topicMessageStreams0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZookeeperConsumerConnectorTest $outer;
            private final Map topicMessageStreams0$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                try {
                    TestUtils$.MODULE$.getMessages(this.$outer.nMessages() * 2, (Map<String, List<KafkaStream<String, String>>>)this.topicMessageStreams0$1);
                    throw this.$outer.fail("should get an exception");
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                catch (ConsumerTimeoutException consumerTimeoutException) {
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicMessageStreams0$1 = topicMessageStreams0$1;
            }
        });
        zkConsumerConnector0.shutdown();
        List sentMessages1 = (List)TestUtils$.MODULE$.sendMessagesToPartition((Seq<KafkaConfig>)this.configs(), this.topic(), 0, this.nMessages(), TestUtils$.MODULE$.sendMessagesToPartition$default$5()).$plus$plus(TestUtils$.MODULE$.sendMessagesToPartition((Seq<KafkaConfig>)this.configs(), this.topic(), 1, this.nMessages(), TestUtils$.MODULE$.sendMessagesToPartition$default$5()), List$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        ConsumerConfig consumerConfig1 = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), this.group(), this.consumer1(), TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZookeeperConsumerConnector zkConsumerConnector1 = new ZookeeperConsumerConnector(consumerConfig1, true);
        Map topicMessageStreams1 = zkConsumerConnector1.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        List<String> receivedMessages1 = TestUtils$.MODULE$.getMessages(this.nMessages() * 2, (Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1);
        Assert.assertEquals((Object)sentMessages1.sorted((Ordering)Ordering.String$.MODULE$), (Object)receivedMessages1.sorted((Ordering)Ordering.String$.MODULE$));
        Seq<Tuple2<String, String>> actual_1 = this.getZKChildrenValues(this.dirs().consumerOwnerDir());
        List expected_1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"0", (Object)"group1_consumer1-0"), new Tuple2((Object)"1", (Object)"group1_consumer1-0")}));
        Assert.assertEquals((Object)expected_1, actual_1);
        zkConsumerConnector1.commitOffsets(true);
        ConsumerConfig consumerConfig2 = new ConsumerConfig(this){
            private final int rebalanceBackoffMs;

            public int rebalanceBackoffMs() {
                return this.rebalanceBackoffMs;
            }
            {
                this.rebalanceBackoffMs = $outer.RebalanceBackoffMs();
            }
        };
        ZookeeperConsumerConnector zkConsumerConnector2 = new ZookeeperConsumerConnector(consumerConfig2, true);
        Map topicMessageStreams2 = zkConsumerConnector2.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        List sentMessages2 = (List)TestUtils$.MODULE$.sendMessagesToPartition((Seq<KafkaConfig>)this.configs(), this.topic(), 0, this.nMessages(), TestUtils$.MODULE$.sendMessagesToPartition$default$5()).$plus$plus(TestUtils$.MODULE$.sendMessagesToPartition((Seq<KafkaConfig>)this.configs(), this.topic(), 1, this.nMessages(), TestUtils$.MODULE$.sendMessagesToPartition$default$5()), List$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        List receivedMessages2 = (List)TestUtils$.MODULE$.getMessages(this.nMessages(), (Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1).$plus$plus(TestUtils$.MODULE$.getMessages(this.nMessages(), (Map<String, List<KafkaStream<String, String>>>)topicMessageStreams2), List$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)sentMessages2.sorted((Ordering)Ordering.String$.MODULE$), (Object)receivedMessages2.sorted((Ordering)Ordering.String$.MODULE$));
        Seq<Tuple2<String, String>> actual_2 = this.getZKChildrenValues(this.dirs().consumerOwnerDir());
        List expected_2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"0", (Object)"group1_consumer1-0"), new Tuple2((Object)"1", (Object)"group1_consumer2-0")}));
        Assert.assertEquals((Object)expected_2, actual_2);
        ConsumerConfig consumerConfig3 = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), this.group(), this.consumer3(), TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZookeeperConsumerConnector zkConsumerConnector3 = new ZookeeperConsumerConnector(consumerConfig3, true);
        Map topicMessageStreams3 = zkConsumerConnector3.createMessageStreams((Map)new HashMap());
        List sentMessages3 = (List)TestUtils$.MODULE$.sendMessagesToPartition((Seq<KafkaConfig>)this.configs(), this.topic(), 0, this.nMessages(), TestUtils$.MODULE$.sendMessagesToPartition$default$5()).$plus$plus(TestUtils$.MODULE$.sendMessagesToPartition((Seq<KafkaConfig>)this.configs(), this.topic(), 1, this.nMessages(), TestUtils$.MODULE$.sendMessagesToPartition$default$5()), List$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        List receivedMessages3 = (List)TestUtils$.MODULE$.getMessages(this.nMessages(), (Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1).$plus$plus(TestUtils$.MODULE$.getMessages(this.nMessages(), (Map<String, List<KafkaStream<String, String>>>)topicMessageStreams2), List$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)sentMessages3.sorted((Ordering)Ordering.String$.MODULE$), (Object)receivedMessages3.sorted((Ordering)Ordering.String$.MODULE$));
        Seq<Tuple2<String, String>> actual_3 = this.getZKChildrenValues(this.dirs().consumerOwnerDir());
        Assert.assertEquals((Object)expected_2, actual_3);
        try {
            Map topicMessageStreams4 = zkConsumerConnector3.createMessageStreams((Map)new HashMap());
            throw this.fail("Should fail with MessageStreamsExistException");
        }
        catch (MessageStreamsExistException messageStreamsExistException) {
            zkConsumerConnector1.shutdown();
            zkConsumerConnector2.shutdown();
            zkConsumerConnector3.shutdown();
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "all consumer connectors stopped";
                }
            });
            requestHandlerLogger.setLevel(Level.ERROR);
            return;
        }
    }

    public void testCompression() {
        Logger requestHandlerLogger = Logger.getLogger(KafkaRequestHandler.class);
        requestHandlerLogger.setLevel(Level.FATAL);
        List sentMessages1 = (List)TestUtils$.MODULE$.sendMessagesToPartition((Seq<KafkaConfig>)this.configs(), this.topic(), 0, this.nMessages(), (CompressionCodec)GZIPCompressionCodec$.MODULE$).$plus$plus(TestUtils$.MODULE$.sendMessagesToPartition((Seq<KafkaConfig>)this.configs(), this.topic(), 1, this.nMessages(), (CompressionCodec)GZIPCompressionCodec$.MODULE$), List$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        ConsumerConfig consumerConfig1 = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), this.group(), this.consumer1(), TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZookeeperConsumerConnector zkConsumerConnector1 = new ZookeeperConsumerConnector(consumerConfig1, true);
        Map topicMessageStreams1 = zkConsumerConnector1.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        List<String> receivedMessages1 = TestUtils$.MODULE$.getMessages(this.nMessages() * 2, (Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1);
        Assert.assertEquals((Object)sentMessages1.sorted((Ordering)Ordering.String$.MODULE$), (Object)receivedMessages1.sorted((Ordering)Ordering.String$.MODULE$));
        Seq<Tuple2<String, String>> actual_1 = this.getZKChildrenValues(this.dirs().consumerOwnerDir());
        List expected_1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"0", (Object)"group1_consumer1-0"), new Tuple2((Object)"1", (Object)"group1_consumer1-0")}));
        Assert.assertEquals((Object)expected_1, actual_1);
        zkConsumerConnector1.commitOffsets(true);
        ConsumerConfig consumerConfig2 = new ConsumerConfig(this){
            private final int rebalanceBackoffMs;

            public int rebalanceBackoffMs() {
                return this.rebalanceBackoffMs;
            }
            {
                this.rebalanceBackoffMs = $outer.RebalanceBackoffMs();
            }
        };
        ZookeeperConsumerConnector zkConsumerConnector2 = new ZookeeperConsumerConnector(consumerConfig2, true);
        Map topicMessageStreams2 = zkConsumerConnector2.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        List sentMessages2 = (List)TestUtils$.MODULE$.sendMessagesToPartition((Seq<KafkaConfig>)this.configs(), this.topic(), 0, this.nMessages(), (CompressionCodec)GZIPCompressionCodec$.MODULE$).$plus$plus(TestUtils$.MODULE$.sendMessagesToPartition((Seq<KafkaConfig>)this.configs(), this.topic(), 1, this.nMessages(), (CompressionCodec)GZIPCompressionCodec$.MODULE$), List$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        List receivedMessages2 = (List)TestUtils$.MODULE$.getMessages(this.nMessages(), (Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1).$plus$plus(TestUtils$.MODULE$.getMessages(this.nMessages(), (Map<String, List<KafkaStream<String, String>>>)topicMessageStreams2), List$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)sentMessages2.sorted((Ordering)Ordering.String$.MODULE$), (Object)receivedMessages2.sorted((Ordering)Ordering.String$.MODULE$));
        Seq<Tuple2<String, String>> actual_2 = this.getZKChildrenValues(this.dirs().consumerOwnerDir());
        List expected_2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"0", (Object)"group1_consumer1-0"), new Tuple2((Object)"1", (Object)"group1_consumer2-0")}));
        Assert.assertEquals((Object)expected_2, actual_2);
        ConsumerConfig consumerConfig3 = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), this.group(), this.consumer3(), TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZookeeperConsumerConnector zkConsumerConnector3 = new ZookeeperConsumerConnector(consumerConfig3, true);
        Map topicMessageStreams3 = zkConsumerConnector3.createMessageStreams((Map)new HashMap(), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        List sentMessages3 = (List)TestUtils$.MODULE$.sendMessagesToPartition((Seq<KafkaConfig>)this.configs(), this.topic(), 0, this.nMessages(), (CompressionCodec)GZIPCompressionCodec$.MODULE$).$plus$plus(TestUtils$.MODULE$.sendMessagesToPartition((Seq<KafkaConfig>)this.configs(), this.topic(), 1, this.nMessages(), (CompressionCodec)GZIPCompressionCodec$.MODULE$), List$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        List receivedMessages3 = (List)TestUtils$.MODULE$.getMessages(this.nMessages(), (Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1).$plus$plus(TestUtils$.MODULE$.getMessages(this.nMessages(), (Map<String, List<KafkaStream<String, String>>>)topicMessageStreams2), List$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)sentMessages3.sorted((Ordering)Ordering.String$.MODULE$), (Object)receivedMessages3.sorted((Ordering)Ordering.String$.MODULE$));
        Seq<Tuple2<String, String>> actual_3 = this.getZKChildrenValues(this.dirs().consumerOwnerDir());
        Assert.assertEquals((Object)expected_2, actual_3);
        zkConsumerConnector1.shutdown();
        zkConsumerConnector2.shutdown();
        zkConsumerConnector3.shutdown();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "all consumer connectors stopped";
            }
        });
        requestHandlerLogger.setLevel(Level.ERROR);
    }

    public void testCompressionSetConsumption() {
        List sentMessages = (List)TestUtils$.MODULE$.sendMessagesToPartition((Seq<KafkaConfig>)this.configs(), this.topic(), 0, 200, (CompressionCodec)DefaultCompressionCodec$.MODULE$).$plus$plus(TestUtils$.MODULE$.sendMessagesToPartition((Seq<KafkaConfig>)this.configs(), this.topic(), 1, 200, (CompressionCodec)DefaultCompressionCodec$.MODULE$), List$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        ConsumerConfig consumerConfig1 = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), this.group(), this.consumer0(), TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZookeeperConsumerConnector zkConsumerConnector1 = new ZookeeperConsumerConnector(consumerConfig1, true);
        Map topicMessageStreams1 = zkConsumerConnector1.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        List<String> receivedMessages = TestUtils$.MODULE$.getMessages(400, (Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1);
        Assert.assertEquals((Object)sentMessages.sorted((Ordering)Ordering.String$.MODULE$), (Object)receivedMessages.sorted((Ordering)Ordering.String$.MODULE$));
        Seq<Tuple2<String, String>> actual_2 = this.getZKChildrenValues(this.dirs().consumerOwnerDir());
        List expected_2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"0", (Object)"group1_consumer0-0"), new Tuple2((Object)"1", (Object)"group1_consumer0-0")}));
        Assert.assertEquals((Object)expected_2, actual_2);
        zkConsumerConnector1.shutdown();
    }

    public void testConsumerDecoder() {
        Logger requestHandlerLogger = Logger.getLogger(KafkaRequestHandler.class);
        requestHandlerLogger.setLevel(Level.FATAL);
        List sentMessages = (List)TestUtils$.MODULE$.sendMessagesToPartition((Seq<KafkaConfig>)this.configs(), this.topic(), 0, this.nMessages(), (CompressionCodec)NoCompressionCodec$.MODULE$).$plus$plus(TestUtils$.MODULE$.sendMessagesToPartition((Seq<KafkaConfig>)this.configs(), this.topic(), 1, this.nMessages(), (CompressionCodec)NoCompressionCodec$.MODULE$), List$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        ConsumerConfig consumerConfig = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), this.group(), this.consumer1(), TestUtils$.MODULE$.createConsumerProperties$default$4()));
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        ZookeeperConsumerConnector zkConsumerConnector = new ZookeeperConsumerConnector(consumerConfig, true);
        Map topicMessageStreams = zkConsumerConnector.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        ObjectRef receivedMessages = new ObjectRef((Object)Nil$.MODULE$);
        topicMessageStreams.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, List<KafkaStream<String, String>>> check$ifrefutable$1) {
                Tuple2<String, List<KafkaStream<String, String>>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, receivedMessages){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZookeeperConsumerConnectorTest $outer;
            public final ObjectRef receivedMessages$1;

            public final void apply(Tuple2<String, List<KafkaStream<String, String>>> x$1) {
                Tuple2<String, List<KafkaStream<String, String>>> tuple2 = x$1;
                if (tuple2 != null) {
                    List messageStreams = (List)tuple2._2();
                    messageStreams.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testConsumerDecoder$2 $outer;

                        public final void apply(KafkaStream<String, String> messageStream) {
                            ConsumerIterator iterator = messageStream.iterator();
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$consumer$ZookeeperConsumerConnectorTest$$anonfun$$$outer().nMessages() * 2).foreach$mVc$sp((Function1)new Serializable(this, iterator){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$testConsumerDecoder$2$$anonfun$apply$2 $outer;
                                private final ConsumerIterator iterator$1;

                                public final void apply(int i) {
                                    this.apply$mcVI$sp(i);
                                }

                                public void apply$mcVI$sp(int i) {
                                    Assert.assertTrue((boolean)this.iterator$1.hasNext());
                                    String message = (String)this.iterator$1.next().message();
                                    this.$outer.kafka$consumer$ZookeeperConsumerConnectorTest$$anonfun$$anonfun$$$outer().receivedMessages$1.elem = ((List)this.$outer.kafka$consumer$ZookeeperConsumerConnectorTest$$anonfun$$anonfun$$$outer().receivedMessages$1.elem).$colon$colon((Object)message);
                                    this.$outer.kafka$consumer$ZookeeperConsumerConnectorTest$$anonfun$$anonfun$$$outer().kafka$consumer$ZookeeperConsumerConnectorTest$$anonfun$$$outer().debug((Function0<String>)new Serializable(this, message){
                                        public static final long serialVersionUID = 0L;
                                        private final String message$1;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)"received message: ").append((Object)this.message$1).toString();
                                        }
                                        {
                                            this.message$1 = message$1;
                                        }
                                    });
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.iterator$1 = iterator$1;
                                }
                            });
                        }

                        public /* synthetic */ $anonfun$testConsumerDecoder$2 kafka$consumer$ZookeeperConsumerConnectorTest$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ ZookeeperConsumerConnectorTest kafka$consumer$ZookeeperConsumerConnectorTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.receivedMessages$1 = receivedMessages$1;
            }
        });
        Assert.assertEquals((Object)sentMessages.sorted((Ordering)Ordering.String$.MODULE$), (Object)((List)receivedMessages.elem).sorted((Ordering)Ordering.String$.MODULE$));
        zkConsumerConnector.shutdown();
        requestHandlerLogger.setLevel(Level.ERROR);
    }

    public void testLeaderSelectionForPartition() {
        ZkClient zkClient = new ZkClient(this.zookeeperConnect(), 6000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
        TestUtils$.MODULE$.createTopic(zkClient, this.topic(), 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        List<String> sentMessages1 = TestUtils$.MODULE$.sendMessages((Seq<KafkaConfig>)this.configs(), this.topic(), "producer1", this.nMessages(), "batch1", (CompressionCodec)NoCompressionCodec$.MODULE$, 1);
        ConsumerConfig consumerConfig1 = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), this.group(), this.consumer1(), TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZookeeperConsumerConnector zkConsumerConnector1 = new ZookeeperConsumerConnector(consumerConfig1, true);
        Map topicMessageStreams1 = zkConsumerConnector1.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        Pool topicRegistry = zkConsumerConnector1.getTopicRegistry();
        Assert.assertEquals((int)1, (int)((TraversableOnce)topicRegistry.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Pool<Object, PartitionTopicInfo>> r) {
                return (String)r._1();
            }
        }, Iterable$.MODULE$.canBuildFrom())).size());
        Assert.assertEquals((String)this.topic(), (String)((String)((IterableLike)topicRegistry.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Pool<Object, PartitionTopicInfo>> r) {
                return (String)r._1();
            }
        }, Iterable$.MODULE$.canBuildFrom())).head()));
        Iterable topicsAndPartitionsInRegistry = (Iterable)topicRegistry.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Iterable<PartitionTopicInfo>> apply(Tuple2<String, Pool<Object, PartitionTopicInfo>> r) {
                return new Tuple2(r._1(), ((TraversableLike)r._2()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PartitionTopicInfo apply(Tuple2<Object, PartitionTopicInfo> p) {
                        return (PartitionTopicInfo)p._2();
                    }
                }, Iterable$.MODULE$.canBuildFrom()));
            }
        }, Iterable$.MODULE$.canBuildFrom());
        PartitionTopicInfo brokerPartition = (PartitionTopicInfo)((IterableLike)((Tuple2)topicsAndPartitionsInRegistry.head())._2()).head();
        Assert.assertEquals((int)0, (int)brokerPartition.partitionId());
        Seq<Tuple2<String, String>> actual_1 = this.getZKChildrenValues(this.dirs().consumerOwnerDir());
        List expected_1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"0", (Object)"group1_consumer1-0")}));
        Assert.assertEquals((Object)expected_1, actual_1);
        List<String> receivedMessages1 = TestUtils$.MODULE$.getMessages(this.nMessages(), (Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1);
        Assert.assertEquals(sentMessages1, receivedMessages1);
        zkConsumerConnector1.shutdown();
        zkClient.close();
    }

    public Seq<Tuple2<String, String>> getZKChildrenValues(String path) {
        java.util.List children = this.zkClient().getChildren(path);
        Collections.sort(children);
        Seq childrenAsSeq = JavaConversions$.MODULE$.asScalaBuffer(children).toSeq();
        return (Seq)childrenAsSeq.map((Function1)new Serializable(this, path){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZookeeperConsumerConnectorTest $outer;
            private final String path$1;

            public final Tuple2<String, String> apply(String partition) {
                return new Tuple2((Object)partition, (Object)((String)this.$outer.zkClient().readData(new StringBuilder().append((Object)this.path$1).append((Object)"/").append((Object)partition).toString())));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.path$1 = path$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public ZookeeperConsumerConnectorTest() {
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.RebalanceBackoffMs = 5000;
        this.dirs = null;
        this.zookeeperConnect = TestZKUtils$.MODULE$.zookeeperConnect();
        this.numNodes = 2;
        this.numParts = 2;
        this.topic = "topic1";
        this.configs = (List)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), TestUtils$.MODULE$.createBrokerConfigs$default$2()).map((Function1)new $anonfun$1(this), List$.MODULE$.canBuildFrom());
        this.group = "group1";
        this.consumer0 = "consumer0";
        this.consumer1 = "consumer1";
        this.consumer2 = "consumer2";
        this.consumer3 = "consumer3";
        this.nMessages = 2;
    }
}

