/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.util.Properties;
import junit.framework.Assert;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.serializer.StringEncoder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZKGroupTopicDirs;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u0001\u001d\u00111#Q;u_>3gm]3u%\u0016\u001cX\r\u001e+fgRT!a\u0001\u0003\u0002\u0017%tG/Z4sCRLwN\u001c\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\t%Y\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\f\u0015Vs\u0017\u000e^\u001aTk&$X\r\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\t\u0005)Q\u000f^5mg&\u00111\u0004\u0007\u0002\b\u0019><w-\u001b8h\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002\u0014\u0001!9\u0011\u0005\u0001b\u0001\n\u0003\u0011\u0013aB2p]\u001aLwm]\u000b\u0002GA\u0019AeK\u0017\u000e\u0003\u0015R!AJ\u0014\u0002\u0013%lW.\u001e;bE2,'B\u0001\u0015*\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002U\u0005)1oY1mC&\u0011A&\n\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002/c5\tqF\u0003\u00021\t\u000511/\u001a:wKJL!AM\u0018\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\u0007i\u0001\u0001\u000b\u0011B\u0012\u0002\u0011\r|gNZ5hg\u0002BqA\u000e\u0001C\u0002\u0013\u0005q'A\u0003u_BL7-F\u00019!\tId(D\u0001;\u0015\tYD(\u0001\u0003mC:<'\"A\u001f\u0002\t)\fg/Y\u0005\u0003\u007fi\u0012aa\u0015;sS:<\u0007BB!\u0001A\u0003%\u0001(\u0001\u0004u_BL7\r\t\u0005\b\u0007\u0002\u0011\r\u0011\"\u00018\u0003\u00159'o\\;q\u0011\u0019)\u0005\u0001)A\u0005q\u00051qM]8va\u0002Bqa\u0012\u0001C\u0002\u0013\u0005q'\u0001\u0007uKN$8i\u001c8tk6,'\u000f\u0003\u0004J\u0001\u0001\u0006I\u0001O\u0001\u000ei\u0016\u001cHoQ8ogVlWM\u001d\u0011\t\u000f-\u0003!\u0019!C\u0001\u0019\u0006Ya*^7NKN\u001c\u0018mZ3t+\u0005i\u0005C\u0001(P\u001b\u0005I\u0013B\u0001)*\u0005\rIe\u000e\u001e\u0005\u0007%\u0002\u0001\u000b\u0011B'\u0002\u00199+X.T3tg\u0006<Wm\u001d\u0011\t\u000fQ\u0003!\u0019!C\u0001\u0019\u0006YA*\u0019:hK>3gm]3u\u0011\u00191\u0006\u0001)A\u0005\u001b\u0006aA*\u0019:hK>3gm]3uA!9\u0001\f\u0001b\u0001\n\u0003a\u0015aC*nC2dwJ\u001a4tKRDaA\u0017\u0001!\u0002\u0013i\u0015\u0001D*nC2dwJ\u001a4tKR\u0004\u0003b\u0002/\u0001\u0005\u0004%\t!X\u0001\u0015e\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0019><w-\u001a:\u0016\u0003y\u0003\"a\u00183\u000e\u0003\u0001T!!\u00192\u0002\u000b1|w\r\u000e6\u000b\u0005\rt\u0011AB1qC\u000eDW-\u0003\u0002fA\n1Aj\\4hKJDaa\u001a\u0001!\u0002\u0013q\u0016!\u0006:fcV,7\u000f\u001e%b]\u0012dWM\u001d'pO\u001e,'\u000f\t\u0005\u0006S\u0002!\tE[\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002WB\u0011a\n\\\u0005\u0003[&\u0012A!\u00168ji\")q\u000e\u0001C!U\u0006AA/Z1s\t><h\u000eC\u0003r\u0001\u0011\u0005!.\u0001\u0013uKN$(+Z:fiR{W)\u0019:mS\u0016\u001cHo\u00165f]>3gm]3u)>|\u0007*[4iQ\t\u00018\u000f\u0005\u0002um6\tQO\u0003\u0002\f\u001d%\u0011q/\u001e\u0002\u0005)\u0016\u001cH\u000fC\u0003z\u0001\u0011\u0005!.A\u0012uKN$(+Z:fiR{W)\u0019:mS\u0016\u001cHo\u00165f]>3gm]3u)>|Gj\\<)\u0005a\u001c\b\"\u0002?\u0001\t\u0003Q\u0017A\t;fgR\u0014Vm]3u)>d\u0015\r^3ti^CWM\\(gMN,G\u000fV8p\u0011&<\u0007\u000e\u000b\u0002|g\")q\u0010\u0001C\u0001U\u0006\tC/Z:u%\u0016\u001cX\r\u001e+p\u0019\u0006$Xm\u001d;XQ\u0016twJ\u001a4tKR$vn\u001c'po\"\u0012ap\u001d\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0003=\u0011Xm]3u\u0003:$7i\u001c8tk6,GcB'\u0002\n\u00055\u0011Q\u0004\u0005\b\u0003\u0017\t\u0019\u00011\u0001N\u0003-qW/\\'fgN\fw-Z:\t\u0011\u0005=\u00111\u0001a\u0001\u0003#\tqA]3tKR$v\u000e\u0005\u0003\u0002\u0014\u0005eab\u0001(\u0002\u0016%\u0019\u0011qC\u0015\u0002\rA\u0013X\rZ3g\u0013\ry\u00141\u0004\u0006\u0004\u0003/I\u0003\u0002CA\u0010\u0003\u0007\u0001\r!!\t\u0002\r=4gm]3u!\rq\u00151E\u0005\u0004\u0003KI#\u0001\u0002'p]\u001e\u0004")
public class AutoOffsetResetTest
extends JUnit3Suite
implements KafkaServerTestHarness,
Logging {
    private final List<KafkaConfig> configs;
    private final String topic;
    private final String group;
    private final String testConsumer;
    private final int NumMessages;
    private final int LargeOffset;
    private final int SmallOffset;
    private final Logger requestHandlerLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private List<KafkaServer> servers;
    private String brokerList;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AutoOffsetResetTest autoOffsetResetTest = this;
        synchronized (autoOffsetResetTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Override
    public List<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(List<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public List<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public String group() {
        return this.group;
    }

    public String testConsumer() {
        return this.testConsumer;
    }

    public int NumMessages() {
        return this.NumMessages;
    }

    public int LargeOffset() {
        return this.LargeOffset;
    }

    public int SmallOffset() {
        return this.SmallOffset;
    }

    public Logger requestHandlerLogger() {
        return this.requestHandlerLogger;
    }

    @Override
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
        this.requestHandlerLogger().setLevel(Level.FATAL);
    }

    @Override
    public void tearDown() {
        this.requestHandlerLogger().setLevel(Level.ERROR);
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Test
    public void testResetToEarliestWhenOffsetTooHigh() {
        Assert.assertEquals((int)this.NumMessages(), (int)this.resetAndConsume(this.NumMessages(), "smallest", this.LargeOffset()));
    }

    @Test
    public void testResetToEarliestWhenOffsetTooLow() {
        Assert.assertEquals((int)this.NumMessages(), (int)this.resetAndConsume(this.NumMessages(), "smallest", this.SmallOffset()));
    }

    @Test
    public void testResetToLatestWhenOffsetTooHigh() {
        Assert.assertEquals((int)0, (int)this.resetAndConsume(this.NumMessages(), "largest", this.LargeOffset()));
    }

    @Test
    public void testResetToLatestWhenOffsetTooLow() {
        Assert.assertEquals((int)0, (int)this.resetAndConsume(this.NumMessages(), "largest", this.SmallOffset()));
    }

    public int resetAndConsume(int numMessages, String resetTo, long offset) {
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)this.configs());
        String x$2 = StringEncoder.class.getName();
        String x$3 = TestUtils$.MODULE$.createProducer$default$2();
        String x$4 = TestUtils$.MODULE$.createProducer$default$4();
        Properties x$5 = TestUtils$.MODULE$.createProducer$default$5();
        Producer producer = TestUtils$.MODULE$.createProducer(x$1, x$3, x$2, x$4, x$5);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, producer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AutoOffsetResetTest $outer;
            private final Producer producer$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.producer$1.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(this.$outer.topic(), (Object)this.$outer.topic(), (Object)"test".getBytes())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.producer$1 = producer$1;
            }
        });
        ZKGroupTopicDirs dirs = new ZKGroupTopicDirs(this.group(), this.topic());
        Properties consumerProps = TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), this.group(), this.testConsumer(), TestUtils$.MODULE$.createConsumerProperties$default$4());
        consumerProps.put("auto.offset.reset", resetTo);
        consumerProps.put("consumer.timeout.ms", "2000");
        consumerProps.put("fetch.wait.max.ms", "0");
        ConsumerConfig consumerConfig = new ConsumerConfig(consumerProps);
        TestUtils$.MODULE$.updateConsumerOffset(consumerConfig, new StringBuilder().append((Object)dirs.consumerOffsetDir()).append((Object)"/").append((Object)"0").toString(), offset);
        this.info((Function0<String>)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final long offset$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Updated consumer offset to ").append((Object)BoxesRunTime.boxToLong((long)this.offset$1)).toString();
            }
            {
                this.offset$1 = offset$1;
            }
        });
        ConsumerConnector consumerConnector = Consumer$.MODULE$.create(consumerConfig);
        KafkaStream messageStream = (KafkaStream)((IterableLike)consumerConnector.createMessageStreams((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))}))).apply((Object)this.topic())).head();
        IntRef received = new IntRef(0);
        ConsumerIterator iter = messageStream.iterator();
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, received, iter){
                public static final long serialVersionUID = 0L;
                private final IntRef received$1;
                private final ConsumerIterator iter$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.iter$1.next();
                    ++this.received$1.elem;
                }
                {
                    this.received$1 = received$1;
                    this.iter$1 = iter$1;
                }
            });
        }
        catch (ConsumerTimeoutException consumerTimeoutException) {
            this.info((Function0<String>)new Serializable(this, received){
                public static final long serialVersionUID = 0L;
                private final IntRef received$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"consumer timed out after receiving ").append((Object)BoxesRunTime.boxToInteger((int)this.received$1.elem)).append((Object)" messages.").toString();
                }
                {
                    this.received$1 = received$1;
                }
            });
        }
        finally {
            producer.close();
            consumerConnector.shutdown();
        }
        return received.elem;
    }

    public AutoOffsetResetTest() {
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.configs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{new KafkaConfig(TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.createBrokerConfig$default$2(), TestUtils$.MODULE$.createBrokerConfig$default$3()))}));
        this.topic = "test_topic";
        this.group = "default_group";
        this.testConsumer = "consumer";
        this.NumMessages = 10;
        this.LargeOffset = 10000;
        this.SmallOffset = -1;
        this.requestHandlerLogger = Logger.getLogger(KafkaRequestHandler.class);
    }
}

