/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import junit.framework.Assert;
import kafka.common.InvalidOffsetException;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.TestUtils$;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.Assertions;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.PendingNothing;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.TestRerunner;
import org.scalatest.Tracker;
import org.scalatest.junit.AssertionsForJUnit;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\u0001\u0003\u0001\u001d\u0011qb\u00144gg\u0016$\u0018J\u001c3fqR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!\u0001\u0002CA\u0005\u000f\u001b\u0005Q!BA\u0006\r\u0003\u0011a\u0017M\\4\u000b\u00035\tAA[1wC&\u0011qB\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005EAR\"\u0001\n\u000b\u0005M!\u0012!\u00026v]&$(BA\u000b\u0017\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0018\u0003\ry'oZ\u0005\u00033I\u0011!BS+oSR\u001cV/\u001b;f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0004!\u0001\u0001\u0007I\u0011A\u0011\u0002\u0007%$\u00070F\u0001#!\tq2%\u0003\u0002%\u0005\tYqJ\u001a4tKRLe\u000eZ3y\u0011\u001d1\u0003\u00011A\u0005\u0002\u001d\nq!\u001b3y?\u0012*\u0017\u000f\u0006\u0002)]A\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t!QK\\5u\u0011\u001dyS%!AA\u0002\t\n1\u0001\u001f\u00132\u0011\u0019\t\u0004\u0001)Q\u0005E\u0005!\u0011\u000e\u001a=!\u0011\u001d\u0019\u0004A1A\u0005\u0002Q\n!\"\\1y\u000b:$(/[3t+\u0005)\u0004CA\u00157\u0013\t9$FA\u0002J]RDa!\u000f\u0001!\u0002\u0013)\u0014aC7bq\u0016sGO]5fg\u0002BQa\u000f\u0001\u0005\u0002q\nQa]3ukB$\u0012\u0001\u000b\u0015\u0003uy\u0002\"aP!\u000e\u0003\u0001S!a\u0005\f\n\u0005\t\u0003%A\u0002\"fM>\u0014X\rC\u0003E\u0001\u0011\u0005A(\u0001\u0005uK\u0006\u0014Hm\\<oQ\t\u0019e\t\u0005\u0002@\u000f&\u0011\u0001\n\u0011\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0006\u0015\u0002!\t\u0001P\u0001\u0011e\u0006tGm\\7M_>\\W\u000f\u001d+fgRD#!\u0013'\u0011\u0005}j\u0015B\u0001(A\u0005\u0011!Vm\u001d;\t\u000bA\u0003A\u0011\u0001\u001f\u0002%1|wn[;q\u000bb$(/Z7f\u0007\u0006\u001cXm\u001d\u0015\u0003\u001f2CQa\u0015\u0001\u0005\u0002q\nQ\"\u00199qK:$Gk\\8NC:L\bF\u0001*M\u0011\u00151\u0006\u0001\"\u0001=\u0003A\t\u0007\u000f]3oI>+Ho\u00144Pe\u0012,'\u000f\u000b\u0003V\u0019bK\u0016\u0001C3ya\u0016\u001cG/\u001a3$\u0003i\u0003\"a\u00170\u000e\u0003qS!!\u0018\u0003\u0002\r\r|W.\\8o\u0013\tyFL\u0001\fJ]Z\fG.\u001b3PM\u001a\u001cX\r^#yG\u0016\u0004H/[8o\u0011\u0015\t\u0007\u0001\"\u0001=\u0003)!Xm\u001d;SK>\u0004XM\u001c\u0015\u0003A2CQ\u0001\u001a\u0001\u0005\u0002q\n\u0001\u0002\u001e:v]\u000e\fG/\u001a\u0015\u0003G2CQa\u001a\u0001\u0005\u0002!\f\u0001#Y:tKJ$xK]5uK\u001a\u000b\u0017\u000e\\:\u0016\u0005%lH#\u0002\u0015kgR4\b\"B6g\u0001\u0004a\u0017aB7fgN\fw-\u001a\t\u0003[Bt!!\u000b8\n\u0005=T\u0013A\u0002)sK\u0012,g-\u0003\u0002re\n11\u000b\u001e:j]\u001eT!a\u001c\u0016\t\u000b\u00012\u0007\u0019\u0001\u0012\t\u000bU4\u0007\u0019A\u001b\u0002\r=4gm]3u\u0011\u00159h\r1\u0001y\u0003\u0015YG.Y:t!\ri\u0017p_\u0005\u0003uJ\u0014Qa\u00117bgN\u0004\"\u0001`?\r\u0001\u0011)aP\u001ab\u0001\u007f\n\tA+\u0005\u0003\u0002\u0002\u0005\u001d\u0001cA\u0015\u0002\u0004%\u0019\u0011Q\u0001\u0016\u0003\u000f9{G\u000f[5oOB\u0019\u0011&!\u0003\n\u0007\u0005-!FA\u0002B]fDq!a\u0004\u0001\t\u0003\t\t\"\u0001\u0007n_:|Go\u001c8jGN+\u0017\u000f\u0006\u0004\u0002\u0014\u0005}\u00111\u0005\t\u0006\u0003+\tY\"N\u0007\u0003\u0003/Q1!!\u0007+\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003;\t9BA\u0002TKFDq!!\t\u0002\u000e\u0001\u0007Q'\u0001\u0003cCN,\u0007bBA\u0013\u0003\u001b\u0001\r!N\u0001\u0004Y\u0016t\u0007bBA\u0015\u0001\u0011\u0005\u00111F\u0001\u0014]>tW\t_5ti\u0006tG\u000fV3na\u001aKG.\u001a\u000b\u0003\u0003[\u0001B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003ga\u0011AA5p\u0013\u0011\t9$!\r\u0003\t\u0019KG.\u001a")
public class OffsetIndexTest
implements JUnitSuite {
    private OffsetIndex idx;
    private final int maxEntries;
    private volatile Tracker org$scalatest$junit$JUnitSuite$$theTracker;
    private final String styleName;

    public Tracker org$scalatest$junit$JUnitSuite$$theTracker() {
        return this.org$scalatest$junit$JUnitSuite$$theTracker;
    }

    public void org$scalatest$junit$JUnitSuite$$theTracker_$eq(Tracker x$1) {
        this.org$scalatest$junit$JUnitSuite$$theTracker = x$1;
    }

    public final String styleName() {
        return this.styleName;
    }

    public final void org$scalatest$junit$JUnitSuite$_setter_$styleName_$eq(String x$1) {
        this.styleName = x$1;
    }

    public final void withFixture(Suite.NoArgTest test) {
        JUnitSuite.class.withFixture((JUnitSuite)this, (Suite.NoArgTest)test);
    }

    public final void runNestedSuites(Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runNestedSuites((JUnitSuite)this, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTests(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runTests((JUnitSuite)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        JUnitSuite.class.runTest((JUnitSuite)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    public Set<String> testNames() {
        return JUnitSuite.class.testNames((JUnitSuite)this);
    }

    public int expectedTestCount(Filter filter) {
        return JUnitSuite.class.expectedTestCount((JUnitSuite)this, (Filter)filter);
    }

    public Map<String, Set<String>> tags() {
        return JUnitSuite.class.tags((JUnitSuite)this);
    }

    public void run(Option<String> testName, Reporter report, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.run((JUnitSuite)this, testName, (Reporter)report, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public Throwable newAssertionFailedException(Option<Object> optionalMessage, Option<Throwable> optionalCause, int stackDepth) {
        return AssertionsForJUnit.class.newAssertionFailedException((AssertionsForJUnit)this, optionalMessage, optionalCause, (int)stackDepth);
    }

    public void org$scalatest$Suite$_setter_$styleName_$eq(String x$1) {
    }

    public List<Suite> nestedSuites() {
        return Suite.class.nestedSuites((Suite)this);
    }

    public final void execute(String testName, Map<String, Object> configMap, boolean color, boolean durations, boolean shortstacks, boolean fullstacks, boolean stats) {
        Suite.class.execute((Suite)this, (String)testName, configMap, (boolean)color, (boolean)durations, (boolean)shortstacks, (boolean)fullstacks, (boolean)stats);
    }

    public Method getMethodForTestName(String testName) {
        return Suite.class.getMethodForTestName((Suite)this, (String)testName);
    }

    public Tuple6<Stopper, Reporter, Method, Object, Option<TestRerunner>, Object> getSuiteRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getSuiteRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public Tuple5<Stopper, Reporter, Object, Option<TestRerunner>, Object> getRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public void handleFailedTest(Throwable throwable, boolean hasPublicNoArgConstructor, String testName, Option<Rerunner> rerunnable, Reporter report, Tracker tracker, long duration) {
        Suite.class.handleFailedTest((Suite)this, (Throwable)throwable, (boolean)hasPublicNoArgConstructor, (String)testName, rerunnable, (Reporter)report, (Tracker)tracker, (long)duration);
    }

    public String suiteName() {
        return Suite.class.suiteName((Suite)this);
    }

    public PendingNothing pending() {
        return Suite.class.pending((Suite)this);
    }

    public void pendingUntilFixed(Function0<BoxedUnit> f) {
        Suite.class.pendingUntilFixed((Suite)this, f);
    }

    public Reporter wrapReporterIfNecessary(Reporter reporter) {
        return Suite.class.wrapReporterIfNecessary((Suite)this, (Reporter)reporter);
    }

    public final String execute$default$1() {
        return Suite.class.execute$default$1((Suite)this);
    }

    public final Map<String, Object> execute$default$2() {
        return Suite.class.execute$default$2((Suite)this);
    }

    public final boolean execute$default$3() {
        return Suite.class.execute$default$3((Suite)this);
    }

    public final boolean execute$default$4() {
        return Suite.class.execute$default$4((Suite)this);
    }

    public final boolean execute$default$5() {
        return Suite.class.execute$default$5((Suite)this);
    }

    public final boolean execute$default$6() {
        return Suite.class.execute$default$6((Suite)this);
    }

    public final boolean execute$default$7() {
        return Suite.class.execute$default$7((Suite)this);
    }

    public void assert(boolean condition) {
        Assertions.class.assert((Assertions)this, (boolean)condition);
    }

    public void assert(boolean condition, Object clue) {
        Assertions.class.assert((Assertions)this, (boolean)condition, (Object)clue);
    }

    public void assert(Option<String> o, Object clue) {
        Assertions.class.assert((Assertions)this, o, (Object)clue);
    }

    public void assert(Option<String> o) {
        Assertions.class.assert((Assertions)this, o);
    }

    public Assertions.Equalizer convertToEqualizer(Object left) {
        return Assertions.class.convertToEqualizer((Assertions)this, (Object)left);
    }

    public <T> T intercept(Function0<Object> f, Manifest<T> manifest) {
        return (T)Assertions.class.intercept((Assertions)this, f, manifest);
    }

    public void expectResult(Object expected, Object clue, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expect(Object expected, Object clue, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expectResult(Object expected, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)actual);
    }

    public void expect(Object expected, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)actual);
    }

    public Nothing$ fail() {
        return Assertions.class.fail((Assertions)this);
    }

    public Nothing$ fail(String message) {
        return Assertions.class.fail((Assertions)this, (String)message);
    }

    public Nothing$ fail(String message, Throwable cause) {
        return Assertions.class.fail((Assertions)this, (String)message, (Throwable)cause);
    }

    public Nothing$ fail(Throwable cause) {
        return Assertions.class.fail((Assertions)this, (Throwable)cause);
    }

    public <T> T withClue(Object clue, Function0<T> fun) {
        return (T)Assertions.class.withClue((Assertions)this, (Object)clue, fun);
    }

    public OffsetIndex idx() {
        return this.idx;
    }

    public void idx_$eq(OffsetIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    @Before
    public void setup() {
        this.idx_$eq(new OffsetIndex(this.nonExistantTempFile(), 45L, 240));
    }

    @After
    public void teardown() {
        if (this.idx() != null) {
            this.idx().file().delete();
        }
    }

    @Test
    public void randomLookupTest() {
        Assert.assertEquals((String)"Not present value should return physical offset 0.", (Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(92L));
        int base = (int)this.idx().baseOffset() + 1;
        int size = this.idx().maxEntries();
        Seq vals = (Seq)((IterableLike)this.monotonicSeq(base, size).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(int x$1) {
                return this.apply$mcJI$sp(x$1);
            }

            public long apply$mcJI$sp(int x$1) {
                return x$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).zip(this.monotonicSeq(0, size), Seq$.MODULE$.canBuildFrom());
        vals.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;

            public final void apply(Tuple2<Object, Object> x) {
                this.$outer.idx().append(x._1$mcJ$sp(), x._2$mcI$sp());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        vals.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;

            public final void apply(Tuple2<Object, Object> x$2) {
                Tuple2<Object, Object> tuple2 = x$2;
                if (tuple2 != null) {
                    long logical = tuple2._1$mcJ$sp();
                    int physical = tuple2._2$mcI$sp();
                    Assert.assertEquals((String)"Should be able to find values that are present.", (Object)new OffsetPosition(logical, physical), (Object)this.$outer.idx().lookup(logical));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        TreeMap valMap = new TreeMap((Ordering)Ordering.Long$.MODULE$).$plus$plus((GenTraversableOnce)vals.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<Object, Object>> apply(Tuple2<Object, Object> p) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)p._1$mcJ$sp()), p);
            }
        }, Seq$.MODULE$.canBuildFrom()));
        long[] offsets = (long[])new RichLong(Predef$.MODULE$.longWrapper(this.idx().baseOffset())).until((Object)BoxesRunTime.boxToLong((long)((int)((Tuple2)vals.last())._1$mcJ$sp()))).toArray(ClassTag$.MODULE$.Long());
        Collections.shuffle(Arrays.asList((Object[])new long[][]{offsets}));
        Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps(offsets).take(30)).foreach((Function1)new Serializable(this, valMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;
            private final TreeMap valMap$1;

            public final void apply(long offset) {
                this.apply$mcVJ$sp(offset);
            }

            public void apply$mcVJ$sp(long offset) {
                OffsetPosition rightAnswer = offset < BoxesRunTime.unboxToLong((Object)this.valMap$1.firstKey()) ? new OffsetPosition(this.$outer.idx().baseOffset(), 0) : new OffsetPosition(this.valMap$1.to((Object)BoxesRunTime.boxToLong((long)offset)).last()._1$mcJ$sp(), ((Tuple2)this.valMap$1.to((Object)BoxesRunTime.boxToLong((long)offset)).last()._2())._2$mcI$sp());
                Assert.assertEquals((String)"The index should give the same answer as the sorted map", (Object)rightAnswer, (Object)this.$outer.idx().lookup(offset));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.valMap$1 = valMap$1;
            }
        });
    }

    @Test
    public void lookupExtremeCases() {
        Assert.assertEquals((String)"Lookup on empty file", (Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.idx().append(this.$outer.idx().baseOffset() + (long)i + 1L, i);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        Assert.assertEquals((Object)new OffsetPosition(this.idx().baseOffset() + (long)this.idx().maxEntries(), this.idx().maxEntries() - 1), (Object)this.idx().lookup(this.idx().baseOffset() + (long)this.idx().maxEntries()));
    }

    @Test
    public void appendTooMany() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                long offset = this.$outer.idx().baseOffset() + (long)i + 1L;
                this.$outer.idx().append(offset, i);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.assertWriteFails("Append should fail on a full index", this.idx(), this.idx().maxEntries() + 1, IllegalArgumentException.class);
    }

    @Test(expected=InvalidOffsetException.class)
    public void appendOutOfOrder() {
        this.idx().append(51L, 0);
        this.idx().append(50L, 1);
    }

    @Test
    public void testReopen() {
        OffsetPosition first = new OffsetPosition(51L, 0);
        OffsetPosition sec = new OffsetPosition(52L, 1);
        this.idx().append(first.offset(), first.position());
        this.idx().append(sec.offset(), sec.position());
        this.idx().close();
        OffsetIndex idxRo = new OffsetIndex(this.idx().file(), this.idx().baseOffset(), OffsetIndex$.MODULE$.$lessinit$greater$default$3());
        Assert.assertEquals((Object)first, (Object)idxRo.lookup(first.offset()));
        Assert.assertEquals((Object)sec, (Object)idxRo.lookup(sec.offset()));
        Assert.assertEquals((long)sec.offset(), (long)idxRo.lastOffset());
        Assert.assertEquals((int)2, (int)idxRo.entries());
        this.assertWriteFails("Append should fail on read-only index", idxRo, 53, IllegalArgumentException.class);
    }

    @Test
    public void truncate() {
        OffsetIndex idx = new OffsetIndex(this.nonExistantTempFile(), 0L, 80);
        idx.truncate();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)new Serializable(this, idx){
            public static final long serialVersionUID = 0L;
            private final OffsetIndex idx$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.idx$1.append((long)i, i);
            }
            {
                this.idx$1 = idx$1;
            }
        });
        idx.truncateTo(12L);
        Assert.assertEquals((String)"Index should be unchanged by truncate past the end", (Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"9 should be the last entry in the index", (long)9L, (long)idx.lastOffset());
        idx.append(10L, 10);
        idx.truncateTo(10L);
        Assert.assertEquals((String)"Index should be unchanged by truncate at the end", (Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"9 should be the last entry in the index", (long)9L, (long)idx.lastOffset());
        idx.append(10L, 10);
        idx.truncateTo(9L);
        Assert.assertEquals((String)"Index should truncate off last entry", (Object)new OffsetPosition(8L, 8), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"8 should be the last entry in the index", (long)8L, (long)idx.lastOffset());
        idx.append(9L, 9);
        idx.truncateTo(5L);
        Assert.assertEquals((String)"4 should be the last entry in the index", (Object)new OffsetPosition(4L, 4), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"4 should be the last entry in the index", (long)4L, (long)idx.lastOffset());
        idx.append(5L, 5);
        idx.truncate();
        Assert.assertEquals((String)"Full truncation should leave no entries", (int)0, (int)idx.entries());
        idx.append(0L, 0);
    }

    public <T> void assertWriteFails(String message, OffsetIndex idx, int offset, Class<T> klass) {
        try {
            idx.append((long)offset, 1);
            throw this.fail(message);
        }
        catch (Exception exception) {
            Assert.assertEquals((String)"Got an unexpected exception.", klass, exception.getClass());
            return;
        }
    }

    public Seq<Object> monotonicSeq(int base, int len) {
        Random rand = new Random(1L);
        ArrayBuffer vals = new ArrayBuffer(len);
        IntRef last = new IntRef(base);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).foreach((Function1)new Serializable(this, rand, vals, last){
            public static final long serialVersionUID = 0L;
            private final Random rand$1;
            private final ArrayBuffer vals$1;
            private final IntRef last$1;

            public final ArrayBuffer<Object> apply(int i) {
                this.last$1.elem += this.rand$1.nextInt(15) + 1;
                return this.vals$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.last$1.elem));
            }
            {
                this.rand$1 = rand$1;
                this.vals$1 = vals$1;
                this.last$1 = last$1;
            }
        });
        return vals;
    }

    /*
     * WARNING - void declaration
     */
    public File nonExistantTempFile() {
        void var1_1;
        File file = TestUtils$.MODULE$.tempFile();
        file.delete();
        return var1_1;
    }

    public OffsetIndexTest() {
        Assertions.class.$init$((Assertions)this);
        Suite.class.$init$((Suite)this);
        AssertionsForJUnit.class.$init$((AssertionsForJUnit)this);
        JUnitSuite.class.$init$((JUnitSuite)this);
        this.idx = null;
        this.maxEntries = 30;
    }
}

