/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import junit.framework.Assert;
import kafka.cluster.Broker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.scalatest.junit.JUnit3Suite;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001A3A!\u0001\u0002\u0001\u000f\t\u0019\u0012\t\u001a<feRL7/\u001a\"s_.,'\u000fV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011I\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\f\u0015Vs\u0017\u000e^\u001aTk&$X\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005\u0011!p[\u0005\u0003/Q\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u001d\u0019\u0001\u00011A\u0005\u0002y)\u0012a\b\t\u00039\u0001J!!\t\u0002\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\bG\u0001\u0001\r\u0011\"\u0001%\u0003)\u0019XM\u001d<fe~#S-\u001d\u000b\u0003K-\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012A!\u00168ji\"9AFIA\u0001\u0002\u0004y\u0012a\u0001=%c!1a\u0006\u0001Q!\n}\tqa]3sm\u0016\u0014\b\u0005C\u00041\u0001\t\u0007I\u0011A\u0019\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012A\r\t\u0003MMJ!\u0001N\u0014\u0003\u0007%sG\u000f\u0003\u00047\u0001\u0001\u0006IAM\u0001\nEJ|7.\u001a:JI\u0002Bq\u0001\u000f\u0001C\u0002\u0013\u0005\u0011(\u0001\nbIZ,'\u000f^5tK\u0012Dun\u001d;OC6,W#\u0001\u001e\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014\u0001\u00027b]\u001eT\u0011aP\u0001\u0005U\u00064\u0018-\u0003\u0002By\t11\u000b\u001e:j]\u001eDaa\u0011\u0001!\u0002\u0013Q\u0014aE1em\u0016\u0014H/[:fI\"{7\u000f\u001e(b[\u0016\u0004\u0003bB#\u0001\u0005\u0004%\t!M\u0001\u000fC\u00124XM\u001d;jg\u0016$\u0007k\u001c:u\u0011\u00199\u0005\u0001)A\u0005e\u0005y\u0011\r\u001a<feRL7/\u001a3Q_J$\b\u0005C\u0003J\u0001\u0011\u0005#*A\u0003tKR,\u0006\u000fF\u0001&\u0011\u0015a\u0005\u0001\"\u0011K\u0003!!X-\u0019:E_^t\u0007\"\u0002(\u0001\t\u0003y\u0015a\u0006;fgR\u0014%o\\6fe\u0006#g/\u001a:uSN,Gk\u001c.L+\u0005)\u0003")
public class AdvertiseBrokerTest
extends JUnit3Suite
implements ZooKeeperTestHarness {
    private KafkaServer server;
    private final int brokerId;
    private final String advertisedHostName;
    private final int advertisedPort;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    public KafkaServer server() {
        return this.server;
    }

    public void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public String advertisedHostName() {
        return this.advertisedHostName;
    }

    public int advertisedPort() {
        return this.advertisedPort;
    }

    @Override
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), TestUtils$.MODULE$.choosePort(), TestUtils$.MODULE$.createBrokerConfig$default$3());
        props.put("advertised.host.name", this.advertisedHostName());
        props.put("advertised.port", ((Object)BoxesRunTime.boxToInteger((int)this.advertisedPort())).toString());
        this.server_$eq(TestUtils$.MODULE$.createServer(new KafkaConfig(props), TestUtils$.MODULE$.createServer$default$2()));
    }

    @Override
    public void tearDown() {
        this.server().shutdown();
        Utils$.MODULE$.rm(this.server().config().logDirs());
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public void testBrokerAdvertiseToZK() {
        Option brokerInfo = ZkUtils$.MODULE$.getBrokerInfo(this.zkClient(), this.brokerId());
        Assert.assertEquals((String)this.advertisedHostName(), (String)((Broker)brokerInfo.get()).host());
        Assert.assertEquals((int)this.advertisedPort(), (int)((Broker)brokerInfo.get()).port());
    }

    public AdvertiseBrokerTest() {
        ZooKeeperTestHarness$class.$init$(this);
        this.server = null;
        this.brokerId = 0;
        this.advertisedHostName = "routable-host";
        this.advertisedPort = 1234;
    }
}

