/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerEventManager;
import kafka.controller.ControllerState;
import kafka.controller.ControllerStats;
import kafka.controller.ControllerTestUtils$;
import kafka.utils.TestUtils$;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001\u000f\tQ2i\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'\u000fV3ti*\u00111\u0001B\u0001\u000bG>tGO]8mY\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001\"\u0003\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0016\u0003Y\u0019wN\u001c;s_2dWM]#wK:$X*\u00198bO\u0016\u0014X#\u0001\f\u0011\u0005I9\u0012B\u0001\r\u0003\u0005Y\u0019uN\u001c;s_2dWM]#wK:$X*\u00198bO\u0016\u0014\b\"\u0003\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u001c\u0003i\u0019wN\u001c;s_2dWM]#wK:$X*\u00198bO\u0016\u0014x\fJ3r)\tar\u0004\u0005\u0002\n;%\u0011aD\u0003\u0002\u0005+:LG\u000fC\u0004!3\u0005\u0005\t\u0019\u0001\f\u0002\u0007a$\u0013\u0007\u0003\u0004#\u0001\u0001\u0006KAF\u0001\u0018G>tGO]8mY\u0016\u0014XI^3oi6\u000bg.Y4fe\u0002BQ\u0001\n\u0001\u0005\u0002\u0015\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u00029!\u00121e\n\t\u0003Q5j\u0011!\u000b\u0006\u0003U-\nQA[;oSRT\u0011\u0001L\u0001\u0004_J<\u0017B\u0001\u0018*\u0005\u0015\te\r^3s\u0011\u0015\u0001\u0004\u0001\"\u0001&\u0003M!Xm\u001d;Tk\u000e\u001cWm]:gk2,e/\u001a8uQ\ty#\u0007\u0005\u0002)g%\u0011A'\u000b\u0002\u0005)\u0016\u001cH\u000fC\u00037\u0001\u0011\u0005Q%\u0001\u000fuKN$XI^3oiRC\u0017\r\u001e+ie><8/\u0012=dKB$\u0018n\u001c8)\u0005U\u0012\u0004\"B\u001d\u0001\t\u0013Q\u0014!B2iK\u000e\\G\u0003\u0002\u000f<\t&CQ\u0001\u0010\u001dA\u0002u\n!\"\\3ue&\u001cg*Y7f!\tq\u0014I\u0004\u0002\n\u007f%\u0011\u0001IC\u0001\u0007!J,G-\u001a4\n\u0005\t\u001b%AB*ue&twM\u0003\u0002A\u0015!)Q\t\u000fa\u0001\r\u0006y1m\u001c8ue>dG.\u001a:Ti\u0006$X\r\u0005\u0002\u0013\u000f&\u0011\u0001J\u0001\u0002\u0010\u0007>tGO]8mY\u0016\u00148\u000b^1uK\")!\n\u000fa\u0001\u0017\u00069\u0001O]8dKN\u001c\bcA\u0005M9%\u0011QJ\u0003\u0002\n\rVt7\r^5p]BBQa\u0014\u0001\u0005\nA\u000bQ\u0001^5nKJ$\"!U/\u0011\u0005I[V\"A*\u000b\u0005Q+\u0016\u0001B2pe\u0016T!AV,\u0002\u000f5,GO]5dg*\u0011\u0001,W\u0001\u0007s\u0006lW.\u001a:\u000b\u0003i\u000b1aY8n\u0013\ta6KA\u0003US6,'\u000fC\u0003=\u001d\u0002\u0007Q\b")
public class ControllerEventManagerTest {
    private ControllerEventManager kafka$controller$ControllerEventManagerTest$$controllerEventManager;

    public ControllerEventManager kafka$controller$ControllerEventManagerTest$$controllerEventManager() {
        return this.kafka$controller$ControllerEventManagerTest$$controllerEventManager;
    }

    private void kafka$controller$ControllerEventManagerTest$$controllerEventManager_$eq(ControllerEventManager x$1) {
        this.kafka$controller$ControllerEventManagerTest$$controllerEventManager = x$1;
    }

    @After
    public void tearDown() {
        if (this.kafka$controller$ControllerEventManagerTest$$controllerEventManager() != null) {
            this.kafka$controller$ControllerEventManagerTest$$controllerEventManager().close();
        }
    }

    @Test
    public void testSuccessfulEvent() {
        this.check("kafka.controller:type=ControllerStats,name=AutoLeaderBalanceRateAndTimeMs", (ControllerState)ControllerState.AutoLeaderBalance$.MODULE$, (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
            }
        });
    }

    @Test
    public void testEventThatThrowsException() {
        this.check("kafka.controller:type=ControllerStats,name=LeaderElectionRateAndTimeMs", (ControllerState)ControllerState.BrokerChange$.MODULE$, (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new NullPointerException();
            }
        });
    }

    private void check(String metricName, ControllerState controllerState, Function0<BoxedUnit> process) {
        ControllerStats controllerStats = new ControllerStats();
        AtomicInteger eventProcessedListenerCount = new AtomicInteger();
        this.kafka$controller$ControllerEventManagerTest$$controllerEventManager_$eq(new ControllerEventManager(controllerStats.rateAndTimeMetrics(), (Function1)new Serializable(this, eventProcessedListenerCount){
            public static final long serialVersionUID = 0L;
            private final AtomicInteger eventProcessedListenerCount$1;

            public final void apply(ControllerEvent x$1) {
                this.eventProcessedListenerCount$1.incrementAndGet();
            }
            {
                this.eventProcessedListenerCount$1 = eventProcessedListenerCount$1;
            }
        }));
        this.kafka$controller$ControllerEventManagerTest$$controllerEventManager().start();
        long initialTimerCount = this.timer(metricName).count();
        CountDownLatch latch = new CountDownLatch(1);
        ControllerEvent eventMock = ControllerTestUtils$.MODULE$.createMockControllerEvent(controllerState, (Function0<BoxedUnit>)new Serializable(this, process, latch){
            public static final long serialVersionUID = 0L;
            private final Function0 process$1;
            private final CountDownLatch latch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.latch$1.await();
                this.process$1.apply$mcV$sp();
            }
            {
                this.process$1 = process$1;
                this.latch$1 = latch$1;
            }
        });
        this.kafka$controller$ControllerEventManagerTest$$controllerEventManager().put(eventMock);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, controllerState){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerEventManagerTest $outer;
            private final ControllerState controllerState$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ControllerState controllerState = this.$outer.kafka$controller$ControllerEventManagerTest$$controllerEventManager().state();
                ControllerState controllerState2 = this.controllerState$1;
                return !(controllerState != null ? !controllerState.equals(controllerState2) : controllerState2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.controllerState$1 = controllerState$1;
            }
        }, (Function0<String>)new Serializable(this, controllerState){
            public static final long serialVersionUID = 0L;
            private final ControllerState controllerState$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller state is not ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.controllerState$1}));
            }
            {
                this.controllerState$1 = controllerState$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        latch.countDown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerEventManagerTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ControllerState controllerState = this.$outer.kafka$controller$ControllerEventManagerTest$$controllerEventManager().state();
                ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
                return !(controllerState != null ? !controllerState.equals(idle$) : idle$ != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Controller state has not changed back to Idle";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertEquals((long)1L, (long)eventProcessedListenerCount.get());
        Assert.assertEquals((String)"Timer has not been updated", (long)(initialTimerCount + 1L), (long)this.timer(metricName).count());
    }

    private Timer timer(String metricName) {
        return (Timer)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final String metricName$1;

            public final boolean apply(MetricName x$2) {
                String string = x$2.getMBeanName();
                String string2 = this.metricName$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.metricName$1 = metricName$1;
            }
        }).values().headOption().getOrElse((Function0)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final String metricName$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find metric ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metricName$1})));
            }
            {
                this.metricName$1 = metricName$1;
            }
        });
    }
}

