/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.log.Log;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.epoch.LeaderEpochCache;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#S:s\u000bb\u0004\u0018N]1uS>tG+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0001\r\u0011\"\u0001\u0016\u0003E!x\u000e]5d!\u0006\u0014H/\u001b;j_:L5O]\u000b\u0002-A!q\u0003\b\u0010,\u001b\u0005A\"BA\r\u001b\u0003\u001diW\u000f^1cY\u0016T!a\u0007\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\u001e1\t\u0019Q*\u00199\u0011\t%y\u0012\u0005K\u0005\u0003A)\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001\u0012&\u001d\tI1%\u0003\u0002%\u0015\u00051\u0001K]3eK\u001aL!AJ\u0014\u0003\rM#(/\u001b8h\u0015\t!#\u0002\u0005\u0002\nS%\u0011!F\u0003\u0002\u0004\u0013:$\bc\u0001\u00175Q9\u0011QF\r\b\u0003]Ej\u0011a\f\u0006\u0003a\u0019\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005MR\u0011a\u00029bG.\fw-Z\u0005\u0003kY\u00121aU3r\u0015\t\u0019$\u0002C\u00049\u0001\u0001\u0007I\u0011A\u001d\u0002+Q|\u0007/[2QCJ$\u0018\u000e^5p]&\u001b(o\u0018\u0013fcR\u0011!(\u0010\t\u0003\u0013mJ!\u0001\u0010\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b}]\n\t\u00111\u0001\u0017\u0003\rAH%\r\u0005\u0007\u0001\u0002\u0001\u000b\u0015\u0002\f\u0002%Q|\u0007/[2QCJ$\u0018\u000e^5p]&\u001b(\u000f\t\u0005\b\u0005\u0002\u0011\r\u0011\"\u0001D\u0003M\u0011X\r\u001d7jG\u0006d\u0015m\u001a+j[\u0016l\u0015\r_'t+\u0005!\u0005CA\u0005F\u0013\t1%B\u0001\u0003M_:<\u0007B\u0002%\u0001A\u0003%A)\u0001\u000bsKBd\u0017nY1MC\u001e$\u0016.\\3NCbl5\u000f\t\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001L\u0003U\u0011X\r\u001d7jG\u00064U\r^2i/\u0006LG/T1y\u001bN,\u0012\u0001\u000b\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002\u0015\u0002-I,\u0007\u000f\\5dC\u001a+Go\u00195XC&$X*\u0019=Ng\u0002Bqa\u0014\u0001C\u0002\u0013\u0005\u0001+A\bpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9t+\u0005\t\u0006C\u0001*X\u001b\u0005\u0019&B\u0001+V\u0003\u0011)H/\u001b7\u000b\u0003Y\u000bAA[1wC&\u0011\u0001l\u0015\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bB\u0002.\u0001A\u0003%\u0011+\u0001\tpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9tA!9A\f\u0001b\u0001\n\u0003i\u0016aB2p]\u001aLwm]\u000b\u0002=B\u0019q\fY1\u000e\u0003iI!!\u000e\u000e\u0011\u0005I\u0011\u0017BA2\u0003\u0005-Y\u0015MZ6b\u0007>tg-[4\t\r\u0015\u0004\u0001\u0015!\u0003_\u0003!\u0019wN\u001c4jON\u0004\u0003bB4\u0001\u0005\u0004%\t\u0001[\u0001\u0006i>\u0004\u0018nY\u000b\u0002SB\u0011!.\\\u0007\u0002W*\u0011A.V\u0001\u0005Y\u0006tw-\u0003\u0002'W\"1q\u000e\u0001Q\u0001\n%\fa\u0001^8qS\u000e\u0004\u0003bB9\u0001\u0005\u0004%\tA]\u0001\u0005i&lW-F\u0001t!\t!x/D\u0001v\u0015\t1H!A\u0003vi&d7/\u0003\u0002yk\nAQj\\2l)&lW\r\u0003\u0004{\u0001\u0001\u0006Ia]\u0001\u0006i&lW\r\t\u0005\by\u0002\u0011\r\u0011\"\u0001~\u0003\u001diW\r\u001e:jGN,\u0012A \t\u0004\u007f\u0006EQBAA\u0001\u0015\ra\u00181\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0004d_6lwN\u001c\u0006\u0004\u000b\u0005%!\u0002BA\u0006\u0003\u001b\ta!\u00199bG\",'BAA\b\u0003\ry'oZ\u0005\u0005\u0003'\t\tAA\u0004NKR\u0014\u0018nY:\t\u000f\u0005]\u0001\u0001)A\u0005}\u0006AQ.\u001a;sS\u000e\u001c\b\u0005C\u0005\u0002\u001c\u0001\u0001\r\u0011\"\u0001\u0002\u001e\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014XCAA\u0010!\r\u0011\u0012\u0011E\u0005\u0004\u0003G\u0011!A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\n\u0003O\u0001\u0001\u0019!C\u0001\u0003S\t!C]3qY&\u001c\u0017-T1oC\u001e,'o\u0018\u0013fcR\u0019!(a\u000b\t\u0013y\n)#!AA\u0002\u0005}\u0001\u0002CA\u0018\u0001\u0001\u0006K!a\b\u0002\u001fI,\u0007\u000f\\5dC6\u000bg.Y4fe\u0002Bq!a\r\u0001\t\u0003\t)$A\u0003tKR,\u0006\u000fF\u0001;Q\u0011\t\t$!\u000f\u0011\t\u0005m\u0012\u0011I\u0007\u0003\u0003{QA!a\u0010\u0002\u000e\u0005)!.\u001e8ji&!\u00111IA\u001f\u0005\u0019\u0011UMZ8sK\"9\u0011q\t\u0001\u0005\u0002\u0005U\u0012\u0001\u0003;fCJ$un\u001e8)\t\u0005\u0015\u00131\n\t\u0005\u0003w\ti%\u0003\u0003\u0002P\u0005u\"!B!gi\u0016\u0014\bbBA*\u0001\u0011\u0005\u0011QG\u0001#i\u0016\u001cH/S:s\u000bb\u0004\u0018N]1uS>tgi\u001c:TiV\u001c7NR8mY><XM]:)\t\u0005E\u0013q\u000b\t\u0005\u0003w\tI&\u0003\u0003\u0002\\\u0005u\"\u0001\u0002+fgRDq!a\u0018\u0001\t\u0003\t)$A\u0013uKN$\u0018j\u001d:FqBL'/\u0019;j_:LeMT8GKR\u001c\u0007NU3rk\u0016\u001cH/T1eK\"\"\u0011QLA,\u0011\u001d\t)\u0007\u0001C\u0001\u0003k\t\u0011\u0005^3ti&\u001b(/\u0012=qSJ\fG/[8o\r>\u00148\u000b\\8x\r>dGn\\<feNDC!a\u0019\u0002X!9\u00111\u000e\u0001\u0005\n\u00055\u0014\u0001I4fiB\u000b'\u000f^5uS>tw+\u001b;i\u00032d'+\u001a9mS\u000e\f7/\u00138JgJ$B\"a\u001c\u0002|\u0005u\u0014\u0011QAG\u0003#\u0003B!!\u001d\u0002x5\u0011\u00111\u000f\u0006\u0004\u0003k\"\u0011aB2mkN$XM]\u0005\u0005\u0003s\n\u0019HA\u0005QCJ$\u0018\u000e^5p]\"1q-!\u001bA\u0002\u0005Bq!a \u0002j\u0001\u0007\u0001&A\u0006qCJ$\u0018\u000e^5p]&#\u0007bB9\u0002j\u0001\u0007\u00111\u0011\t\u0005\u0003\u000b\u000bI)\u0004\u0002\u0002\b*\u0019a/a\u0001\n\t\u0005-\u0015q\u0011\u0002\u0005)&lW\rC\u0004\u0002\u0010\u0006%\u0004\u0019A1\u0002\r\r|gNZ5h\u0011!\t\u0019*!\u001bA\u0002\u0005U\u0015\u0001\u00037pG\u0006dGj\\4\u0011\t\u0005]\u0015QT\u0007\u0003\u00033S1!a'\u0005\u0003\rawnZ\u0005\u0005\u0003?\u000bIJA\u0002M_\u001eDq!a)\u0001\t\u0013\t)+A\u0004m_\u001elunY6\u0016\u0005\u0005U\u0005bBAU\u0001\u0011%\u00111V\u0001\u0014O\u0016$hi\u001c7m_^,'OU3qY&\u001c\u0017m\u001d\u000b\t\u0003[\u000b),!/\u0002>B!A\u0006NAX!\u0011\t\t(!-\n\t\u0005M\u00161\u000f\u0002\b%\u0016\u0004H.[2b\u0011!\t9,a*A\u0002\u0005=\u0014!\u00039beRLG/[8o\u0011\u001d\tY,a*A\u0002!\n\u0001\u0002\\3bI\u0016\u0014\u0018\n\u001a\u0005\bc\u0006\u001d\u0006\u0019AAB\u0001")
public class IsrExpirationTest {
    private Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr = new HashMap();
    private final long replicaLagTimeMaxMs;
    private final int replicaFetchWaitMaxMs;
    private final Properties overridingProps = new Properties();
    private final Seq<KafkaConfig> configs;
    private final String topic;
    private final MockTime time;
    private final Metrics metrics;
    private ReplicaManager replicaManager;

    public Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr() {
        return this.topicPartitionIsr;
    }

    public void topicPartitionIsr_$eq(Map<Tuple2<String, Object>, Seq<Object>> x$1) {
        this.topicPartitionIsr = x$1;
    }

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Before
    public void setUp() {
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), null, null, null, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time()).follower(), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), ReplicaManager$.MODULE$.$lessinit$greater$default$11()));
    }

    @After
    public void tearDown() {
        this.replicaManager().shutdown(false);
        this.metrics().close();
    }

    @Test
    public void testIsrExpirationForStuckFollowers() {
        Log log2 = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log2);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaConfig x$2) {
                return x$2.brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$3) {
                return x$3.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition0.getReplica(((KafkaConfig)this.configs().head()).brokerId()).get();
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsrExpirationTest $outer;

            public final void apply(Replica replica) {
                replica.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata(15L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), 15L, 0L, 15L, 0L, this.$outer.time().milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$4) {
                return x$4.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        this.time().sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$5) {
                return x$5.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        EasyMock.verify((Object[])new Object[]{log2});
    }

    @Test
    public void testIsrExpirationIfNoFetchRequestMade() {
        Log log2 = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log2);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaConfig x$6) {
                return x$6.brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$7) {
                return x$7.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition0.getReplica(((KafkaConfig)this.configs().head()).brokerId()).get();
        this.time().sleep(150L);
        Set partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$8) {
                return x$8.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        EasyMock.verify((Object[])new Object[]{log2});
    }

    @Test
    public void testIsrExpirationForSlowFollowers() {
        Log log2 = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log2);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaConfig x$9) {
                return x$9.brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$10) {
                return x$10.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition0.getReplica(((KafkaConfig)this.configs().head()).brokerId()).get();
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsrExpirationTest $outer;

            public final void apply(Replica replica) {
                replica.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), 10L, 0L, 15L, 0L, this.$outer.time().milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$11) {
                return x$11.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        this.time().sleep(75L);
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsrExpirationTest $outer;

            public final void apply(Replica r) {
                r.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata(11L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), 11L, 0L, 15L, 0L, this.$outer.time().milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$12) {
                return x$12.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        this.time().sleep(75L);
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$13) {
                return x$13.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsrExpirationTest $outer;

            public final void apply(Replica r) {
                r.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata(15L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), 15L, 0L, 15L, 0L, this.$outer.time().milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$14) {
                return x$14.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        EasyMock.verify((Object[])new Object[]{log2});
    }

    private Partition getPartitionWithAllReplicasInIsr(String topic, int partitionId, Time time, KafkaConfig config, Log localLog) {
        int leaderId = config.brokerId();
        TopicPartition tp = new TopicPartition(topic, partitionId);
        Partition partition = this.replicaManager().getOrCreatePartition(tp);
        Replica leaderReplica = new Replica(leaderId, tp, time, 0L, (Option)new Some((Object)localLog));
        Seq allReplicas = (Seq)this.getFollowerReplicas(partition, leaderId, time).$colon$plus((Object)leaderReplica, Seq$.MODULE$.canBuildFrom());
        allReplicas.foreach((Function1)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final Partition partition$1;

            public final Replica apply(Replica r) {
                return this.partition$1.addReplicaIfNotExists(r);
            }
            {
                this.partition$1 = partition$1;
            }
        });
        partition.inSyncReplicas_$eq(allReplicas.toSet());
        partition.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final Time time$1;

            public final void apply(Replica replica) {
                replica.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), 0L, 0L, 0L, 0L, this.time$1.milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            }
            {
                this.time$1 = time$1;
            }
        });
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderId)));
        return partition;
    }

    /*
     * WARNING - void declaration
     */
    private Log logMock() {
        void var1_1;
        Log log2 = (Log)EasyMock.createMock(Log.class);
        LeaderEpochCache cache = (LeaderEpochCache)EasyMock.createNiceMock(LeaderEpochCache.class);
        EasyMock.expect((Object)log2.dir()).andReturn((Object)TestUtils$.MODULE$.tempDir()).anyTimes();
        EasyMock.expect((Object)log2.leaderEpochCache()).andReturn((Object)cache).anyTimes();
        log2.onHighWatermarkIncremented(0L);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{log2});
        return var1_1;
    }

    private Seq<Replica> getFollowerReplicas(Partition partition, int leaderId, Time time) {
        return (Seq)((TraversableLike)this.configs().filter((Function1)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            public final boolean apply(KafkaConfig x$15) {
                return x$15.brokerId() != this.leaderId$1;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        })).map((Function1)new Serializable(this, partition, time){
            public static final long serialVersionUID = 0L;
            private final Partition partition$2;
            private final Time time$2;

            public final Replica apply(KafkaConfig config) {
                return new Replica(config.brokerId(), this.partition$2.topicPartition(), this.time$2, Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.partition$2 = partition$2;
                this.time$2 = time$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public IsrExpirationTest() {
        this.replicaLagTimeMaxMs = 100L;
        this.replicaFetchWaitMaxMs = 100;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.replicaLagTimeMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchWaitMaxMs())).toString());
        this.configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsrExpirationTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.topic = "foo";
        this.time = new MockTime();
        this.metrics = new Metrics();
        this.replicaManager = null;
    }
}

