/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.concurrent.BlockingQueue;
import kafka.common.KafkaException;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.QueueItem;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0001\u0003\u0001\u001d\u0011\u0011CU3rk\u0016\u001cHoU3oIRC'/Z1e\u0015\t\u0019A!\u0001\u0006d_:$(o\u001c7mKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!B\u0003\u0002\f\t\u0005)Q\u000f^5mg&\u0011QB\u0003\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG\r\u0003\u0005\u0010\u0001\t\u0015\r\u0011\"\u0001\u0011\u00031\u0019wN\u001c;s_2dWM]%e+\u0005\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"aA%oi\"A\u0001\u0004\u0001B\u0001B\u0003%\u0011#A\u0007d_:$(o\u001c7mKJLE\r\t\u0005\t5\u0001\u0011)\u0019!C\u00017\u0005\t2m\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0016\u0003q\u0001\"!\b\u0010\u000e\u0003\tI!a\b\u0002\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001d\u0003I\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0011\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\nQ!];fk\u0016,\u0012!\n\t\u0004M5zS\"A\u0014\u000b\u0005!J\u0013AC2p]\u000e,(O]3oi*\u0011!fK\u0001\u0005kRLGNC\u0001-\u0003\u0011Q\u0017M^1\n\u00059:#!\u0004\"m_\u000e\\\u0017N\\4Rk\u0016,X\r\u0005\u0002\u001ea%\u0011\u0011G\u0001\u0002\n#V,W/Z%uK6D\u0001b\r\u0001\u0003\u0002\u0003\u0006I!J\u0001\u0007cV,W/\u001a\u0011\t\u0011U\u0002!Q1A\u0005\u0002Y\nQB\\3uo>\u00148n\u00117jK:$X#A\u001c\u0011\u0005a\u0002U\"A\u001d\u000b\u0005iZ\u0014aB2mS\u0016tGo\u001d\u0006\u0003\u000bqR!!\u0010 \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0014aA8sO&\u0011\u0011)\u000f\u0002\u000e\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\t\u0011\r\u0003!\u0011!Q\u0001\n]\naB\\3uo>\u00148n\u00117jK:$\b\u0005\u0003\u0005F\u0001\t\u0015\r\u0011\"\u0001G\u0003)\u0011'o\\6fe:{G-Z\u000b\u0002\u000fB\u0011\u0001jS\u0007\u0002\u0013*\u0011!jO\u0001\u0007G>lWn\u001c8\n\u00051K%\u0001\u0002(pI\u0016D\u0001B\u0014\u0001\u0003\u0002\u0003\u0006IaR\u0001\fEJ|7.\u001a:O_\u0012,\u0007\u0005\u0003\u0005Q\u0001\t\u0015\r\u0011\"\u0001R\u0003\u0019\u0019wN\u001c4jOV\t!\u000b\u0005\u0002T-6\tAK\u0003\u0002V\t\u000511/\u001a:wKJL!a\u0016+\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\t3\u0002\u0011\t\u0011)A\u0005%\u000691m\u001c8gS\u001e\u0004\u0003\u0002C.\u0001\u0005\u000b\u0007I\u0011\u0001/\u0002\tQLW.Z\u000b\u0002;B\u0011a\fY\u0007\u0002?*\u00111\"S\u0005\u0003C~\u0013A\u0001V5nK\"A1\r\u0001B\u0001B\u0003%Q,A\u0003uS6,\u0007\u0005C\u0005f\u0001\t\u0005\t\u0015!\u0003gc\u0006!a.Y7f!\t9gN\u0004\u0002iYB\u0011\u0011nE\u0007\u0002U*\u00111NB\u0001\u0007yI|w\u000e\u001e \n\u00055\u001c\u0012A\u0002)sK\u0012,g-\u0003\u0002pa\n11\u000b\u001e:j]\u001eT!!\\\n\n\u0005\u0015d\u0001\"B:\u0001\t\u0003!\u0018A\u0002\u001fj]&$h\bF\u0005vm^D\u0018P_>}{B\u0011Q\u0004\u0001\u0005\u0006\u001fI\u0004\r!\u0005\u0005\u00065I\u0004\r\u0001\b\u0005\u0006GI\u0004\r!\n\u0005\u0006kI\u0004\ra\u000e\u0005\u0006\u000bJ\u0004\ra\u0012\u0005\u0006!J\u0004\rA\u0015\u0005\u00067J\u0004\r!\u0018\u0005\u0006KJ\u0004\rA\u001a\u0005\t\u007f\u0002\u0011\r\u0011\"\u0003\u0002\u0002\u0005\t2\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u0017q1!HA\u0004\u0013\r\tIAA\u0001\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe&!\u0011QBA\b\u0005E\u0019F/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0006\u0004\u0003\u0013\u0011\u0001\u0002CA\n\u0001\u0001\u0006I!a\u0001\u0002%M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'\u000f\t\u0005\t\u0003/\u0001!\u0019!C\u0005!\u0005y1o\\2lKR$\u0016.\\3pkRl5\u000fC\u0004\u0002\u001c\u0001\u0001\u000b\u0011B\t\u0002!M|7m[3u)&lWm\\;u\u001bN\u0004\u0003bBA\u0010\u0001\u0011\u0005\u0013\u0011E\u0001\u0007I><vN]6\u0015\u0005\u0005\r\u0002c\u0001\n\u0002&%\u0019\u0011qE\n\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003W\u0001A\u0011BA\u0017\u0003-\u0011'o\\6feJ+\u0017\rZ=\u0015\u0005\u0005=\u0002c\u0001\n\u00022%\u0019\u00111G\n\u0003\u000f\t{w\u000e\\3b]\u0002")
public class RequestSendThread
extends ShutdownableThread {
    private final int controllerId;
    private final ControllerContext controllerContext;
    private final BlockingQueue<QueueItem> queue;
    private final NetworkClient networkClient;
    private final Node brokerNode;
    private final KafkaConfig config;
    private final Time time;
    private final KafkaController.StateChangeLogger stateChangeLogger;
    private final int socketTimeoutMs;

    public int controllerId() {
        return this.controllerId;
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public BlockingQueue<QueueItem> queue() {
        return this.queue;
    }

    public NetworkClient networkClient() {
        return this.networkClient;
    }

    public Node brokerNode() {
        return this.brokerNode;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Time time() {
        return this.time;
    }

    private KafkaController.StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private int socketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    @Override
    public void doWork() {
        block11: {
            QueueItem queueItem = this.queue().take();
            if (queueItem == null) {
                throw new MatchError((Object)queueItem);
            }
            ApiKeys apiKey = queueItem.apiKey();
            AbstractRequest.Builder<? extends AbstractRequest> requestBuilder = queueItem.request();
            Function1<AbstractResponse, BoxedUnit> callback = queueItem.callback();
            Tuple3 tuple3 = new Tuple3((Object)apiKey, requestBuilder, callback);
            Tuple3 tuple32 = tuple3;
            ApiKeys apiKey2 = (ApiKeys)tuple32._1();
            AbstractRequest.Builder requestBuilder2 = (AbstractRequest.Builder)tuple32._2();
            Function1 callback2 = (Function1)tuple32._3();
            ClientResponse clientResponse = null;
            try {
                ApiKeys api;
                boolean isSendSuccessful = false;
                while (this.isRunning().get() && !isSendSuccessful) {
                    try {
                        if (!this.brokerReady()) {
                            isSendSuccessful = false;
                            RequestSendThread.backoff$1();
                            continue;
                        }
                        ClientRequest clientRequest = this.networkClient().newClientRequest(this.brokerNode().idString(), requestBuilder2, this.time().milliseconds(), true);
                        clientResponse = NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)clientRequest, (Time)this.time());
                        isSendSuccessful = true;
                    }
                    catch (Throwable e) {
                        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d fails to send request %s to broker %s. Reconnecting to broker.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.controllerContext().epoch()), requestBuilder2.toString(), this.brokerNode().toString()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        this.networkClient().close(this.brokerNode().idString());
                        isSendSuccessful = false;
                        RequestSendThread.backoff$1();
                    }
                }
                if (clientResponse == null) break block11;
                RequestHeader requestHeader = clientResponse.requestHeader();
                ApiKeys apiKeys = api = ApiKeys.forId((int)requestHeader.apiKey());
                ApiKeys apiKeys2 = ApiKeys.LEADER_AND_ISR;
                if (apiKeys == null ? apiKeys2 != null : !apiKeys.equals(apiKeys2)) {
                    ApiKeys apiKeys3 = api;
                    ApiKeys apiKeys4 = ApiKeys.STOP_REPLICA;
                    if (apiKeys3 == null ? apiKeys4 != null : !apiKeys3.equals(apiKeys4)) {
                        ApiKeys apiKeys5 = api;
                        ApiKeys apiKeys6 = ApiKeys.UPDATE_METADATA_KEY;
                        if (apiKeys5 == null ? apiKeys6 != null : !apiKeys5.equals(apiKeys6)) {
                            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected apiKey received: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{apiKey2})));
                        }
                    }
                }
                AbstractResponse response = clientResponse.responseBody();
                this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d received response %s for a request sent to broker %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.controllerContext().epoch()), response.toString(requestHeader.apiVersion()), this.brokerNode().toString()})));
                if (callback2 != null) {
                    callback2.apply((Object)response);
                }
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d fails to send a request to broker %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), this.brokerNode().toString()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                this.networkClient().close(this.brokerNode().idString());
            }
        }
    }

    private boolean brokerReady() {
        boolean bl;
        try {
            if (!NetworkClientUtils.isReady((KafkaClient)this.networkClient(), (Node)this.brokerNode(), (long)this.time().milliseconds())) {
                if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)this.brokerNode(), (Time)this.time(), (long)this.socketTimeoutMs())) {
                    throw new SocketTimeoutException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to connect within ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.socketTimeoutMs())})));
                }
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d connected to %s for sending state change requests")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), this.brokerNode().toString()})));
            }
            bl = true;
        }
        catch (Throwable e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d's connection to broker %s was unsuccessful")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), this.brokerNode().toString()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.networkClient().close(this.brokerNode().idString());
            bl = false;
        }
        return bl;
    }

    private static final void backoff$1() {
        CoreUtils$.MODULE$.swallowTrace((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Thread.sleep(100L));
    }

    public RequestSendThread(int controllerId, ControllerContext controllerContext, BlockingQueue<QueueItem> queue, NetworkClient networkClient, Node brokerNode, KafkaConfig config, Time time, String name) {
        this.controllerId = controllerId;
        this.controllerContext = controllerContext;
        this.queue = queue;
        this.networkClient = networkClient;
        this.brokerNode = brokerNode;
        this.config = config;
        this.time = time;
        super(name, ShutdownableThread$.MODULE$.$lessinit$greater$default$2());
        this.stateChangeLogger = KafkaController$.MODULE$.stateChangeLogger();
        this.socketTimeoutMs = config.controllerSocketTimeoutMs();
    }
}

