/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.LinkedHashMap;
import kafka.admin.AdminUtils$;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_11_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Replica;
import kafka.common.KafkaStorageException;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaFetcherBlockingSend;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.server.epoch.LeaderEpochCache;
import kafka.utils.Exit$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\reb\u0001B\u0001\u0003\u0001\u001d\u0011ACU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$'BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012D\u0011\"\u0004\u0001\u0003\u0002\u0003\u0006IAD\u000e\u0002\t9\fW.\u001a\t\u0003\u001faq!\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0005M1\u0011A\u0002\u001fs_>$hHC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9B#\u0001\u0004Qe\u0016$WMZ\u0005\u00033i\u0011aa\u0015;sS:<'BA\f\u0015\u0013\tiA$\u0003\u0002\u001e=\t\u00112\u000b[;uI><h.\u00192mKRC'/Z1e\u0015\tyB!A\u0003vi&d7\u000f\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0003%1W\r^2iKJLE\r\u0005\u0002$I5\tA#\u0003\u0002&)\t\u0019\u0011J\u001c;\t\u0013\u001d\u0002!\u0011!Q\u0001\n!r\u0013\u0001D:pkJ\u001cWM\u0011:pW\u0016\u0014\bCA\u0015-\u001b\u0005Q#BA\u0016\u0005\u0003\u001d\u0019G.^:uKJL!!\f\u0016\u0003\u001d\t\u0013xn[3s\u000b:$\u0007k\\5oi&\u0011qE\u0003\u0005\ta\u0001\u0011\t\u0011)A\u0005c\u0005a!M]8lKJ\u001cuN\u001c4jOB\u0011\u0011BM\u0005\u0003g\t\u00111bS1gW\u0006\u001cuN\u001c4jO\"AQ\u0007\u0001B\u0001B\u0003%a'\u0001\u0006sKBd\u0017nY1NOJ\u0004\"!C\u001c\n\u0005a\u0012!A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\tu\u0001\u0011\t\u0011)A\u0005w\u00059Q.\u001a;sS\u000e\u001c\bC\u0001\u001fF\u001b\u0005i$B\u0001\u001e?\u0015\ty\u0004)\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u0005S!AQ\"\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0015aA8sO&\u0011a)\u0010\u0002\b\u001b\u0016$(/[2t\u0011!A\u0005A!A!\u0002\u0013I\u0015\u0001\u0002;j[\u0016\u0004\"A\u0013'\u000e\u0003-S!a\b \n\u00055[%\u0001\u0002+j[\u0016D\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001U\u0001\u0006cV|G/\u0019\t\u0003\u0013EK!A\u0015\u0002\u0003/I+\u0007\u000f\\5dCRLwN\\)v_R\fW*\u00198bO\u0016\u0014\b\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B+\u000251,\u0017\rZ3s\u000b:$\u0007o\\5oi\ncwnY6j]\u001e\u001cVM\u001c3\u0011\u0007\r2\u0006,\u0003\u0002X)\t1q\n\u001d;j_:\u0004\"!C-\n\u0005i\u0013!\u0001\u0004\"m_\u000e\\\u0017N\\4TK:$\u0007\"\u0002/\u0001\t\u0003i\u0016A\u0002\u001fj]&$h\b\u0006\u0006_?\u0002\f'm\u00193fM\u001e\u0004\"!\u0003\u0001\t\u000b5Y\u0006\u0019\u0001\b\t\u000b\u0005Z\u0006\u0019\u0001\u0012\t\u000b\u001dZ\u0006\u0019\u0001\u0015\t\u000bAZ\u0006\u0019A\u0019\t\u000bUZ\u0006\u0019\u0001\u001c\t\u000biZ\u0006\u0019A\u001e\t\u000b![\u0006\u0019A%\t\u000b=[\u0006\u0019\u0001)\t\u000fQ[\u0006\u0013!a\u0001+\u0016!\u0011\u000e\u0001\u0001k\u0005\r\u0011V)\u0015\t\u0003Wjt!\u0001\u001c9\u000f\u00055|gBA\to\u0013\u0005)\u0011BA\u0002\u0005\u000f\u0015\t(\u0001#\u0001s\u0003Q\u0011V\r\u001d7jG\u00064U\r^2iKJ$\u0006N]3bIB\u0011\u0011b\u001d\u0004\u0006\u0003\tA\t\u0001^\n\u0003gV\u0004\"a\t<\n\u0005]$\"AB!osJ+g\rC\u0003]g\u0012\u0005\u0011\u0010F\u0001s\r\u0015Y8\u000f\u0001\u0002}\u000511U\r^2i%\u0016\fX/Z:u'\rQX/ \t\u0004}\u0006\raBA\u0005\u0000\u0013\r\t\tAA\u0001\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0013\rY\u0018Q\u0001\u0006\u0004\u0003\u0003\u0011\u0001BCA\u0005u\n\u0015\r\u0011\"\u0001\u0002\f\u0005QQO\u001c3fe2L\u0018N\\4\u0016\u0005\u00055\u0001\u0003BA\b\u00037qA!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+q\u0014\u0001\u0003:fcV,7\u000f^:\n\t\u0005e\u00111C\u0001\r\r\u0016$8\r\u001b*fcV,7\u000f^\u0005\u0005\u0003;\tyBA\u0004Ck&dG-\u001a:\u000b\t\u0005e\u00111\u0003\u0005\u000b\u0003GQ(\u0011!Q\u0001\n\u00055\u0011aC;oI\u0016\u0014H._5oO\u0002Ba\u0001\u0018>\u0005\u0002\u0005\u001dB\u0003BA\u0015\u0003[\u00012!a\u000b{\u001b\u0005\u0019\b\u0002CA\u0005\u0003K\u0001\r!!\u0004\t\u000f\u0005E\"\u0010\"\u0001\u00024\u00059\u0011n]#naRLXCAA\u001b!\r\u0019\u0013qG\u0005\u0004\u0003s!\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003{QH\u0011AA \u0003\u0019ygMZ:fiR!\u0011\u0011IA$!\r\u0019\u00131I\u0005\u0004\u0003\u000b\"\"\u0001\u0002'p]\u001eD\u0001\"!\u0013\u0002<\u0001\u0007\u00111J\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\ti%a\u0014\u000e\u0003yJ1!!\u0015?\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!!\u0016{\t\u0003\n9&\u0001\u0005u_N#(/\u001b8h)\t\tI\u0006\u0005\u0003\u0002\\\u0005\u0015TBAA/\u0015\u0011\ty&!\u0019\u0002\t1\fgn\u001a\u0006\u0003\u0003G\nAA[1wC&\u0019\u0011$!\u0018\u0007\u000f\u0005%4\u000f\u0001\u0002\u0002l\ti\u0001+\u0019:uSRLwN\u001c#bi\u0006\u001cR!a\u001av\u0003[\u00022A`A8\u0013\u0011\tI'!\u0002\t\u0017\u0005%\u0011q\rBC\u0002\u0013\u0005\u00111O\u000b\u0003\u0003k\u0002B!a\u001e\u0002~9!\u0011\u0011CA=\u0013\u0011\tY(a\u0005\u0002\u001b\u0019+Go\u00195SKN\u0004xN\\:f\u0013\u0011\tI'a \u000b\t\u0005m\u00141\u0003\u0005\f\u0003G\t9G!A!\u0002\u0013\t)\bC\u0004]\u0003O\"\t!!\"\u0015\t\u0005\u001d\u0015\u0011\u0012\t\u0005\u0003W\t9\u0007\u0003\u0005\u0002\n\u0005\r\u0005\u0019AA;\u0011!\ti)a\u001a\u0005\u0002\u0005=\u0015!B3se>\u0014XCAAI!\u0011\t\u0019*!'\u000e\u0005\u0005U%bAAL}\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0002\u001c\u0006U%AB#se>\u00148\u000f\u0003\u0005\u0002 \u0006\u001dD\u0011AAQ\u0003%!xNU3d_J$7/\u0006\u0002\u0002$B!\u0011QUAV\u001b\t\t9KC\u0002\u0002*z\naA]3d_J$\u0017\u0002BAW\u0003O\u0013Q\"T3n_JL(+Z2pe\u0012\u001c\b\u0002CAY\u0003O\"\t!a-\u0002\u001b!Lw\r[,bi\u0016\u0014X.\u0019:l+\t\t\t\u0005\u0003\u0005\u00028\u0006\u001dD\u0011AAZ\u00039awnZ*uCJ$xJ\u001a4tKRD\u0001\"a/\u0002h\u0011\u0005\u0011QX\u0001\nKb\u001cW\r\u001d;j_:,\"!a0\u0011\t\r2\u0016\u0011\u0019\t\u0005\u0003\u0007\fiM\u0004\u0003\u0002F\u0006%gbA\t\u0002H&\tQ#C\u0002\u0002LR\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002P\u0006E'!\u0003+ie><\u0018M\u00197f\u0015\r\tY\r\u0006\u0005\t\u0003+\n9\u0007\"\u0011\u0002X!I\u0011q[:\u0012\u0002\u0013\u0005\u0011\u0011\\\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\u0005m'fA+\u0002^.\u0012\u0011q\u001c\t\u0005\u0003C\fY/\u0004\u0002\u0002d*!\u0011Q]At\u0003%)hn\u00195fG.,GMC\u0002\u0002jR\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti/a9\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0002\u0004\u0002r\u0002\u0001\u00111\u001f\u0002\u0003!\u0012\u00032a[A4\u0011%\t9\u0010\u0001b\u0001\n\u0013\tI0\u0001\bmK\u0006$WM]#oIB|\u0017N\u001c;\u0016\u0003aCq!!@\u0001A\u0003%\u0001,A\bmK\u0006$WM]#oIB|\u0017N\u001c;!\u0011%\u0011\t\u0001\u0001b\u0001\n\u0013\u0011\u0019!A\ngKR\u001c\u0007NU3rk\u0016\u001cHOV3sg&|g.\u0006\u0002\u0003\u0006A\u00191Ea\u0002\n\u0007\t%ACA\u0003TQ>\u0014H\u000f\u0003\u0005\u0003\u000e\u0001\u0001\u000b\u0011\u0002B\u0003\u0003Q1W\r^2i%\u0016\fX/Z:u-\u0016\u00148/[8oA!I!\u0011\u0003\u0001C\u0002\u0013%!1C\u0001\ne\u0016\u0004H.[2b\u0013\u0012,\u0012A\t\u0005\b\u0005/\u0001\u0001\u0015!\u0003#\u0003)\u0011X\r\u001d7jG\u0006LE\r\t\u0005\n\u00057\u0001!\u0019!C\u0005\u0005;\tq!\\1y/\u0006LG/\u0006\u0002\u0003 A!\u00111\fB\u0011\u0013\u0011\u0011\u0019#!\u0018\u0003\u000f%sG/Z4fe\"A!q\u0005\u0001!\u0002\u0013\u0011y\"\u0001\u0005nCb<\u0016-\u001b;!\u0011%\u0011Y\u0003\u0001b\u0001\n\u0013\u0011i\"\u0001\u0005nS:\u0014\u0015\u0010^3t\u0011!\u0011y\u0003\u0001Q\u0001\n\t}\u0011!C7j]\nKH/Z:!\u0011%\u0011\u0019\u0004\u0001b\u0001\n\u0013\u0011i\"\u0001\u0005nCb\u0014\u0015\u0010^3t\u0011!\u00119\u0004\u0001Q\u0001\n\t}\u0011!C7bq\nKH/Z:!\u0011%\u0011Y\u0004\u0001b\u0001\n\u0013\u0011i\"A\u0005gKR\u001c\u0007nU5{K\"A!q\b\u0001!\u0002\u0013\u0011y\"\u0001\u0006gKR\u001c\u0007nU5{K\u0002B\u0011Ba\u0011\u0001\u0005\u0004%I!a\r\u00029MDw.\u001e7e'\u0016tG\rT3bI\u0016\u0014X\t]8dQJ+\u0017/^3ti\"A!q\t\u0001!\u0002\u0013\t)$A\u000ftQ>,H\u000eZ*f]\u0012dU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;!\u0011\u001d\u0011Y\u0005\u0001C\u0005\u0005\u001b\n!\"\u001a9pG\"\u001c\u0015m\u00195f)\u0011\u0011yEa\u0017\u0011\t\tE#qK\u0007\u0003\u0005'R1A!\u0016\u0003\u0003\u0015)\u0007o\\2i\u0013\u0011\u0011IFa\u0015\u0003!1+\u0017\rZ3s\u000bB|7\r[\"bG\",\u0007\u0002\u0003B/\u0005\u0013\u0002\r!a\u0013\u0002\u0005Q\u0004\bb\u0002B1\u0001\u0011\u0005#1M\u0001\tg\",H\u000fZ8x]R\u0011!Q\r\t\u0004G\t\u001d\u0014b\u0001B5)\t!QK\\5u\u0011\u001d\u0011i\u0007\u0001C\u0001\u0005_\nA\u0003\u001d:pG\u0016\u001c8\u000fU1si&$\u0018n\u001c8ECR\fG\u0003\u0003B3\u0005c\u0012\u0019Ha\u001e\t\u0011\u0005%#1\u000ea\u0001\u0003\u0017B\u0001B!\u001e\u0003l\u0001\u0007\u0011\u0011I\u0001\fM\u0016$8\r[(gMN,G\u000f\u0003\u0005\u0003z\t-\u0004\u0019AAz\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uC\"9!Q\u0010\u0001\u0005\u0002\t}\u0014aG7bs\n,w+\u0019:o\u0013\u001a|e/\u001a:tSj,GMU3d_J$7\u000f\u0006\u0004\u0003f\t\u0005%Q\u0011\u0005\t\u0005\u0007\u0013Y\b1\u0001\u0002$\u00069!/Z2pe\u0012\u001c\b\u0002CA%\u0005w\u0002\r!a\u0013\t\u000f\t%\u0005\u0001\"\u0001\u0003\f\u00061\u0002.\u00198eY\u0016|eMZ:fi>+Ho\u00144SC:<W\r\u0006\u0003\u0002B\t5\u0005\u0002CA%\u0005\u000f\u0003\r!a\u0013\t\u000f\tE\u0005\u0001\"\u0001\u0003\u0014\u0006Q\u0002.\u00198eY\u0016\u0004\u0016M\u001d;ji&|gn],ji\",%O]8sgR!!Q\rBK\u0011!\u00119Ja$A\u0002\te\u0015A\u00039beRLG/[8ogB1\u00111\u0019BN\u0003\u0017JAA!(\u0002R\nA\u0011\n^3sC\ndW\rC\u0004\u0003\"\u0002!\tBa)\u0002\u000b\u0019,Go\u00195\u0015\t\t\u0015&\u0011\u0017\t\u0007\u0003\u0007\u00149Ka+\n\t\t%\u0016\u0011\u001b\u0002\u0004'\u0016\f\bcB\u0012\u0003.\u0006-\u00131_\u0005\u0004\u0005_#\"A\u0002+va2,'\u0007C\u0004\u00034\n}\u0005\u0019\u00016\u0002\u0019\u0019,Go\u00195SKF,Xm\u001d;\t\u000f\t]\u0006\u0001\"\u0003\u0003:\u00061R-\u0019:mS\u0016\u001cHo\u0014:MCR,7\u000f^(gMN,G\u000f\u0006\u0004\u0002B\tm&Q\u0018\u0005\t\u0003\u0013\u0012)\f1\u0001\u0002L!A!q\u0018B[\u0001\u0004\t\t%\u0001\tfCJd\u0017.Z:u\u001fJd\u0015\r^3ti\"9!1\u0019\u0001\u0005B\t\u0015\u0017!\u00052vS2$g)\u001a;dQJ+\u0017/^3tiR\u0019!Na2\t\u0011\t%'\u0011\u0019a\u0001\u0005\u0017\fA\u0002]1si&$\u0018n\u001c8NCB\u0004b!a1\u0003(\n5\u0007cB\u0012\u0003.\u0006-#q\u001a\t\u0004\u0013\tE\u0017b\u0001Bj\u0005\t\u0019\u0002+\u0019:uSRLwN\u001c$fi\u000eD7\u000b^1uK\"9!q\u001b\u0001\u0005B\te\u0017!D7bs\n,GK];oG\u0006$X\r\u0006\u0003\u0003\\\n\u001d\b\u0003\u0003Bo\u0005G\fY%!\u0011\u000e\u0005\t}'b\u0001Bq)\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\u0015(q\u001c\u0002\u0004\u001b\u0006\u0004\b\u0002\u0003Bu\u0005+\u0004\rAa;\u0002\u001b\u0019,Go\u00195fI\u0016\u0003xn\u00195t!!\u0011iNa9\u0002L\t5\b\u0003BA\t\u0005_LAA!=\u0002\u0014\tqQ\t]8dQ\u0016sGm\u00144gg\u0016$\bb\u0002B{\u0001\u0011\u0005#q_\u0001\u0018EVLG\u000e\u001a'fC\u0012,'/\u00129pG\"\u0014V-];fgR$BA!?\u0003|B9!Q\u001cBr\u0003\u0017\u0012\u0003\u0002\u0003B\u007f\u0005g\u0004\rAa3\u0002\u001b\u0005dG\u000eU1si&$\u0018n\u001c8t\u0011\u001d\u0019\t\u0001\u0001C!\u0007\u0007\tQCZ3uG\",\u0005o\\2ig\u001a\u0013x.\u001c'fC\u0012,'\u000f\u0006\u0003\u0003l\u000e\u0015\u0001\u0002\u0003BL\u0005\u007f\u0004\rA!?\t\u000f\r%\u0001\u0001\"\u0003\u0004\f\u0005aAn\\4F]\u0012|eMZ:fiR1\u0011\u0011IB\u0007\u0007/A\u0001ba\u0004\u0004\b\u0001\u00071\u0011C\u0001\be\u0016\u0004H.[2b!\rI31C\u0005\u0004\u0007+Q#a\u0002*fa2L7-\u0019\u0005\t\u00073\u00199\u00011\u0001\u0003n\u0006YQ\r]8dQ>3gm]3u\u0011\u001d\t\t\f\u0001C\u0005\u0007;!b!!\u0011\u0004 \r\u0005\u0002\u0002CB\b\u00077\u0001\ra!\u0005\t\u0011\re11\u0004a\u0001\u0005[Dqa!\n\u0001\t\u0013\u00199#\u0001\ftQ>,H\u000e\u001a$pY2|w/\u001a:UQJ|G\u000f\u001e7f)\u0019\t)d!\u000b\u00042!9qja\tA\u0002\r-\u0002cA\u0005\u0004.%\u00191q\u0006\u0002\u0003\u0019I+\u0007\u000f\\5dCF+x\u000e^1\t\u0011\u0005%31\u0005a\u0001\u0003\u0017BQb!\u000e\u0001!\u0003\r\t\u0011!C\u0005\u0007oq\u0013AE:va\u0016\u0014He]8ve\u000e,'I]8lKJ,\u0012\u0001\u000b")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    private final int fetcherId;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final Metrics metrics;
    private final Time time;
    private final ReplicationQuotaManager quota;
    private final BlockingSend leaderEndpoint;
    private final short fetchRequestVersion;
    private final int replicaId;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private final boolean shouldSendLeaderEpochRequest;

    public static Option<BlockingSend> $lessinit$greater$default$9() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$9();
    }

    private /* synthetic */ BrokerEndPoint super$sourceBroker() {
        return super.sourceBroker();
    }

    private BlockingSend leaderEndpoint() {
        return this.leaderEndpoint;
    }

    private short fetchRequestVersion() {
        return this.fetchRequestVersion;
    }

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private boolean shouldSendLeaderEpochRequest() {
        return this.shouldSendLeaderEpochRequest;
    }

    private LeaderEpochCache epochCache(TopicPartition tp) {
        return (LeaderEpochCache)((Replica)this.replicaMgr.getReplica(tp).get()).epochs().get();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.leaderEndpoint().close();
    }

    public void processPartitionData(TopicPartition topicPartition, long fetchOffset, PartitionData partitionData) {
        try {
            Replica replica = (Replica)this.replicaMgr.getReplica(topicPartition).get();
            MemoryRecords records = partitionData.toRecords();
            this.maybeWarnIfOversizedRecords(records, topicPartition);
            if (fetchOffset != replica.logEndOffset().messageOffset()) {
                throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for partition %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset())})));
            }
            if (this.logger().isTraceEnabled()) {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Follower %d has replica log end offset %d for partition %s. Received %d messages and leader hw %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replica.brokerId()), BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset()), topicPartition, BoxesRunTime.boxToInteger((int)records.sizeInBytes()), BoxesRunTime.boxToLong((long)partitionData.highWatermark())})));
            }
            ((Log)replica.log().get()).appendAsFollower(records);
            if (this.logger().isTraceEnabled()) {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Follower %d has replica log end offset %d after appending %d bytes of messages for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replica.brokerId()), BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset()), BoxesRunTime.boxToInteger((int)records.sizeInBytes()), topicPartition})));
            }
            long followerHighWatermark = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(replica.logEndOffset().messageOffset()), partitionData.highWatermark());
            long leaderLogStartOffset = partitionData.logStartOffset();
            replica.highWatermark_$eq(new LogOffsetMetadata(followerHighWatermark, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            replica.maybeIncrementLogStartOffset(leaderLogStartOffset);
            if (this.logger().isTraceEnabled()) {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Follower ", " set replica high watermark for partition ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replica.brokerId()), topicPartition, BoxesRunTime.boxToLong((long)followerHighWatermark)})));
            }
            if (this.quota.isThrottled(topicPartition)) {
                this.quota.record(records.sizeInBytes());
            }
            this.replicaMgr.brokerTopicStats().updateReplicationBytesIn(records.sizeInBytes());
        }
        catch (KafkaStorageException e) {
            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Disk error while replicating data for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            throw Exit$.MODULE$.halt(1, Exit$.MODULE$.halt$default$2());
        }
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        block0: {
            if (this.fetchRequestVersion() > 2 || records.sizeInBytes() <= 0 || records.validBytes() > 0) break block0;
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})) + "This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large " + "message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be " + "equal or larger than your settings for max.message.bytes, both at a broker and topic level.");
        }
    }

    @Override
    public long handleOffsetOutOfRange(TopicPartition topicPartition) {
        long l;
        Replica replica = (Replica)this.replicaMgr.getReplica(topicPartition).get();
        long leaderEndOffset = this.earliestOrLatestOffset(topicPartition, -1L);
        if (leaderEndOffset < replica.logEndOffset().messageOffset()) {
            if (!Predef$.MODULE$.Boolean2boolean(LogConfig$.MODULE$.fromProps(this.brokerConfig.originals(), AdminUtils$.MODULE$.fetchEntityConfig(this.replicaMgr.zkUtils(), ConfigType$.MODULE$.Topic(), topicPartition.topic())).uncleanLeaderElectionEnable())) {
                this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exiting because log truncation is not allowed for partition ", ", current leader "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "'s latest offset ", " is less than replica ", "'s latest "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.super$sourceBroker().id()), BoxesRunTime.boxToLong((long)leaderEndOffset), BoxesRunTime.boxToInteger((int)$this.brokerConfig.brokerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset())})));
                throw new FatalExitError();
            }
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Replica %d for partition %s reset its fetch offset from %d to current leader %d's latest offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.brokerConfig.brokerId()), topicPartition, BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset()), BoxesRunTime.boxToInteger((int)this.super$sourceBroker().id()), BoxesRunTime.boxToLong((long)leaderEndOffset)})));
            this.replicaMgr.logManager().truncateTo((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)leaderEndOffset))}))));
            l = leaderEndOffset;
        } else {
            long leaderStartOffset = this.earliestOrLatestOffset(topicPartition, -2L);
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Replica %d for partition %s reset its fetch offset from %d to current leader %d's start offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.brokerConfig.brokerId()), topicPartition, BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset()), BoxesRunTime.boxToInteger((int)this.super$sourceBroker().id()), BoxesRunTime.boxToLong((long)leaderStartOffset)})));
            long offsetToFetch = Math.max(leaderStartOffset, replica.logEndOffset().messageOffset());
            if (leaderStartOffset > replica.logEndOffset().messageOffset()) {
                this.replicaMgr.logManager().truncateFullyAndStartAt(topicPartition, leaderStartOffset);
            }
            l = offsetToFetch;
        }
        return l;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicPartition> partitions) {
        this.delayPartitions(partitions, Predef$.MODULE$.Integer2int(this.brokerConfig.replicaFetchBackoffMs()));
    }

    public Seq<Tuple2<TopicPartition, PartitionData>> fetch(FetchRequest fetchRequest) {
        ClientResponse clientResponse = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest.underlying());
        FetchResponse fetchResponse = (FetchResponse)clientResponse.responseBody();
        return (Seq)((scala.collection.mutable.MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse.responseData()).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition key = (TopicPartition)tuple2._1();
            FetchResponse.PartitionData value = (FetchResponse.PartitionData)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new PartitionData(value));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private long earliestOrLatestOffset(TopicPartition topicPartition, long earliestOrLatest) {
        ListOffsetRequest.Builder builder;
        if (this.brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$)) {
            Map partitions = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)Predef$.MODULE$.long2Long(earliestOrLatest))}));
            builder = ListOffsetRequest.Builder.forReplica((short)1, (int)this.replicaId()).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava());
        } else {
            Map partitions = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ListOffsetRequest.PartitionData(earliestOrLatest, 1))}));
            builder = ListOffsetRequest.Builder.forReplica((short)0, (int)this.replicaId()).setOffsetData((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava());
        }
        ListOffsetRequest.Builder requestBuilder = builder;
        ClientResponse clientResponse = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)requestBuilder);
        ListOffsetResponse response = (ListOffsetResponse)clientResponse.responseBody();
        ListOffsetResponse.PartitionData partitionData = (ListOffsetResponse.PartitionData)response.responseData().get(topicPartition);
        Errors errors = partitionData.error;
        if (!Errors.NONE.equals(errors)) {
            throw errors.exception();
        }
        long l = this.brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? Predef$.MODULE$.Long2long(partitionData.offset) : Predef$.MODULE$.Long2long((Long)partitionData.offsets.get(0));
        return l;
    }

    @Override
    public FetchRequest buildFetchRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> partitionMap) {
        LinkedHashMap requestMap = new LinkedHashMap();
        partitionMap.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
                if (partitionFetchState.isReadyForFetch() && !this.shouldFollowerThrottle($this.quota, topicPartition)) {
                    long logStartOffset = $this.replicaMgr.getReplicaOrException(topicPartition).logStartOffset();
                    boxedUnit = requestMap.put(topicPartition, new FetchRequest.PartitionData(partitionFetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize())));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)this.fetchRequestVersion(), (int)this.replicaId(), (int)Predef$.MODULE$.Integer2int(this.maxWait()), (int)Predef$.MODULE$.Integer2int(this.minBytes()), requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
        return new FetchRequest(requestBuilder);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<TopicPartition, Object> maybeTruncate(Map<TopicPartition, EpochEndOffset> fetchedEpochs) {
        void var2_2;
        HashMap truncationPoints = HashMap$.MODULE$.empty();
        Set partitionsWithError = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        fetchedEpochs.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            SetLike setLike;
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                EpochEndOffset epochOffset = (EpochEndOffset)tuple2._2();
                Replica replica = (Replica)$this.replicaMgr.getReplica(tp).get();
                if (epochOffset.hasError()) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrying leaderEpoch request for partition ", " as the leader reported an error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica.topicPartition(), epochOffset.error()})));
                    setLike = partitionsWithError.$plus$eq((Object)tp);
                } else {
                    long truncationOffset = epochOffset.endOffset() == -1L ? this.highWatermark(replica, epochOffset) : (epochOffset.endOffset() >= replica.logEndOffset().messageOffset() ? this.logEndOffset(replica, epochOffset) : epochOffset.endOffset());
                    setLike = truncationPoints.put((Object)tp, (Object)BoxesRunTime.boxToLong((long)truncationOffset));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            SetLike setLike2 = setLike;
            return setLike2;
        });
        this.replicaMgr.logManager().truncateTo((Map<TopicPartition, Object>)truncationPoints);
        this.delayPartitions((Iterable<TopicPartition>)partitionsWithError, Predef$.MODULE$.Integer2int(this.brokerConfig.replicaFetchBackoffMs()));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<TopicPartition, Object> buildLeaderEpochRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> allPartitions) {
        void var2_2;
        scala.collection.immutable.Map result = ((TraversableOnce)((TraversableLike)allPartitions.filter((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)ReplicaFetcherThread.$anonfun$buildLeaderEpochRequest$1(x0$4)))).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToInteger((int)this.epochCache(tp).latestEpoch()));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Build leaderEpoch request ", " for broker ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{result, this.super$sourceBroker()})));
        return var2_2;
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochsFromLeader(Map<TopicPartition, Object> partitions) {
        ObjectRef result = ObjectRef.create(null);
        if (this.shouldSendLeaderEpochRequest()) {
            java.util.Map partitionsAsJava = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x0$6 -> {
                Tuple2 tuple2 = x0$6;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                int epoch = tuple2._2$mcI$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToInteger((int)epoch));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            OffsetsForLeaderEpochRequest.Builder epochRequest = new OffsetsForLeaderEpochRequest.Builder(partitionsAsJava);
            try {
                ClientResponse response = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
                result.elem = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(((OffsetsForLeaderEpochResponse)response.responseBody()).responses()).asScala();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Receive leaderEpoch response ", " from broker ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Map)result$2.elem, this.super$sourceBroker()})));
            }
            catch (Throwable t) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error when sending leader epoch request for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitions})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                result.elem = (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$7 -> {
                    Tuple2 tuple2 = x0$7;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(Errors.forException((Throwable)t), -1L));
                    return tuple22;
                }, Map$.MODULE$.canBuildFrom());
            }
        } else {
            result.elem = (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$8 -> {
                Tuple2 tuple2 = x0$8;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(Errors.NONE, -1L));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        }
        return (Map)result.elem;
    }

    /*
     * WARNING - void declaration
     */
    private long logEndOffset(Replica replica, EpochEndOffset epochOffset) {
        void var3_3;
        long logEndOffset = replica.logEndOffset().messageOffset();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Based on follower's leader epoch, leader replied with an offset ", " >= the follower's log end offset ", " in ", ". No truncation needed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)epochOffset.endOffset()), BoxesRunTime.boxToLong((long)logEndOffset), replica.topicPartition()})));
        return (long)var3_3;
    }

    private long highWatermark(Replica replica, EpochEndOffset epochOffset) {
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Based on follower's leader epoch, leader replied with an unknown offset in ", ". High watermark ", " will be used for truncation."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica.topicPartition(), BoxesRunTime.boxToLong((long)replica.highWatermark().messageOffset())})));
        return replica.highWatermark().messageOffset();
    }

    private boolean shouldFollowerThrottle(ReplicaQuota quota, TopicPartition topicPartition) {
        boolean isReplicaInSync = this.fetcherLagStats().isReplicaInSync(topicPartition.topic(), topicPartition.partition());
        return quota.isThrottled(topicPartition) && quota.isQuotaExceeded() && !isReplicaInSync;
    }

    public static final /* synthetic */ boolean $anonfun$buildLeaderEpochRequest$1(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        PartitionFetchState state = (PartitionFetchState)tuple2._2();
        boolean bl = state.isTruncatingLog();
        return bl;
    }

    public ReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicationQuotaManager quota, Option<BlockingSend> leaderEndpointBlockingSend) {
        this.fetcherId = fetcherId;
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.metrics = metrics;
        this.time = time;
        this.quota = quota;
        super(name, name, sourceBroker, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false, true);
        this.leaderEndpoint = (BlockingSend)leaderEndpointBlockingSend.getOrElse((Function0 & Serializable & scala.Serializable)() -> new ReplicaFetcherBlockingSend(this.super$sourceBroker(), $this.brokerConfig, $this.metrics, $this.time, $this.fetcherId, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"broker-", "-fetcher-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.brokerConfig.brokerId()), BoxesRunTime.boxToInteger((int)$this.fetcherId)}))));
        this.fetchRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV1$.MODULE$) ? 5 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? 1 : 0)))));
        this.replicaId = brokerConfig.brokerId();
        this.maxWait = brokerConfig.replicaFetchWaitMaxMs();
        this.minBytes = brokerConfig.replicaFetchMinBytes();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.shouldSendLeaderEpochRequest = brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV2$.MODULE$);
    }

    public static class FetchRequest
    implements AbstractFetcherThread.FetchRequest {
        private final FetchRequest.Builder underlying;

        public FetchRequest.Builder underlying() {
            return this.underlying;
        }

        @Override
        public boolean isEmpty() {
            return this.underlying().fetchData().isEmpty();
        }

        @Override
        public long offset(TopicPartition topicPartition) {
            return ((FetchRequest.PartitionData)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.underlying().fetchData()).asScala()).apply((Object)topicPartition)).fetchOffset;
        }

        public String toString() {
            return this.underlying().toString();
        }

        public FetchRequest(FetchRequest.Builder underlying) {
            this.underlying = underlying;
        }
    }

    public static class PartitionData
    implements AbstractFetcherThread.PartitionData {
        private final FetchResponse.PartitionData underlying;

        public FetchResponse.PartitionData underlying() {
            return this.underlying;
        }

        @Override
        public Errors error() {
            return this.underlying().error;
        }

        @Override
        public MemoryRecords toRecords() {
            return (MemoryRecords)this.underlying().records;
        }

        @Override
        public long highWatermark() {
            return this.underlying().highWatermark;
        }

        public long logStartOffset() {
            return this.underlying().logStartOffset;
        }

        @Override
        public Option<Throwable> exception() {
            Errors errors = this.error();
            Object object = Errors.NONE.equals(errors) ? None$.MODULE$ : new Some((Object)errors.exception());
            return object;
        }

        public String toString() {
            return this.underlying().toString();
        }

        public PartitionData(FetchResponse.PartitionData underlying) {
            this.underlying = underlying;
        }
    }
}

