/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread$;
import org.apache.kafka.common.internals.FatalExitError;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u4QAF\f\u0002\u0002qA\u0001\"\u000b\u0001\u0003\u0006\u0004%\tA\u000b\u0005\tq\u0001\u0011\t\u0011)A\u0005W!A\u0011\b\u0001BC\u0002\u0013\u0005!\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003<\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u001d)\u0005A1A\u0005\n\u0019Caa\u0014\u0001!\u0002\u00139\u0005b\u0002)\u0001\u0005\u0004%IA\u0012\u0005\u0007#\u0002\u0001\u000b\u0011B$\t\u000bI\u0003A\u0011A*\t\u000b]\u0003A\u0011\u0001\u001e\t\u000ba\u0003A\u0011A-\t\u000bi\u0003A\u0011A*\t\u000bm\u0003A\u0011\u0001/\t\u000b\u001d\u0004a\u0011A*\t\u000b!\u0004A\u0011I*\t\u000b%\u0004A\u0011\u0001\u001e\b\u000f)<\u0012\u0011!E\u0001W\u001a9acFA\u0001\u0012\u0003a\u0007\"\u0002!\u0014\t\u0003\u0001\bbB9\u0014#\u0003%\tA\u001d\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fGM\u0003\u0002\u00193\u0005)Q\u000f^5mg*\t!$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001iR\u0005\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u0005!A.\u00198h\u0015\u0005\u0011\u0013\u0001\u00026bm\u0006L!\u0001J\u0010\u0003\rQC'/Z1e!\t1s%D\u0001\u0018\u0013\tAsCA\u0004M_\u001e<\u0017N\\4\u0002\t9\fW.Z\u000b\u0002WA\u0011A&\u000e\b\u0003[M\u0002\"AL\u0019\u000e\u0003=R!\u0001M\u000e\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0003\u0019\u0001&/\u001a3fM&\u0011ag\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Q\n\u0014!\u00028b[\u0016\u0004\u0013aD5t\u0013:$XM\u001d:vaRL'\r\\3\u0016\u0003m\u0002\"\u0001P\u001f\u000e\u0003EJ!AP\u0019\u0003\u000f\t{w\u000e\\3b]\u0006\u0001\u0012n]%oi\u0016\u0014(/\u001e9uS\ndW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\t\u001bE\t\u0005\u0002'\u0001!)\u0011&\u0002a\u0001W!9\u0011(\u0002I\u0001\u0002\u0004Y\u0014!E:ikR$wn\u001e8J]&$\u0018.\u0019;fIV\tq\t\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u00051\u000b\u0013\u0001B;uS2L!AT%\u0003\u001d\r{WO\u001c;E_^tG*\u0019;dQ\u0006\u00112\u000f[;uI><h.\u00138ji&\fG/\u001a3!\u0003A\u0019\b.\u001e;e_^t7i\\7qY\u0016$X-A\ttQV$Hm\\<o\u0007>l\u0007\u000f\\3uK\u0002\n\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0002)B\u0011A(V\u0005\u0003-F\u0012A!\u00168ji\u0006\u0011\u0012n]*ikR$wn\u001e8D_6\u0004H.\u001a;f\u0003AIg.\u001b;jCR,7\u000b[;uI><h\u000eF\u0001<\u00035\tw/Y5u'\",H\u000fZ8x]\u0006)\u0001/Y;tKR\u0019A+\u00182\t\u000bys\u0001\u0019A0\u0002\u000fQLW.Z8viB\u0011A\bY\u0005\u0003CF\u0012A\u0001T8oO\")1M\u0004a\u0001I\u0006!QO\\5u!\tAU-\u0003\u0002g\u0013\nAA+[7f+:LG/\u0001\u0004e_^{'o[\u0001\u0004eVt\u0017!C5t%Vtg.\u001b8h\u0003I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u0011\u0005\u0019\u001a2CA\nn!\tad.\u0003\u0002pc\t1\u0011I\\=SK\u001a$\u0012a[\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003MT#a\u000f;,\u0003U\u0004\"A^>\u000e\u0003]T!\u0001_=\u0002\u0013Ut7\r[3dW\u0016$'B\u0001>2\u0003)\tgN\\8uCRLwN\\\u0005\u0003y^\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public abstract class ShutdownableThread
extends Thread
implements Logging {
    private final String name;
    private final boolean isInterruptible;
    private final CountDownLatch shutdownInitiated;
    private final CountDownLatch shutdownComplete;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return ShutdownableThread$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ShutdownableThread shutdownableThread = this;
        synchronized (shutdownableThread) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    public boolean isInterruptible() {
        return this.isInterruptible;
    }

    private CountDownLatch shutdownInitiated() {
        return this.shutdownInitiated;
    }

    private CountDownLatch shutdownComplete() {
        return this.shutdownComplete;
    }

    public void shutdown() {
        this.initiateShutdown();
        this.awaitShutdown();
    }

    public boolean isShutdownComplete() {
        return this.shutdownComplete().getCount() == 0L;
    }

    public synchronized boolean initiateShutdown() {
        boolean bl;
        if (this.isRunning()) {
            this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Shutting down");
            this.shutdownInitiated().countDown();
            if (this.isInterruptible()) {
                this.interrupt();
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void awaitShutdown() {
        this.shutdownComplete().await();
        this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Shutdown completed");
    }

    public void pause(long timeout, TimeUnit unit) {
        block0: {
            if (!this.shutdownInitiated().await(timeout, unit)) break block0;
            this.trace((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "shutdownInitiated latch count reached zero. Shutdown called.");
        }
    }

    public abstract void doWork();

    @Override
    public void run() {
        this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Starting");
        try {
            try {
                while (this.isRunning()) {
                    this.doWork();
                }
            }
            catch (FatalExitError e) {
                this.shutdownInitiated().countDown();
                this.shutdownComplete().countDown();
                this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Stopped");
                throw Exit$.MODULE$.exit(e.statusCode(), Exit$.MODULE$.exit$default$2());
            }
            catch (Throwable e) {
                if (this.isRunning()) {
                    this.error((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Error due to", (Function0<Throwable>)(Function0 & java.io.Serializable & Serializable)() -> e);
                }
            }
        }
        finally {
            this.shutdownComplete().countDown();
        }
        this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Stopped");
    }

    public boolean isRunning() {
        return this.shutdownInitiated().getCount() != 0L;
    }

    public ShutdownableThread(String name, boolean isInterruptible) {
        this.name = name;
        this.isInterruptible = isInterruptible;
        super(name);
        Logging.$init$(this);
        this.setDaemon(false);
        this.logIdent_$eq(new StringBuilder(4).append("[").append(name).append("]: ").toString());
        this.shutdownInitiated = new CountDownLatch(1);
        this.shutdownComplete = new CountDownLatch(1);
    }
}

