/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.admin.LogDirsCommand;
import kafka.utils.Json$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.LogDirDescription;
import org.apache.kafka.clients.admin.ReplicaInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class LogDirsCommand$ {
    public static LogDirsCommand$ MODULE$;

    static {
        new LogDirsCommand$();
    }

    public void main(String[] args) {
        this.describe(args, System.out);
    }

    /*
     * WARNING - void declaration
     */
    public void describe(String[] args, PrintStream out) {
        LogDirsCommand.LogDirsCommandOptions opts = new LogDirsCommand.LogDirsCommandOptions(args);
        try (Admin adminClient = this.createAdminClient(opts);){
            void var11_13;
            void var10_12;
            Object object;
            Set set;
            String[] topicList = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)opts.options().valueOf(opts.topicListOpt())).split(","))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LogDirsCommand$.$anonfun$describe$1(x$1)));
            Set clusterBrokers = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)adminClient.describeCluster().nodes().get()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet();
            Option option = Option$.MODULE$.apply(opts.options().valueOf(opts.brokerListOpt()));
            if (option instanceof Some) {
                String brokerListStr = (String)((Some)option).value();
                Set inputBrokers = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(brokerListStr)).split(','))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogDirsCommand$.$anonfun$describe$3(x$3))))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)LogDirsCommand$.$anonfun$describe$4(x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).toSet();
                set = inputBrokers.diff((GenSet)clusterBrokers);
                object = inputBrokers.intersect((GenSet)clusterBrokers);
            } else if (None$.MODULE$.equals(option)) {
                set = Predef$.MODULE$.Set().empty();
                object = clusterBrokers;
            } else {
                throw new MatchError((Object)option);
            }
            Set existingBrokers = object;
            Set nonExistingBrokers = set;
            void existingBrokers2 = var10_12;
            void nonExistingBrokers2 = var11_13;
            if (nonExistingBrokers2.nonEmpty()) {
                out.println(new StringBuilder(86).append("ERROR: The given brokers do not exist from --broker-list: ").append(nonExistingBrokers2.mkString(",")).append(".").append(" Current existent brokers: ").append(clusterBrokers.mkString(",")).toString());
            } else {
                out.println("Querying brokers for log directories information");
                DescribeLogDirsResult describeLogDirsResult = adminClient.describeLogDirs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(((SetLike)existingBrokers2.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Set$.MODULE$.canBuildFrom())).toSeq()).asJava());
                scala.collection.mutable.Map logDirInfosByBroker = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)describeLogDirsResult.allDescriptions().get()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    Integer k = (Integer)x0$1._1();
                    java.util.Map v = (java.util.Map)x0$1._2();
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), CollectionConverters$.MODULE$.mapAsScalaMapConverter(v).asScala());
                    return tuple2;
                }, Map$.MODULE$.canBuildFrom());
                out.println(new StringBuilder(48).append("Received log directory information from brokers ").append(existingBrokers2.mkString(",")).toString());
                out.println(this.formatAsJson((Map<Integer, Map<String, LogDirDescription>>)logDirInfosByBroker, (Set<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topicList)).toSet()));
            }
        }
    }

    private String formatAsJson(Map<Integer, Map<String, LogDirDescription>> logDirInfosByBroker, Set<String> topicSet) {
        return Json$.MODULE$.encodeAsString(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"brokers"), CollectionConverters$.MODULE$.asJavaIterableConverter((Iterable)logDirInfosByBroker.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Integer broker = (Integer)x0$1._1();
            Map logDirInfos = (Map)x0$1._2();
            java.util.Map map = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker"), (Object)broker), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirs"), CollectionConverters$.MODULE$.asJavaIterableConverter((Iterable)logDirInfos.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                String logDir = (String)x0$2._1();
                LogDirDescription logDirInfo = (LogDirDescription)x0$2._2();
                java.util.Map map = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDir"), (Object)logDir), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), Option$.MODULE$.apply((Object)logDirInfo.error()).map((Function1 & Serializable & scala.Serializable)ex -> ex.getClass().getName()).orNull(Predef$.MODULE$.$conforms())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), CollectionConverters$.MODULE$.asJavaIterableConverter((Iterable)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)LogDirsCommand$.$anonfun$formatAsJson$4(topicSet, x0$3)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    if (x0$4 == null) {
                        throw new MatchError(null);
                    }
                    TopicPartition topicPartition = (TopicPartition)x0$4._1();
                    ReplicaInfo replicaInfo = (ReplicaInfo)x0$4._2();
                    java.util.Map map = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)topicPartition.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)BoxesRunTime.boxToLong((long)replicaInfo.size())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offsetLag"), (Object)BoxesRunTime.boxToLong((long)replicaInfo.offsetLag())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isFuture"), (Object)BoxesRunTime.boxToBoolean((boolean)replicaInfo.isFuture()))}))).asJava();
                    return map;
                }, Iterable$.MODULE$.canBuildFrom())).asJava())}))).asJava();
                return map;
            }, scala.collection.Iterable$.MODULE$.canBuildFrom())).asJava())}))).asJava();
            return map;
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).asJava())}))).asJava());
    }

    private Admin createAdminClient(LogDirsCommand.LogDirsCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt()))) : new Properties();
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        props.putIfAbsent("client.id", "log-dirs-tool");
        return Admin.create((Properties)props);
    }

    public static final /* synthetic */ boolean $anonfun$describe$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$describe$3(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
    }

    public static final /* synthetic */ int $anonfun$describe$4(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$formatAsJson$4(Set topicSet$1, Tuple2 x0$3) {
        if (x0$3 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)x0$3._1();
        boolean bl = topicSet$1.isEmpty() || topicSet$1.contains((Object)topicPartition.topic());
        return bl;
    }

    private LogDirsCommand$() {
        MODULE$ = this;
    }
}

